/*
 * Decompiled with CFR 0.152.
 */
package icy.util;

import icy.image.IcyBufferedImage;
import icy.sequence.MetaDataUtil;
import icy.sequence.Sequence;
import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.type.DataType;
import icy.type.TypeUtil;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadataImpl;
import loci.formats.services.OMEXMLService;
import loci.formats.services.OMEXMLServiceImpl;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.meta.OMEXMLMetadata;
import ome.xml.model.OME;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.XMLAnnotation;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import org.w3c.dom.Document;

public class OMEUtil {
    private static ServiceFactory factory;
    private static OMEXMLService OMEService;

    public static int getValue(PositiveInteger obj, int defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return TypeUtil.getInt((Integer)obj.getValue(), defaultValue);
    }

    public static int getValue(NonNegativeInteger obj, int defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return TypeUtil.getInt((Integer)obj.getValue(), defaultValue);
    }

    public static double getValue(PositiveFloat obj, double defaultValue, boolean allowInfinite) {
        if (obj == null) {
            return defaultValue;
        }
        return TypeUtil.getDouble((Double)obj.getValue(), defaultValue, allowInfinite);
    }

    public static double getValue(PositiveFloat obj, double defaultValue) {
        return OMEUtil.getValue(obj, defaultValue, true);
    }

    public static double getValue(Length obj, double defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        Number value = obj.value(UNITS.MICROMETER);
        if (value == null) {
            return defaultValue;
        }
        return value.doubleValue();
    }

    public static double getValue(Time obj, double defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        Number value = obj.value(UNITS.SECOND);
        if (value == null) {
            return defaultValue;
        }
        return value.doubleValue();
    }

    public static PositiveFloat getPositiveFloat(double value) {
        return new PositiveFloat(value);
    }

    public static PositiveInteger getPositiveInteger(int value) {
        return new PositiveInteger(value);
    }

    public static NonNegativeInteger getNonNegativeInteger(int value) {
        return new NonNegativeInteger(value);
    }

    public static Length getLength(double value) {
        return new Length(value, UNITS.MICROMETER);
    }

    public static Time getTime(double value) {
        return new Time(value, UNITS.SECOND);
    }

    public static java.awt.Color getJavaColor(Color value) {
        if (value == null) {
            return null;
        }
        return new java.awt.Color(value.getRed(), value.getGreen(), value.getBlue(), value.getAlpha());
    }

    public static Color getOMEColor(java.awt.Color value) {
        return new Color(value.getRed(), value.getGreen(), value.getBlue(), value.getAlpha());
    }

    public static synchronized OMEXMLMetadata createOMEXMLMetadata() {
        try {
            return OMEService.createOMEXMLMetadata();
        }
        catch (Exception e) {
            IcyExceptionHandler.showErrorMessage(e, true);
            return null;
        }
    }

    @Deprecated
    public static OMEXMLMetadataImpl createOMEMetadata() {
        return (OMEXMLMetadataImpl)OMEUtil.createOMEXMLMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OMEXMLMetadata createOMEXMLMetadata(ome.xml.meta.MetadataRetrieve metadata, boolean setUserName) {
        OME root;
        StructuredAnnotations annotations;
        OMEXMLMetadata result = OMEUtil.createOMEXMLMetadata();
        if (metadata instanceof OMEXMLMetadata && (annotations = (root = (OME)((Object)((OMEXMLMetadata)metadata).getRoot())).getStructuredAnnotations()) != null) {
            for (int i = annotations.sizeOfXMLAnnotationList() - 1; i >= 0; --i) {
                XMLAnnotation annotation = annotations.getXMLAnnotation(i);
                if (!StringUtil.isEmpty(annotation.getValue())) continue;
                annotations.removeXMLAnnotation(annotation);
            }
        }
        OMEXMLService oMEXMLService = OMEService;
        synchronized (oMEXMLService) {
            OMEService.convertMetadata((MetadataRetrieve)metadata, (MetadataStore)((Object)result));
        }
        if (setUserName) {
            MetaDataUtil.setUserName(result, SystemUtil.getUserName());
        }
        return result;
    }

    public static OMEXMLMetadata createOMEXMLMetadata(ome.xml.meta.MetadataRetrieve metadata) {
        return OMEUtil.createOMEXMLMetadata(metadata, false);
    }

    @Deprecated
    public static synchronized OMEXMLMetadataImpl createOMEMetadata(MetadataRetrieve metadata) {
        return (OMEXMLMetadataImpl)OMEUtil.createOMEXMLMetadata(metadata);
    }

    public static OMEXMLMetadata createOMEXMLMetadata(ome.xml.meta.MetadataRetrieve metadata, int serie) {
        OMEXMLMetadata result = OMEUtil.createOMEXMLMetadata(metadata, false);
        MetaDataUtil.keepSingleSerie(result, serie);
        result.setImageID(MetadataTools.createLSID("Image", serie), 0);
        return result;
    }

    @Deprecated
    public static OMEXMLMetadataImpl createOMEMetadata(MetadataRetrieve metadata, int serie) {
        return (OMEXMLMetadataImpl)OMEUtil.createOMEXMLMetadata((ome.xml.meta.MetadataRetrieve)metadata, serie);
    }

    public static OMEXMLMetadata getOMEXMLMetadata(ome.xml.meta.MetadataRetrieve metadata) {
        if (metadata instanceof OMEXMLMetadata) {
            return (OMEXMLMetadata)metadata;
        }
        return OMEUtil.createOMEXMLMetadata(metadata, false);
    }

    @Deprecated
    public static OMEXMLMetadataImpl getOMEMetadata(MetadataRetrieve metadata) {
        return (OMEXMLMetadataImpl)OMEUtil.getOMEXMLMetadata(metadata);
    }

    public static Document getXMLDocument(OMEXMLMetadata metadata) {
        try {
            return XMLUtil.createDocument(metadata.dumpXML());
        }
        catch (Exception e) {
            IcyExceptionHandler.showErrorMessage(e, true);
            return XMLUtil.createDocument(false);
        }
    }

    @Deprecated
    public static Document getXMLDocument(MetadataRetrieve metadata) {
        return OMEUtil.getXMLDocument(OMEUtil.getOMEXMLMetadata(metadata));
    }

    @Deprecated
    public static OMEXMLMetadataImpl generateMetaData(OMEXMLMetadataImpl metadata, int sizeX, int sizeY, int sizeC, int sizeZ, int sizeT, DataType dataType, boolean separateChannel) {
        OMEXMLMetadata result = metadata == null ? MetaDataUtil.createMetadata("Sample") : metadata;
        MetaDataUtil.setMetaData(result, sizeX, sizeY, sizeC, sizeZ, sizeT, dataType, separateChannel);
        return result;
    }

    @Deprecated
    public static OMEXMLMetadata generateMetaData(int sizeX, int sizeY, int sizeC, int sizeZ, int sizeT, DataType dataType, boolean separateChannel) throws ServiceException {
        return MetaDataUtil.generateMetaData(sizeX, sizeY, sizeC, sizeZ, sizeT, dataType, separateChannel);
    }

    @Deprecated
    public static OMEXMLMetadata generateMetaData(int sizeX, int sizeY, int sizeC, DataType dataType, boolean separateChannel) throws ServiceException {
        return MetaDataUtil.generateMetaData(sizeX, sizeY, sizeC, dataType, separateChannel);
    }

    @Deprecated
    public static OMEXMLMetadata generateMetaData(IcyBufferedImage image, boolean separateChannel) throws ServiceException {
        return MetaDataUtil.generateMetaData(image, separateChannel);
    }

    @Deprecated
    public static OMEXMLMetadata generateMetaData(Sequence sequence, boolean useZ, boolean useT, boolean separateChannel) {
        return MetaDataUtil.generateMetaData(sequence, separateChannel);
    }

    @Deprecated
    public static OMEXMLMetadata generateMetaData(Sequence sequence, int sizeZ, int sizeT, boolean separateChannel) {
        return MetaDataUtil.generateMetaData(sequence, separateChannel);
    }

    @Deprecated
    public static OMEXMLMetadata generateMetaData(Sequence sequence, boolean separateChannel) {
        return MetaDataUtil.generateMetaData(sequence, separateChannel);
    }

    public static boolean reportLociError(String fileName, String errorMessage) {
        return false;
    }

    static {
        try {
            factory = new ServiceFactory();
            OMEService = factory.getInstance(OMEXMLService.class);
        }
        catch (DependencyException e) {
            System.err.println("Error create OME Service:" + e.getMessage());
            System.err.println("Using default service implementation...");
            factory = null;
            OMEService = new OMEXMLServiceImpl();
        }
    }
}

