/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.bcb;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarModel;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathEvent;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathListener;
import org.pushingpixels.flamingo.api.bcb.JBreadcrumbBar;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.JScrollablePanel;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.model.PopupButtonModel;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.internal.ui.bcb.BreadcrumbBarUI;
import org.pushingpixels.flamingo.internal.ui.bcb.BreadcrumbItemChoices;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

public class BasicBreadcrumbBarUI
extends BreadcrumbBarUI {
    protected JBreadcrumbBar breadcrumbBar;
    protected JPanel mainPanel;
    protected JScrollablePanel<JPanel> scrollerPanel;
    protected ComponentListener componentListener;
    protected JCommandButton dummy;
    protected LinkedList modelStack;
    protected LinkedList<JCommandButton> buttonStack;
    protected BreadcrumbPathListener pathListener;
    private AtomicInteger atomicCounter;

    public static ComponentUI createUI(JComponent c) {
        return new BasicBreadcrumbBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.breadcrumbBar = (JBreadcrumbBar)c;
        this.modelStack = new LinkedList();
        this.buttonStack = new LinkedList();
        this.installDefaults(this.breadcrumbBar);
        this.installComponents(this.breadcrumbBar);
        this.installListeners(this.breadcrumbBar);
        c.setLayout(this.createLayoutManager());
        if (this.breadcrumbBar.getCallback() != null) {
            SwingWorker<List<StringValuePair>, Void> worker = new SwingWorker<List<StringValuePair>, Void>(){

                @Override
                protected List<StringValuePair> doInBackground() throws Exception {
                    return BasicBreadcrumbBarUI.this.breadcrumbBar.getCallback().getPathChoices(null);
                }

                @Override
                protected void done() {
                    try {
                        BasicBreadcrumbBarUI.this.pushChoices(new BreadcrumbItemChoices(null, (List)this.get()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            worker.execute();
        }
        this.dummy = new JCommandButton("Dummy", new EmptyResizableIcon(16));
        this.dummy.setDisplayState(CommandButtonDisplayState.MEDIUM);
        this.dummy.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners((JBreadcrumbBar)c);
        this.uninstallComponents((JBreadcrumbBar)c);
        this.uninstallDefaults((JBreadcrumbBar)c);
        this.breadcrumbBar = null;
    }

    protected void installDefaults(JBreadcrumbBar bar) {
        Font currFont = bar.getFont();
        if (currFont == null || currFont instanceof UIResource) {
            FontUIResource font = FlamingoUtilities.getFont(null, "BreadcrumbBar.font", "Button.font", "Panel.font");
            bar.setFont(font);
        }
    }

    protected void installComponents(JBreadcrumbBar bar) {
        this.mainPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.mainPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.mainPanel.setOpaque(false);
        this.scrollerPanel = new JScrollablePanel<JPanel>(this.mainPanel, JScrollablePanel.ScrollType.HORIZONTALLY);
        bar.add(this.scrollerPanel, "Center");
    }

    protected void installListeners(JBreadcrumbBar bar) {
        this.atomicCounter = new AtomicInteger(0);
        this.componentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                BasicBreadcrumbBarUI.this.updateComponents();
            }
        };
        bar.addComponentListener(this.componentListener);
        this.pathListener = new BreadcrumbPathListener(){
            private SwingWorker<Void, Object> pathChangeWorker;

            @Override
            public void breadcrumbPathEvent(BreadcrumbPathEvent event) {
                final int indexOfFirstChange = event.getIndexOfFirstChange();
                if (this.pathChangeWorker != null && !this.pathChangeWorker.isDone()) {
                    this.pathChangeWorker.cancel(true);
                }
                this.pathChangeWorker = new SwingWorker<Void, Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected Void doInBackground() throws Exception {
                        List items;
                        BasicBreadcrumbBarUI.this.atomicCounter.incrementAndGet();
                        BasicBreadcrumbBarUI basicBreadcrumbBarUI = BasicBreadcrumbBarUI.this;
                        synchronized (basicBreadcrumbBarUI) {
                            if (indexOfFirstChange == 0) {
                                (this).BasicBreadcrumbBarUI.this.modelStack.clear();
                            } else {
                                int toLeave = indexOfFirstChange * 2 + 1;
                                while ((this).BasicBreadcrumbBarUI.this.modelStack.size() > toLeave) {
                                    (this).BasicBreadcrumbBarUI.this.modelStack.removeLast();
                                }
                            }
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BasicBreadcrumbBarUI.this.updateComponents();
                            }
                        });
                        if (indexOfFirstChange == 0) {
                            List rootChoices = (this).BasicBreadcrumbBarUI.this.breadcrumbBar.getCallback().getPathChoices(null);
                            BreadcrumbItemChoices bic = new BreadcrumbItemChoices(null, rootChoices);
                            if (!this.isCancelled()) {
                                this.publish(bic);
                            }
                        }
                        if ((items = (this).BasicBreadcrumbBarUI.this.breadcrumbBar.getModel().getItems()) != null) {
                            int itemIndex = indexOfFirstChange;
                            while (itemIndex < items.size()) {
                                if (this.isCancelled()) break;
                                BreadcrumbItem item = items.get(itemIndex);
                                this.publish(item);
                                ArrayList subPath = new ArrayList();
                                int j = 0;
                                while (j <= itemIndex) {
                                    subPath.add(items.get(j));
                                    ++j;
                                }
                                BreadcrumbItemChoices bic = new BreadcrumbItemChoices(item, (this).BasicBreadcrumbBarUI.this.breadcrumbBar.getCallback().getPathChoices(subPath));
                                if (bic.getChoices() != null && bic.getChoices().length > 0) {
                                    this.publish(bic);
                                }
                                ++itemIndex;
                            }
                        }
                        return null;
                    }

                    @Override
                    protected void process(List<Object> chunks) {
                        if (chunks != null) {
                            for (Object chunk : chunks) {
                                if (this.isCancelled() || BasicBreadcrumbBarUI.this.atomicCounter.get() > 1) break;
                                if (chunk instanceof BreadcrumbItemChoices) {
                                    BasicBreadcrumbBarUI.this.pushChoices((BreadcrumbItemChoices)chunk, false);
                                }
                                if (!(chunk instanceof BreadcrumbItem)) continue;
                                BasicBreadcrumbBarUI.this.pushChoice((BreadcrumbItem)chunk, false);
                            }
                        }
                        BasicBreadcrumbBarUI.this.updateComponents();
                    }

                    @Override
                    protected void done() {
                        BasicBreadcrumbBarUI.this.atomicCounter.decrementAndGet();
                    }
                };
                this.pathChangeWorker.execute();
            }
        };
        this.breadcrumbBar.getModel().addPathListener(this.pathListener);
    }

    protected void uninstallDefaults(JBreadcrumbBar bar) {
    }

    protected void uninstallComponents(JBreadcrumbBar bar) {
        this.mainPanel.removeAll();
        this.buttonStack.clear();
        bar.remove(this.scrollerPanel);
    }

    protected void uninstallListeners(JBreadcrumbBar bar) {
        bar.removeComponentListener(this.componentListener);
        this.componentListener = null;
        this.breadcrumbBar.getModel().removePathListener(this.pathListener);
        this.pathListener = null;
    }

    protected LayoutManager createLayoutManager() {
        return new BreadcrumbBarLayout();
    }

    protected synchronized void updateComponents() {
        if (!this.breadcrumbBar.isVisible()) {
            return;
        }
        this.mainPanel.removeAll();
        this.buttonStack.clear();
        int i = 0;
        while (i < this.modelStack.size()) {
            JCommandButton button;
            Object element = this.modelStack.get(i);
            if (element instanceof BreadcrumbItemChoices) {
                BreadcrumbItemChoices bic = (BreadcrumbItemChoices)element;
                if (this.buttonStack.isEmpty()) {
                    button = new JCommandButton("");
                    button.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                    this.configureBreadcrumbButton(button);
                    this.configurePopupAction(button, bic);
                    this.configurePopupRollover(button);
                    this.buttonStack.add(button);
                } else {
                    button = this.buttonStack.getLast();
                    int oldW = button.getPreferredSize().width;
                    button.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
                    this.configurePopupAction(button, bic);
                    this.configurePopupRollover(button);
                }
            } else if (element instanceof BreadcrumbItem) {
                BreadcrumbItemChoices lastBic;
                BreadcrumbItem[] choices;
                BreadcrumbItem bi = (BreadcrumbItem)element;
                button = new JCommandButton(bi.getKey());
                this.configureBreadcrumbButton(button);
                this.configureMainAction(button, bi);
                final Icon icon = bi.getIcon();
                if (icon != null) {
                    button.setIcon(new ResizableIcon(){
                        int iw;
                        int ih;
                        {
                            this.iw = icon2.getIconWidth();
                            this.ih = icon2.getIconHeight();
                        }

                        @Override
                        public void paintIcon(Component c, Graphics g, int x, int y) {
                            int dx = (this.iw - icon.getIconWidth()) / 2;
                            int dy = (this.ih - icon.getIconHeight()) / 2;
                            icon.paintIcon(c, g, x + dx, y + dy);
                        }

                        @Override
                        public int getIconWidth() {
                            return this.iw;
                        }

                        @Override
                        public int getIconHeight() {
                            return this.ih;
                        }

                        @Override
                        public void setDimension(Dimension newDimension) {
                            this.iw = newDimension.width;
                            this.ih = newDimension.height;
                        }
                    });
                }
                if (i > 0 && (choices = (lastBic = (BreadcrumbItemChoices)this.modelStack.get(i - 1)).getChoices()) != null) {
                    int j = 0;
                    while (j < choices.length) {
                        if (bi.getKey().equals(choices[j].getKey())) {
                            lastBic.setSelectedIndex(j);
                            break;
                        }
                        ++j;
                    }
                }
                this.buttonStack.addLast(button);
            }
            ++i;
        }
        for (JCommandButton jcb : this.buttonStack) {
            this.mainPanel.add(jcb);
        }
        this.scrollerPanel.revalidate();
        this.scrollerPanel.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicBreadcrumbBarUI.this.scrollerPanel.scrollToIfNecessary(BasicBreadcrumbBarUI.this.mainPanel.getPreferredSize().width, 0);
                BasicBreadcrumbBarUI.this.scrollerPanel.repaint();
            }
        });
    }

    private void configureMainAction(JCommandButton button, final BreadcrumbItem bi) {
        button.getActionModel().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BreadcrumbBarModel barModel = (this).BasicBreadcrumbBarUI.this.breadcrumbBar.getModel();
                        int itemIndex = barModel.indexOf(bi);
                        int toLeave = itemIndex < 0 ? 0 : itemIndex + 1;
                        barModel.setCumulative(true);
                        while (barModel.getItemCount() > toLeave) {
                            barModel.removeLast();
                        }
                        barModel.setCumulative(false);
                    }
                });
            }
        });
    }

    private void configurePopupAction(JCommandButton button, final BreadcrumbItemChoices bic) {
        button.setPopupCallback(new PopupPanelCallback(){

            @Override
            public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                JCommandPopupMenu popup = new JCommandPopupMenu();
                int i = 0;
                while (i < bic.getChoices().length) {
                    final BreadcrumbItem bi = bic.getChoices()[i];
                    JCommandMenuButton menuButton = new JCommandMenuButton(bi.getKey(), null);
                    final Icon icon = bi.getIcon();
                    if (icon != null) {
                        menuButton.setIcon(new ResizableIcon(){
                            int iw;
                            int ih;
                            {
                                this.iw = icon2.getIconWidth();
                                this.ih = icon2.getIconHeight();
                            }

                            @Override
                            public void paintIcon(Component c, Graphics g, int x, int y) {
                                int dx = (this.iw - icon.getIconWidth()) / 2;
                                int dy = (this.ih - icon.getIconHeight()) / 2;
                                icon.paintIcon(c, g, x + dx, y + dy);
                            }

                            @Override
                            public int getIconWidth() {
                                return this.iw;
                            }

                            @Override
                            public int getIconHeight() {
                                return this.ih;
                            }

                            @Override
                            public void setDimension(Dimension newDimension) {
                                this.iw = newDimension.width;
                                this.ih = newDimension.height;
                            }
                        });
                    }
                    if (i == bic.getSelectedIndex()) {
                        menuButton.setFont(menuButton.getFont().deriveFont(1));
                    }
                    final int biIndex = i++;
                    menuButton.getActionModel().addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (bi == null) {
                                        return;
                                    }
                                    BreadcrumbBarModel barModel = ((this).this).BasicBreadcrumbBarUI.this.breadcrumbBar.getModel();
                                    barModel.setCumulative(true);
                                    int itemIndex = barModel.indexOf(bic.getAncestor());
                                    int toLeave = bic.getAncestor() == null || itemIndex < 0 ? 0 : itemIndex + 1;
                                    while (barModel.getItemCount() > toLeave) {
                                        barModel.removeLast();
                                    }
                                    barModel.addLast(bi);
                                    bic.setSelectedIndex(biIndex);
                                    barModel.setCumulative(false);
                                }
                            });
                        }
                    });
                    popup.addMenuButton(menuButton);
                    menuButton.setCursor(Cursor.getPredefinedCursor(12));
                }
                popup.setMaxVisibleMenuButtons(10);
                return popup;
            }
        });
    }

    private void configurePopupRollover(final JCommandButton button) {
        button.getPopupModel().addChangeListener(new ChangeListener(){
            boolean rollover;
            {
                this.rollover = jCommandButton.getPopupModel().isRollover();
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean isRollover = button.getPopupModel().isRollover();
                        if (isRollover == rollover) {
                            return;
                        }
                        if (isRollover) {
                            for (JCommandButton bcbButton : (this).BasicBreadcrumbBarUI.this.buttonStack) {
                                if (bcbButton == button || !bcbButton.getPopupModel().isPopupShowing()) continue;
                                (this).BasicBreadcrumbBarUI.this.scrollerPanel.scrollToIfNecessary(button.getBounds().x, button.getWidth());
                                button.doPopupClick();
                            }
                        }
                        rollover = isRollover;
                    }
                });
            }
        });
    }

    private void configureBreadcrumbButton(final JCommandButton button) {
        button.setDisplayState(CommandButtonDisplayState.MEDIUM);
        button.setPopupOrientationKind(JCommandButton.CommandButtonPopupOrientationKind.SIDEWARD);
        button.setHGapScaleFactor(0.75);
        button.getPopupModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PopupButtonModel model = button.getPopupModel();
                boolean displayDownwards = model.isRollover() || model.isPopupShowing();
                JCommandButton.CommandButtonPopupOrientationKind popupOrientationKind = displayDownwards ? JCommandButton.CommandButtonPopupOrientationKind.DOWNWARD : JCommandButton.CommandButtonPopupOrientationKind.SIDEWARD;
                button.setPopupOrientationKind(popupOrientationKind);
            }
        });
    }

    protected Object pushChoices(BreadcrumbItemChoices bic) {
        return this.pushChoices(bic, true);
    }

    protected synchronized Object pushChoices(BreadcrumbItemChoices bic, boolean toUpdateUI) {
        if (bic == null) {
            return null;
        }
        if (this.modelStack.size() % 2 == 1) {
            this.modelStack.pop();
        }
        this.modelStack.addLast(bic);
        if (toUpdateUI) {
            this.updateComponents();
        }
        return bic;
    }

    protected synchronized Object pushChoice(BreadcrumbItem bi, boolean toUpdateUI) {
        assert (bi != null);
        if (!this.modelStack.isEmpty() && this.modelStack.size() % 2 == 0) {
            this.modelStack.pop();
        }
        bi.setIndex(this.modelStack.size());
        this.modelStack.addLast(bi);
        return bi;
    }

    protected class BreadcrumbBarLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int buttonHeight = BasicBreadcrumbBarUI.this.dummy.getPreferredSize().height;
            Insets ins = c.getInsets();
            return new Dimension(c.getWidth(), buttonHeight + ins.top + ins.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int buttonHeight = BasicBreadcrumbBarUI.this.dummy.getPreferredSize().height;
            return new Dimension(10, buttonHeight);
        }

        @Override
        public void layoutContainer(Container c) {
            int width = c.getWidth();
            int height = c.getHeight();
            BasicBreadcrumbBarUI.this.scrollerPanel.setBounds(0, 0, width, height);
        }
    }
}

