/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnakeutils.process.process1D;

/**
 * Class that implements some 1D filtering operations.
 * 
 * @version May 3, 2014
 * 
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 */
public class Filters {

	/**
	 * Filters an array with a all-pole recursive filter with periodic boundary
	 * conditions.
	 */
	public static double[] prescaledPeriodic(double[] s, double[] pole) {
		final int N = s.length;
		for (final double z : pole) {
			double z1 = z;
			for (int k = N - 1; (0 < k); k--) {
				s[0] += z1 * s[k];
				z1 *= z;
			}
			s[0] /= 1.0 - z1;
			for (int k = 1; (k < N); k++) {
				s[k] += z * s[k - 1];
			}
			z1 = z;
			final int K = N - 1;
			for (int k = 0; (k < K); k++) {
				s[K] += z1 * s[k];
				z1 *= z;
			}
			s[K] *= 1.0 / (1.0 - z1);
			z1 = 1.0 - z;
			z1 *= z1;
			s[K] *= z1;
			for (int k = N - 2; (0 <= k); k--) {
				s[k] = z * s[k + 1] + z1 * s[k];
			}
		}
		return s;
	}
}
