/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptorFactory;
import io.bioimage.modelrunner.bioimageio.download.DownloadModel;
import io.bioimage.modelrunner.utils.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import javax.net.ssl.HttpsURLConnection;

public class BioimageioRepo {
    private static final String MODELS_NOT_FOUND_MSG = "BioImage.io: Unable to find models.";
    private static final String API_ERR_MSG = "BioImage.io: There has been an error accessing the API. No model retrieved.";
    public static final String LOCATE = "https://uk1s3.embassy.ebi.ac.uk/public-datasets/bioimage.io/all_versions.json";
    private JsonArray collections;
    private static List<String> MODEL_IDS;
    private static LinkedHashMap<String, ModelDescriptor> MODELS;
    private static Map<String, Map<String, Map<String, String>>> MODELS_INFO;
    private Consumer<String> consumer;

    private BioimageioRepo() throws InterruptedException {
        this.setCollectionsRepo();
    }

    private BioimageioRepo(Consumer<String> consumer) throws InterruptedException {
        this.consumer = consumer;
        this.setCollectionsRepo();
    }

    public static BioimageioRepo connect() throws InterruptedException {
        return new BioimageioRepo();
    }

    public static BioimageioRepo connect(Consumer<String> consumer) throws InterruptedException {
        return new BioimageioRepo(consumer);
    }

    public void refresh() {
        MODELS = null;
        this.listAllModels(false);
    }

    public Map<String, ModelDescriptor> listAllModels(boolean verbose) {
        if (MODELS != null && MODELS.entrySet().size() > 0) {
            return MODELS;
        }
        if (verbose) {
            Log.addProgressAndShowInTerminal(this.consumer, "BioImage.io: Accessing the BioImage.io API to retrieve available models", true);
        }
        MODELS = new LinkedHashMap();
        if (this.collections == null) {
            if (verbose) {
                Log.addProgressAndShowInTerminal(this.consumer, MODELS_NOT_FOUND_MSG, true);
            }
            return MODELS;
        }
        for (Object resource : this.collections) {
            if (Thread.interrupted()) break;
            JsonObject jsonResource = (JsonObject)resource;
            try {
                String url;
                if (jsonResource.get("type") == null || !jsonResource.get("type").getAsString().equals("model") || (url = jsonResource.get("versions").getAsJsonArray().asList().stream().max(Comparator.comparingLong(elem -> BioimageioRepo.strToTimestamp(elem.getAsJsonObject().get("created").getAsString()))).map(elem -> elem.getAsJsonObject().get("source").getAsString()).orElseThrow(null)) == null) continue;
                String stringRDF = BioimageioRepo.getJSONFromUrl(url);
                ModelDescriptor descriptor = ModelDescriptorFactory.readFromYamlTextString(stringRDF);
                MODELS.put(url, descriptor);
            }
            catch (Exception ex) {
                if (verbose) {
                    String errMSg = "Could not load descriptor for the Bioimage.io model " + jsonResource.get("concept") + ".";
                    Log.addProgressAndShowInTerminal(this.consumer, errMSg, true);
                }
                ex.printStackTrace();
            }
        }
        return MODELS;
    }

    private void setCollectionsRepo() throws InterruptedException {
        MODEL_IDS = new ArrayList<String>();
        MODELS_INFO = new HashMap<String, Map<String, Map<String, String>>>();
        String text = BioimageioRepo.getJSONFromUrl(LOCATE);
        if (text == null) {
            Log.addProgressAndShowInTerminal(this.consumer, MODELS_NOT_FOUND_MSG, true);
            Log.addProgressAndShowInTerminal(this.consumer, "BioImage.io: Cannot access file: https://uk1s3.embassy.ebi.ac.uk/public-datasets/bioimage.io/all_versions.json", true);
            Log.addProgressAndShowInTerminal(this.consumer, "BioImage.io: Please review the certificates needed to access the website.", true);
            return;
        }
        JsonObject json = null;
        try {
            json = (JsonObject)JsonParser.parseString((String)text);
        }
        catch (Exception ex) {
            this.collections = null;
            Log.addProgressAndShowInTerminal(this.consumer, MODELS_NOT_FOUND_MSG, true);
            return;
        }
        this.collections = (JsonArray)json.get("entries");
        if (this.collections == null) {
            Log.addProgressAndShowInTerminal(this.consumer, MODELS_NOT_FOUND_MSG, true);
            return;
        }
        for (Object resource : this.collections) {
            JsonObject jsonResource = (JsonObject)resource;
            if (jsonResource.get("type") == null || !jsonResource.get("type").getAsString().equals("model")) continue;
            String modelID = jsonResource.get("concept").getAsString();
            MODEL_IDS.add(modelID);
            HashMap vMap = new HashMap();
            for (JsonElement vv : jsonResource.get("versions").getAsJsonArray()) {
                JsonObject vvObject = vv.getAsJsonObject();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("latest", "false");
                map.put("source", vvObject.get("source").getAsString());
                vMap.put(vvObject.get("v").getAsString(), map);
            }
            String lastV = jsonResource.get("versions").getAsJsonArray().asList().stream().max(Comparator.comparingLong(elem -> BioimageioRepo.strToTimestamp(elem.getAsJsonObject().get("created").getAsString()))).map(elem -> elem.getAsJsonObject().get("v").getAsString()).orElseThrow(null);
            ((Map)vMap.get(lastV)).put("latest", "true");
            MODELS_INFO.put(modelID, vMap);
        }
    }

    public static ModelDescriptor retreiveDescriptorFromURL(String rdfSource) throws InterruptedException {
        ModelDescriptor descriptor = null;
        String stringRDF = BioimageioRepo.getJSONFromUrl(rdfSource);
        if (stringRDF == null) {
            return descriptor;
        }
        try {
            descriptor = ModelDescriptorFactory.readFromYamlTextString(stringRDF);
        }
        catch (Exception ex) {
            System.err.println(rdfSource);
            ex.printStackTrace();
            return descriptor;
        }
        return descriptor;
    }

    public static String getJSONFromUrl(String url) throws InterruptedException {
        return BioimageioRepo.getJSONFromUrl(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getJSONFromUrl(String url, Consumer<String> consumer) throws InterruptedException {
        HttpURLConnection con = null;
        try {
            int length;
            URL u = new URL(url);
            con = (HttpsURLConnection)u.openConnection();
            con.connect();
            InputStream inputStream = con.getInputStream();
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new InterruptedException("Thread connecting to the Bioimage.io interrupted forcibly.");
            }
            String txt = result.toString("UTF-8");
            inputStream.close();
            result.close();
            String string = txt;
            return string;
        }
        catch (IOException ex) {
            Log.addProgressAndShowInTerminal(consumer, API_ERR_MSG, true);
            ex.printStackTrace();
        }
        finally {
            if (con != null) {
                try {
                    con.disconnect();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public static Path createPathFromURLString(String downloadUrl) {
        Path path;
        try {
            if (downloadUrl.startsWith("https://")) {
                downloadUrl = downloadUrl.substring("https://".length());
            } else if (downloadUrl.startsWith("http://")) {
                downloadUrl = downloadUrl.substring("http://".length());
            }
            path = new File(downloadUrl).toPath();
        }
        catch (Exception ex) {
            int startName = downloadUrl.lastIndexOf("/");
            downloadUrl = downloadUrl.substring(startName + 1);
            path = new File(downloadUrl).toPath();
        }
        return path;
    }

    public static List<String> getModelIDs() {
        if (MODEL_IDS == null || MODEL_IDS.size() == 0) {
            try {
                BioimageioRepo.connect();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (MODEL_IDS == null) {
            return new ArrayList<String>();
        }
        return MODEL_IDS;
    }

    public static boolean isModelOnTheBioengineById(String id) {
        return false;
    }

    public ModelDescriptor selectByID(String modelID) {
        Objects.requireNonNull(modelID, "Argument 'modelID' cannot be null.");
        Map.Entry modelEntry = this.listAllModels(false).entrySet().stream().filter(ee -> {
            String id = ((ModelDescriptor)ee.getValue()).getModelID();
            String nickname = ((ModelDescriptor)ee.getValue()).getNickname();
            if (id.length() - id.replace("/", "").length() == 2) {
                id = id.substring(0, id.lastIndexOf("/"));
            }
            if (modelID.length() - modelID.replace("/", "").length() == 2) {
                return modelID.substring(0, modelID.lastIndexOf("/")).equals(id) || modelID.equals(nickname);
            }
            return modelID.equals(id) || modelID.equals(nickname);
        }).findFirst().orElse(null);
        if (modelEntry != null) {
            return (ModelDescriptor)modelEntry.getValue();
        }
        return null;
    }

    public ModelDescriptor selectByName(String name) {
        Objects.requireNonNull(name, "Argument 'name' cannot be null.");
        Map.Entry modelEntry = this.listAllModels(false).entrySet().stream().filter(ee -> ((ModelDescriptor)ee.getValue()).getName().equals(name)).findFirst().orElse(null);
        if (modelEntry != null) {
            return (ModelDescriptor)modelEntry.getValue();
        }
        return null;
    }

    public static String downloadModel(ModelDescriptor descriptor, String modelsDirectory) throws IOException, InterruptedException {
        return BioimageioRepo.downloadModel(descriptor, modelsDirectory, null);
    }

    public static String downloadModel(ModelDescriptor descriptor, String modelsDirectory, Consumer<Double> consumer) throws IOException, InterruptedException {
        DownloadModel dm = DownloadModel.build(descriptor, modelsDirectory);
        dm.setProgressConsumer(consumer);
        try {
            dm.downloadModel();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return dm.getModelFolder();
    }

    public String downloadModelByID(String id, String modelsDirectory) throws IOException, InterruptedException {
        ModelDescriptor model = this.selectByID(id);
        if (model == null) {
            throw new IllegalArgumentException("The provided id does not correspond to an existing model in the Bioimage.io online repo.");
        }
        return BioimageioRepo.downloadModel(model, modelsDirectory, null);
    }

    public String downloadModelByID(String id, String modelsDirectory, Consumer<Double> consumer) throws IOException, InterruptedException {
        ModelDescriptor model = this.selectByID(id);
        if (model == null) {
            throw new IllegalArgumentException("The provided id does not correspond to an existing model in the Bioimage.io online repo.");
        }
        return BioimageioRepo.downloadModel(model, modelsDirectory, consumer);
    }

    public String downloadByName(String name, String modelsDirectory) throws IOException, InterruptedException {
        ModelDescriptor model = this.selectByName(name);
        if (model == null) {
            throw new IllegalArgumentException("The provided name does not correspond to an existing model in the Bioimage.io online repo.");
        }
        return BioimageioRepo.downloadModel(model, modelsDirectory, null);
    }

    public String downloadByName(String name, String modelsDirectory, Consumer<Double> consumer) throws IOException, InterruptedException {
        ModelDescriptor model = this.selectByName(name);
        if (model == null) {
            throw new IllegalArgumentException("The provided name does not correspond to an existing model in the Bioimage.io online repo.");
        }
        return BioimageioRepo.downloadModel(model, modelsDirectory, consumer);
    }

    private static long strToTimestamp(String str) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        LocalDateTime localDateTime = LocalDateTime.parse(str, formatter);
        Timestamp timestamp = Timestamp.valueOf(localDateTime);
        return timestamp.getTime();
    }

    public static String getModelURL(String id) {
        return BioimageioRepo.getModelRdfUrl(id, null);
    }

    public static String getModelRdfUrl(String id, String version) {
        String rdfURL;
        if (MODELS_INFO == null || MODELS_INFO.get(id) == null) {
            try {
                BioimageioRepo.connect();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (MODELS_INFO.get(id) == null) {
            return null;
        }
        if (version == null) {
            rdfURL = (String)MODELS_INFO.get(id).values().stream().filter(val -> ((String)val.get("latest")).equals("true")).findFirst().get().get("source");
        } else if (version != null && MODELS_INFO.get(id).get(version) != null) {
            rdfURL = MODELS_INFO.get(id).get(version).get("source");
        } else {
            return null;
        }
        if (rdfURL == null) {
            return null;
        }
        return rdfURL.substring(0, rdfURL.length() - "rdf.yaml".length());
    }

    public static void main(String[] args) throws InterruptedException {
        BioimageioRepo br = new BioimageioRepo();
        br.listAllModels(false);
    }
}

