/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.model.processing;

import io.bioimage.modelrunner.apposed.appose.Types;
import io.bioimage.modelrunner.bioimageio.description.TransformSpec;
import io.bioimage.modelrunner.tensor.Tensor;
import io.bioimage.modelrunner.transformations.BinarizeTransformation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Cast;

public class TransformationInstance {
    private final String name;
    private final Map<String, Object> args;
    private Class<?> cls;
    private Object instance;
    private static final String TRANSFORMATIONS_PACKAGE = BinarizeTransformation.class.getPackage().getName();
    private static final String RUN_NAME = "apply";
    private static final String RUN_INPLACE_NAME = "applyInPlace";

    protected TransformationInstance(TransformSpec transform) throws RuntimeException, IllegalArgumentException {
        this.name = transform.getName();
        this.args = transform.getKwargs();
        this.build();
    }

    public static TransformationInstance create(TransformSpec transform) throws RuntimeException, IllegalArgumentException {
        return new TransformationInstance(transform);
    }

    public <T extends RealType<T> & NativeType<T>, R extends RealType<R> & NativeType<R>> List<Tensor<R>> run(Tensor<T> tensor) throws RuntimeException {
        return this.run(tensor, false);
    }

    public <T extends RealType<T> & NativeType<T>, R extends RealType<R> & NativeType<R>> List<Tensor<R>> run(Tensor<T> tensor, boolean inplace) throws RuntimeException {
        try {
            if (inplace) {
                Method m = this.cls.getMethod(RUN_INPLACE_NAME, Tensor.class);
                m.invoke(this.instance, tensor);
                return Collections.singletonList((Tensor)Cast.unchecked(tensor));
            }
            Method m = this.cls.getMethod(RUN_NAME, Tensor.class);
            Object result = m.invoke(this.instance, tensor);
            if (result == null) {
                return null;
            }
            if (result instanceof List) {
                List resultList = (List)result;
                ArrayList<Tensor<R>> outputList = new ArrayList<Tensor<R>>();
                for (Object item : resultList) {
                    if (item instanceof Tensor) {
                        Tensor tensorItem = (Tensor)item;
                        outputList.add(tensorItem);
                        continue;
                    }
                    throw new RuntimeException("Invalid return type: Expected Tensor but got " + (item != null ? item.getClass().getName() : "null"));
                }
                return outputList;
            }
            if (result instanceof Tensor) {
                Tensor tensorResult = (Tensor)result;
                return Collections.singletonList(tensorResult);
            }
            throw new RuntimeException("Unexpected return type: " + (result != null ? result.getClass().getName() : "null"));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(Types.stackTrace(e));
        }
    }

    private void build() {
        this.getTransformationClass();
        this.createInstanceWithArgs();
    }

    private void getTransformationClass() throws RuntimeException {
        String javaMethodName = TransformationInstance.snakeCaseToCamelCaseFirstCap(this.name) + "Transformation";
        String clsName = TRANSFORMATIONS_PACKAGE + "." + javaMethodName;
        this.findClassInClassPath(clsName);
        try {
            this.cls = this.getClass().getClassLoader().loadClass(clsName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(Types.stackTrace(e));
        }
    }

    private void findClassInClassPath(String clsName) throws IllegalArgumentException {
        try {
            Class.forName(clsName, false, TransformationInstance.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Invalid method '" + this.name + "' in the specs file. The method does not exist in the Bioimage.io framework.");
        }
    }

    public static String snakeCaseToCamelCaseFirstCap(String str) {
        while (str.contains("_")) {
            str = str.replaceFirst("_[a-z]", String.valueOf(Character.toUpperCase(str.charAt(str.indexOf("_") + 1))));
        }
        str = str.substring(0, 1).toUpperCase() + str.substring(1);
        return str;
    }

    private void createInstanceWithArgs() throws RuntimeException {
        try {
            this.instance = this.cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(Types.stackTrace(e));
        }
        for (String kk : this.args.keySet()) {
            this.setArg(kk);
        }
    }

    private void setArg(String argName) {
        Method mm = this.getMethodForArgument(argName);
        this.checkArgType(mm);
        try {
            mm.invoke(this.instance, this.args.get(argName));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(Types.stackTrace(e));
        }
    }

    private Method getMethodForArgument(String argName) throws IllegalArgumentException {
        Method[] methods;
        String mName = "set" + TransformationInstance.snakeCaseToCamelCaseFirstCap(argName);
        for (Method mm : methods = this.cls.getMethods()) {
            if (!mm.getName().equals(mName)) continue;
            return mm;
        }
        throw new IllegalArgumentException("Setter for argument '" + argName + "' of the processing transformation '" + this.name + "' not found in the Java transformation class '" + this.cls + "'. A method called '" + mName + "' should be present.");
    }

    private void checkArgType(Method mm) throws IllegalArgumentException {
        Parameter[] pps = mm.getParameters();
        if (pps.length == 1 && pps[0].getType() == Object.class) {
            return;
        }
        throw new IllegalArgumentException("Setter '" + mm.getName() + "' should have only one input parameter with type Object.class.");
    }
}

