/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.transformations;

import io.bioimage.modelrunner.apposed.appose.Mamba;
import io.bioimage.modelrunner.apposed.appose.MambaInstallException;
import io.bioimage.modelrunner.numpy.DecodeNumpy;
import io.bioimage.modelrunner.runmode.RunMode;
import io.bioimage.modelrunner.runmode.ops.GenericOp;
import io.bioimage.modelrunner.system.PlatformDetection;
import io.bioimage.modelrunner.tensor.Tensor;
import io.bioimage.modelrunner.transformations.AbstractTensorTransformation;
import io.bioimage.modelrunner.utils.YAMLUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Cast;
import org.apache.commons.compress.archivers.ArchiveException;

public class PythonTransformation
extends AbstractTensorTransformation {
    public static final String NAME = "python";
    public static final String ENV_YAML_KEY = "env_yaml";
    public static final String SCRIPT_KEY = "script";
    public static final String N_OUTPUTS_KEY = "n_outputs";
    public static final String KWARGS_KEY = "kwargs";
    public static final String METHOD_KEY = "kwargs";
    public static final String MAMBA_PATH_KEY = "mamba_path";
    public static final String SCRIPT_FILE_PATH_KEY = "script_file_path";
    public static final String ENV_YAML_FILE_PATH_KEY = "env_yaml_file_path";
    public static final String ENV_PATH_KEY = "env_path";
    private static final String MAMBA_RELATIVE_PATH = PlatformDetection.isWindows() ? File.separator + "Library" + File.separator + "bin" + File.separator + "micromamba.exe" : File.separator + "bin" + File.separator + "micromamba";
    private static final String PYTHON_COMMAND = PlatformDetection.isWindows() ? "python.exe" : "bin/python";
    private static final String CONDA_RELATIVE_PATH = PlatformDetection.isWindows() ? File.separator + "Library" + File.separator + "bin" + File.separator + "micromamba.exe" : File.separator + "bin" + File.separator + "micromamba";
    private String envYaml = "stardist.yaml";
    private String script = "stardist_postprocessing.py";
    private String method = "stardist_postprocessing";
    private String envYamlFilePath = "";
    private String scriptFilePath = "";
    private String mambaPath = "";
    private String envPath = "";
    private int nOutputs = 1;
    private boolean install = false;
    private Map<String, Object> kwargs = new LinkedHashMap<String, Object>();

    public PythonTransformation() {
        super(NAME);
        this.kwargs.put("prob_thresh", 0.6924782541382084);
        this.kwargs.put("nms_thresh", 0.3);
    }

    public void setInstall(Object install) {
        if (install instanceof Boolean) {
            this.install = (Boolean)install;
        } else if (install.getClass().equals(Boolean.TYPE)) {
            this.install = (Boolean)install;
        } else {
            throw new IllegalArgumentException("'install' parameter has to be an instance of " + Boolean.class + ". The provided argument is an instance of: " + install.getClass());
        }
    }

    public void setEnvYamlFilePath(Object envYamlFilePath) {
        if (!(envYamlFilePath instanceof String)) {
            throw new IllegalArgumentException("'envYamlFilePath' parameter has to be an instance of " + String.class + ". The provided argument is an instance of: " + envYamlFilePath.getClass());
        }
        this.envYamlFilePath = (String)envYamlFilePath;
    }

    public void setMambaPath(Object mambaDir) {
        if (!(mambaDir instanceof String)) {
            throw new IllegalArgumentException("'mambaDir' parameter has to be an instance of " + String.class + ". The provided argument is an instance of: " + mambaDir.getClass());
        }
        this.mambaPath = (String)mambaDir;
    }

    public void setEnvPath(Object envDir) {
        if (!(envDir instanceof String)) {
            throw new IllegalArgumentException("'envDir' parameter has to be an instance of " + String.class + ". The provided argument is an instance of: " + envDir.getClass());
        }
        this.envPath = (String)envDir;
    }

    public void setScriptFilePath(Object scriptFilePath) {
        if (!(scriptFilePath instanceof String)) {
            throw new IllegalArgumentException("'scriptFilePath' parameter has to be an instance of " + String.class + ". The provided argument is an instance of: " + scriptFilePath.getClass());
        }
        this.scriptFilePath = (String)scriptFilePath;
    }

    public void setEnvYaml(Object envYaml) {
        if (!(envYaml instanceof String)) {
            throw new IllegalArgumentException("'envYaml' parameter has to be an instance of " + String.class + ". The provided argument is an instance of: " + envYaml.getClass());
        }
        this.envYaml = new File(String.valueOf(envYaml)).getAbsolutePath();
    }

    public void setScript(Object script) {
        if (!(script instanceof String)) {
            throw new IllegalArgumentException("'script' parameter has to be an instance of " + String.class + ". The provided argument is an instance of: " + script.getClass());
        }
        this.script = new File(String.valueOf(script)).getAbsolutePath();
    }

    public void setMethod(Object method) {
        if (!(method instanceof String)) {
            throw new IllegalArgumentException("'method' parameter has to be an instance of " + String.class + ". The provided argument is an instance of: " + method.getClass());
        }
        this.method = String.valueOf(method);
    }

    public void setNOutputs(Object nOutputs) {
        if (!(Number.class.isAssignableFrom(nOutputs.getClass()) || nOutputs.getClass().isPrimitive() && !String.class.isAssignableFrom(nOutputs.getClass()))) {
            throw new IllegalArgumentException("'nOutputs' parameter has to be a number. The provided argument is an instance of: " + nOutputs.getClass());
        }
        this.nOutputs = (Integer)nOutputs;
    }

    public void setKwargs(Object kwargs) {
        if (kwargs == null) {
            this.kwargs = new LinkedHashMap<String, Object>();
            return;
        }
        if (!(kwargs instanceof Map)) {
            throw new IllegalArgumentException("'kwargs' parameter has to be an instance of " + Map.class + ". The provided argument is an instance of: " + kwargs.getClass());
        }
        this.kwargs = (Map)kwargs;
    }

    private void checkArgs() throws IOException, InterruptedException, ArchiveException, URISyntaxException, RuntimeException, MambaInstallException {
        if (!new File(this.script).isFile() && !new File(this.scriptFilePath).exists()) {
            throw new IllegalArgumentException();
        }
        if (!new File(this.script).isFile() && new File(this.scriptFilePath).isDirectory() && !new File(new File(this.scriptFilePath).getAbsolutePath(), new File(this.script).getName()).isFile()) {
            throw new IllegalArgumentException();
        }
        if (new File(this.scriptFilePath).isFile()) {
            this.script = this.scriptFilePath;
        } else if (new File(this.scriptFilePath).isDirectory() && new File(new File(this.scriptFilePath).getAbsolutePath(), new File(this.script).getName()).isFile()) {
            this.script = new File(new File(this.scriptFilePath).getAbsolutePath(), new File(this.script).getName()).getAbsolutePath();
        }
        if (this.envPath != null && !new File(this.envPath + File.separator + PYTHON_COMMAND).isFile()) {
            throw new IllegalArgumentException();
        }
        if (this.envPath == null) {
            throw new IllegalArgumentException();
        }
        if (this.envPath != null) {
            return;
        }
        if (!new File(this.envYaml).isFile() && !new File(this.envYamlFilePath).exists()) {
            throw new IllegalArgumentException();
        }
        if (!new File(this.envYaml).isFile() && new File(this.envYamlFilePath).isDirectory() && !new File(new File(this.envYamlFilePath).getAbsolutePath(), new File(this.envYaml).getName()).isFile()) {
            throw new IllegalArgumentException();
        }
        if (new File(this.envYamlFilePath).isFile()) {
            this.envYaml = this.envYamlFilePath;
        } else if (new File(this.envYamlFilePath).isDirectory() && new File(new File(this.envYamlFilePath).getAbsolutePath(), new File(this.envYaml).getName()).isFile()) {
            this.envYaml = new File(new File(this.envYamlFilePath).getAbsolutePath(), new File(this.envYaml).getName()).getAbsolutePath();
        }
        if (this.mambaPath == null && !this.install) {
            throw new IllegalArgumentException();
        }
        if (this.mambaPath != null && new File(this.mambaPath + MAMBA_RELATIVE_PATH).exists() && !this.install) {
            throw new IllegalArgumentException();
        }
        if (this.mambaPath == null || !new File(this.mambaPath + MAMBA_RELATIVE_PATH).exists()) {
            this.installMamba();
        }
        String envName = null;
        try {
            envName = (String)YAMLUtils.load(this.envYaml).get("name");
        }
        catch (IOException e) {
            throw new IOException("Unable read the environemnt name from the environment .yaml file." + System.lineSeparator() + e.toString());
        }
        this.envPath = this.mambaPath + File.separator + "envs" + File.separator + envName;
        if (!new File(this.mambaPath + File.separator + "envs" + File.separator + envName).exists() && !this.install) {
            throw new IllegalArgumentException();
        }
        if (!new File(this.mambaPath + File.separator + "envs" + File.separator + envName).exists()) {
            this.installEnv();
        }
    }

    @Override
    public <R extends RealType<R> & NativeType<R>> Tensor<FloatType> apply(Tensor<R> input) {
        Map<String, Object> resMap;
        RunMode rm;
        try {
            this.checkArgs();
        }
        catch (MambaInstallException | IOException | InterruptedException | RuntimeException | URISyntaxException | ArchiveException e2) {
            e2.printStackTrace();
            return (Tensor)Cast.unchecked(input);
        }
        GenericOp op = GenericOp.create(new File(this.envPath).getAbsolutePath(), new File(this.script).getAbsolutePath(), this.method, this.nOutputs);
        LinkedHashMap<String, Object> nMap = new LinkedHashMap<String, Object>();
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("ddMMYYYY_HHmmss");
        String dateString = sdf.format(cal.getTime());
        nMap.put("input_" + dateString, input.getData());
        nMap.putAll(this.kwargs);
        op.setInputs(nMap);
        try {
            rm = RunMode.createRunMode(op);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return (Tensor)Cast.unchecked(input);
        }
        try {
            resMap = rm.runOP();
        }
        catch (IOException | InterruptedException e3) {
            e3.printStackTrace();
            return (Tensor)Cast.unchecked(input);
        }
        RandomAccessibleInterval outImg = (RandomAccessibleInterval)resMap.entrySet().stream().map(e -> e.getValue()).collect(Collectors.toList()).get(0);
        String axes = "yx";
        if (input.getAxesOrder().length == 5) {
            axes = "zyx";
        }
        return Tensor.build("output", axes, outImg);
    }

    @Override
    public <R extends RealType<R> & NativeType<R>> void applyInPlace(Tensor<R> input) {
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        PythonTransformation pt = new PythonTransformation();
        String fname = "C:\\Users\\angel\\OneDrive\\Documentos\\pasteur\\git\\deep-icy\\models\\stardist\\test_output.npy";
        RandomAccessibleInterval img = DecodeNumpy.loadNpy(fname);
        Tensor tt = Tensor.build("output", "bcyx", img);
        Tensor<FloatType> out = pt.apply(tt);
        System.out.println();
    }

    public void installMamba() throws IOException, InterruptedException, ArchiveException, URISyntaxException, MambaInstallException {
        this.mambaPath = new File("appose_" + PlatformDetection.getArch()).getAbsolutePath();
        new Mamba(this.mambaPath);
    }

    public static void installMamba(String dir) throws IOException, InterruptedException, ArchiveException, URISyntaxException, MambaInstallException {
        String mambaDir = new File(dir + File.separator + "appose_" + PlatformDetection.getArch()).getAbsolutePath();
        new Mamba(mambaDir);
    }

    private void installEnv() throws RuntimeException, IOException, InterruptedException, ArchiveException, URISyntaxException, MambaInstallException {
        Mamba conda = new Mamba(this.mambaPath);
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList("env", "create", "--prefix", this.envPath + File.separator + "envs", "--force", "--file", this.envYaml, "-y"));
        conda.runMamba((String[])cmd.stream().toArray(String[]::new));
    }
}

