/*
 * Decompiled with CFR 0.152.
 */
package icy.type.collection.list;

import icy.file.FileUtil;
import icy.preferences.XMLPreferences;
import icy.type.collection.list.RecentList;
import icy.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class RecentFileList
extends RecentList {
    protected static final int NB_MAX_ENTRY = 10;
    protected static final int NB_MAX_FILE = 1000;
    protected static final String ID_NB_FILE = "nbFile";
    protected static final String ID_FILE = "file";

    public RecentFileList(XMLPreferences preferences) {
        super(preferences, 10);
        this.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(String[] paths) {
        if (paths.length > 1000) {
            return;
        }
        String[] adjPaths = RecentFileList.adjust(paths);
        int ind = this.find(adjPaths);
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (ind != -1) {
                this.list.remove(ind);
            }
        }
        super.addEntry(adjPaths);
    }

    private static String[] adjust(String[] paths) {
        String[] result = new String[paths.length];
        int i = 0;
        while (i < paths.length) {
            result[i] = FileUtil.getGenericPath(paths[i]);
            ++i;
        }
        return result;
    }

    public void addEntry(File[] files) {
        if (files.length > 1000) {
            return;
        }
        String[] filenames = new String[files.length];
        int i = 0;
        while (i < files.length) {
            filenames[i] = files[i].getAbsolutePath();
            ++i;
        }
        this.addEntry(filenames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int find(String[] filenames) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.list.size()) {
                if (Arrays.equals((String[])this.list.get(i), filenames)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public String[] getEntry(int index) {
        return (String[])super.getEntry(index);
    }

    public File[] getEntryAsFiles(int index) {
        String[] filenames = this.getEntry(index);
        File[] result = new File[filenames.length];
        int i = 0;
        while (i < filenames.length) {
            result[i] = new File(filenames[i]);
            ++i;
        }
        return result;
    }

    public String getEntryAsName(int index, int maxlen, boolean tailLimit) {
        String[] filenames = this.getEntry(index);
        if (filenames == null || filenames.length == 0) {
            return "";
        }
        if (filenames.length == 1) {
            return StringUtil.limit(filenames[0], maxlen, tailLimit);
        }
        String result = filenames[0];
        int i = 1;
        while (i < filenames.length) {
            result = String.valueOf(result) + ", " + FileUtil.getFileName(filenames[i]);
            ++i;
        }
        return "[" + StringUtil.limit(result, maxlen, tailLimit) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        int i = this.list.size() - 1;
        while (i >= 0) {
            File[] files = this.getEntryAsFiles(i);
            boolean allExists = true;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                allExists = allExists && file.exists();
                ++n2;
            }
            ArrayList arrayList = this.list;
            synchronized (arrayList) {
                if (!allExists) {
                    this.list.remove(i);
                }
            }
            --i;
        }
        this.save();
        this.changed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] loadEntry(String key) {
        XMLPreferences pref;
        if (this.preferences.nodeExists(key) && (pref = this.preferences.node(key)) != null) {
            XMLPreferences xMLPreferences = pref;
            synchronized (xMLPreferences) {
                int numFile = pref.getInt(ID_NB_FILE, 0);
                String[] result = new String[numFile];
                int i = 0;
                while (i < numFile) {
                    result[i] = pref.get(ID_FILE + i, "");
                    ++i;
                }
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveEntry(String key, Object value) {
        XMLPreferences pref = this.preferences.node(key);
        if (pref != null) {
            XMLPreferences xMLPreferences = pref;
            synchronized (xMLPreferences) {
                pref.removeChildren();
                if (value != null) {
                    String[] filenames = (String[])value;
                    int numFile = filenames.length;
                    pref.putInt(ID_NB_FILE, numFile);
                    int i = 0;
                    while (i < numFile) {
                        pref.put(ID_FILE + i, filenames[i]);
                        ++i;
                    }
                } else {
                    pref.putInt(ID_NB_FILE, 0);
                }
                pref.clean();
            }
        }
    }
}

