/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui;

import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.gui.DefaultIcon;
import io.bioimage.modelrunner.gui.LogoPanel;
import io.bioimage.modelrunner.gui.ModelCard;
import io.bioimage.modelrunner.gui.ModelSelectionPanelGui;
import io.bioimage.modelrunner.gui.adapter.GuiAdapter;
import io.bioimage.modelrunner.gui.workers.ModelInfoWorker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ContentPanel
extends JPanel {
    private final URL defaultLogoURL;
    private boolean isUnsupported = false;
    private LogoPanel exampleImageLabel;
    private JLabel exampleTitleLabel;
    private JLabel unsupportedLabel;
    protected JLabel infoTitleLabel;
    private JEditorPane modelInfoArea;
    private JProgressBar progressBar;
    private JLabel progressInfoLabel;
    private JScrollPane infoScrollPane;
    private static final double BAR_RATIO = 0.05;
    private static final double LABEL_RATIO = 0.05;
    private static final long serialVersionUID = -7691139174208436363L;

    protected ContentPanel() {
        this((GuiAdapter)null);
    }

    protected ContentPanel(GuiAdapter adapter) {
        super(null);
        this.defaultLogoURL = adapter == null ? null : ContentPanel.class.getClassLoader().getResource(adapter.getIconPath());
        this.unsupportedLabel = new JLabel("UNSUPPORTED", 0);
        this.unsupportedLabel.setFont(new Font("SansSerif", 1, 16));
        this.unsupportedLabel.setForeground(ModelCard.UNSUPPORTED_FG_COLOR);
        this.unsupportedLabel.setBackground(ModelCard.UNSUPPORTED_BG_COLOR);
        this.unsupportedLabel.setOpaque(true);
        this.unsupportedLabel.setBorder(BorderFactory.createEtchedBorder());
        this.unsupportedLabel.setVisible(true);
        this.exampleTitleLabel = new JLabel("Cover Image");
        this.exampleTitleLabel.setFont(new Font("SansSerif", 1, 24));
        this.exampleImageLabel = new LogoPanel();
        this.infoTitleLabel = new JLabel("Model Information");
        this.infoTitleLabel.setFont(new Font("SansSerif", 1, 18));
        this.modelInfoArea = new JEditorPane("text/html", "Detailed model description...");
        this.modelInfoArea.setEditable(false);
        this.modelInfoArea.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.infoScrollPane = new JScrollPane(this.modelInfoArea);
        this.createProgressBar();
        this.add(this.unsupportedLabel);
        this.add(this.exampleImageLabel);
        this.add(this.exampleTitleLabel);
        this.add(this.infoTitleLabel);
        this.add(this.progressBar);
        this.add(this.progressInfoLabel);
        this.add(this.infoScrollPane);
        this.hookImageListener();
        this.organiseComponents();
    }

    private void organiseComponents() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int rawW = ContentPanel.this.getWidth();
                int rawH = ContentPanel.this.getHeight();
                int inset = 4;
                int xRight = inset + rawW / 2;
                int spaceX = rawW / 2 - inset * 2;
                ContentPanel.this.leftSideGUI(rawH, rawW, spaceX, inset);
                ContentPanel.this.rightSideGUI(rawH, rawW, inset, spaceX, xRight);
            }
        });
    }

    private void rightSideGUI(int rawH, int rawW, int inset, int spaceX, int xRight) {
        Dimension rightLabelSize = this.infoTitleLabel.getPreferredSize();
        int labelPosX = Math.max(xRight, 3 * rawW / 4 - rightLabelSize.width / 2);
        int labelW = Math.max(1, Math.min(rightLabelSize.width, rawW / 2 + spaceX + 2 * inset - labelPosX));
        this.infoTitleLabel.setBounds(labelPosX, inset, labelW, rightLabelSize.height);
        double barHeight = Math.max(1.0, (double)rawH * 0.05);
        double strHeight = Math.max(1.0, (double)rawH * 0.05);
        int barInset = 2;
        double hPanel = (double)(rawH - barInset - 4 * inset) - barHeight - strHeight - (double)rightLabelSize.height;
        double wPanel = rawW / 2 - inset * 2;
        int posY = 2 * inset + rightLabelSize.height;
        wPanel = Math.max(1.0, wPanel);
        hPanel = Math.max(1.0, hPanel);
        barHeight = Math.max(5.0, barHeight);
        strHeight = Math.max(1.0, strHeight);
        this.infoScrollPane.setBounds(xRight, posY, (int)wPanel, (int)hPanel);
        posY = (int)((double)posY + (hPanel + (double)inset));
        this.progressBar.setBounds(xRight, posY, (int)wPanel, (int)barHeight);
        posY = (int)((double)posY + (barHeight + (double)barInset));
        this.progressInfoLabel.setBounds(xRight, posY, (int)wPanel, (int)strHeight);
    }

    private void leftSideGUI(int H, int W, int spaceX, int inset) {
        int posx;
        int posY;
        double newW;
        double newH;
        int imW;
        int imH;
        int xLeft = inset;
        Dimension leftLabelSize = this.exampleTitleLabel.getPreferredSize();
        int labelPosX = Math.max(xLeft, W / 4 - leftLabelSize.width / 2);
        int titleW = Math.min(leftLabelSize.width, spaceX + inset - labelPosX);
        titleW = Math.max(1, titleW);
        this.exampleTitleLabel.setBounds(labelPosX, inset, titleW, leftLabelSize.height);
        BufferedImage im = this.exampleImageLabel.getImage();
        if (im == null) {
            imH = this.exampleImageLabel.getPreferredSize().height;
            imW = this.exampleImageLabel.getPreferredSize().width;
        } else {
            imH = im.getHeight();
            imW = im.getWidth();
        }
        double ratio = (double)imH / (double)imW;
        if (ratio > 1.0) {
            newH = H - inset * 3 - leftLabelSize.height;
            newW = newH / ratio;
            posY = leftLabelSize.height + inset * 2;
            posx = (int)((double)(inset + spaceX / 2) - newW / 2.0);
            if (posx < 0) {
                newW = spaceX;
                newH = newW * ratio;
                posx = inset;
                posY = (int)((double)((H - 3 * inset - leftLabelSize.height) / 2 + 2 * inset + leftLabelSize.height) - newH / 2.0);
            }
        } else {
            newW = spaceX;
            newH = newW * ratio;
            posx = inset;
            posY = (int)((double)((H - 3 * inset - leftLabelSize.height) / 2 + 2 * inset + leftLabelSize.height) - newH / 2.0);
            if (posY < 2 * inset + leftLabelSize.height) {
                newH = H - inset * 3 - leftLabelSize.height;
                newW = newH / ratio;
                posY = leftLabelSize.height + inset * 2;
                posx = (int)((double)(inset + spaceX / 2) - newW / 2.0);
            }
        }
        newW = Math.max(1.0, newW);
        newH = Math.max(1.0, newH);
        this.exampleImageLabel.setBounds(posx, posY, (int)newW, (int)newH);
        this.unsupportedLabel.setFont(this.unsupportedLabel.getFont().deriveFont(1, 16.0f));
        int labelW = (int)newW;
        if (newW > 5.0) {
            labelW -= 4;
        }
        int labelY = posY;
        int labelH = (int)newH;
        if (newH > 15.0) {
            labelH = (int)(newH / 3.0);
            labelY += (int)(newH / 2.0) - labelH / 2;
        }
        this.unsupportedLabel.setBounds(xLeft, labelY, spaceX, labelH);
        this.unsupportedLabel.setVisible(this.isUnsupported);
    }

    private void hookImageListener() {
        this.exampleImageLabel.addPropertyChangeListener(evt -> {
            if ("image".equals(evt.getPropertyName())) {
                int rawW = this.getWidth();
                int rawH = this.getHeight();
                int inset = 4;
                int spaceX = rawW / 2 - inset * 2;
                this.leftSideGUI(rawH, rawW, spaceX, inset);
            }
        });
    }

    protected void setUnsupported(boolean isUnsupported) {
        this.isUnsupported = isUnsupported;
    }

    protected void setIcon(BufferedImage im) {
        this.exampleImageLabel.setImage(im, false);
    }

    protected void setInfo(String text) {
        SwingUtilities.invokeLater(() -> {
            this.modelInfoArea.setText(text);
            this.modelInfoArea.setCaretPosition(0);
        });
    }

    private void createProgressBar() {
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(false);
        this.progressBar.setBackground(Color.LIGHT_GRAY);
        this.progressBar.setVisible(true);
        this.progressBar.setForeground(new Color(46, 204, 113));
        this.progressInfoLabel = new JLabel("Example text");
        this.progressInfoLabel.setForeground(Color.black);
        this.progressInfoLabel.setFont(new Font("SansSerif", 2, 14));
    }

    protected void setDeterminatePorgress(int progress) {
        if (this.progressBar.isIndeterminate()) {
            this.progressBar.setIndeterminate(false);
        }
        this.progressBar.setValue(progress);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(progress + "%");
    }

    protected void setProgressIndeterminate(boolean indeterminate) {
        this.progressBar.setIndeterminate(indeterminate);
    }

    protected void setProgressBarText(String text) {
        this.progressBar.setString(text);
    }

    protected int getProgress() {
        return this.progressBar.getValue();
    }

    protected String getProgressBarText() {
        return this.progressBar.getString();
    }

    protected void setProgressLabelText(String text) {
        text = text == null ? "" : text;
        this.progressInfoLabel.setText(text);
    }

    protected void update(ModelDescriptor modelDescriptor, URL path, int logoWidth, int logoHeight) {
        DefaultIcon.drawImOrLogo(path, this.defaultLogoURL, this.exampleImageLabel, ModelSelectionPanelGui.MAIN_CARD_ID);
        ModelInfoWorker.TextLoadCallback callback = new ModelInfoWorker.TextLoadCallback(){

            @Override
            public void onTextLoaded(String infoText) {
                ContentPanel.this.setInfo(infoText);
                ContentPanel.this.revalidate();
                ContentPanel.this.repaint();
            }
        };
        ModelInfoWorker worker = new ModelInfoWorker(modelDescriptor, callback);
        worker.execute();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("Content Test");
            frame.setDefaultCloseOperation(3);
            frame.setSize(300, 400);
            frame.setLocationRelativeTo(null);
            ContentPanel card = new ContentPanel();
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add((Component)card, "Center");
            frame.setVisible(true);
        });
    }
}

