/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio.download;

import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.weights.ModelWeight;
import io.bioimage.modelrunner.bioimageio.description.weights.WeightFormat;
import io.bioimage.modelrunner.download.FileDownloader;
import io.bioimage.modelrunner.download.MultiFileDownloader;
import io.bioimage.modelrunner.engine.EngineInfo;
import io.bioimage.modelrunner.utils.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DownloadModel {
    private Map<String, String> downloadableLinks;
    private ModelDescriptor descriptor;
    private String modelsDir;
    private LinkedHashMap<String, Long> map;
    private Consumer<Double> consumer;
    private String progressString = "";
    private boolean unzip = false;
    private double unzippingProgress = 0.0;
    private Consumer<Double> unzippingConsumer;
    public static final String START_DWNLD_STR = "START: ";
    public static final String END_DWNLD_STR = " -- END" + System.lineSeparator();
    public static final String FILE_SIZE_STR = " ** FILE_SIZE **";
    public static final String DOWNLOAD_ERROR_STR = " --**ERROR**-- ";
    public static final String FINISH_STR = " --**END MODEL DOWNLOAD**-- ";
    private static String ATTACH_KEY = "attachments";
    private static String WEIGHTS_KEY = "weights";
    private static String RDF_KEY = "rdf_source";
    private static String SAMPLE_INPUTS_KEY = "sample_input";
    private static String SAMPLE_OUTPUTS_KEY = "sample_output";
    private static String TEST_INPUTS_KEY = "test_input";
    private static String TEST_OUTPUTS_KEY = "test_output";
    private static String COVERS_KEY = "covers";

    private DownloadModel(ModelDescriptor descriptor, String modelsDir) {
        this.descriptor = descriptor;
        String fname = MultiFileDownloader.addTimeStampToFileName(descriptor.getName(), true);
        this.modelsDir = modelsDir + File.separator + DownloadModel.getValidFileName(fname);
        this.unzippingConsumer = new Consumer<Double>(){

            @Override
            public void accept(Double d) {
                DownloadModel.this.unzippingProgress = d;
            }
        };
        this.retriveDownloadModelLinks();
    }

    public void setProgressConsumer(Consumer<Double> consumer) {
        this.consumer = consumer;
    }

    public static String getValidFileName(String fileName) {
        Pattern pattern = Pattern.compile("[\\\\/:*?\"<>|]");
        String name = new File(fileName).getName();
        String validFileName = pattern.matcher(name).replaceAll("_");
        validFileName = fileName.substring(0, fileName.lastIndexOf(name)) + validFileName;
        return validFileName;
    }

    public String getModelFolder() {
        return this.modelsDir;
    }

    public static DownloadModel build(ModelDescriptor descriptor, String modelsDir) {
        return new DownloadModel(descriptor, modelsDir);
    }

    public static DownloadModel build(ModelDescriptor descriptor) {
        return new DownloadModel(descriptor, new File("models").getAbsolutePath());
    }

    private void retriveDownloadModelLinks() {
        this.downloadableLinks = new HashMap<String, String>();
        this.addAttachments();
        this.addRDF();
        this.addCovers();
        this.addSampleInputs();
        this.addSampleOutputs();
        this.addTestInputs();
        this.addTestOutputs();
        this.addWeights();
    }

    public void checkModelWasDownloaded() throws IOException {
        long websize = -1L;
        for (String link : this.getListOfLinks()) {
            String fileName;
            try {
                fileName = FileDownloader.getFileNameFromURLString(link);
                websize = FileDownloader.getFileSize(new URL(link));
            }
            catch (MalformedURLException e) {
                throw new MalformedURLException("URL: '" + link + "' specified in the model rdf.yaml does not exist");
            }
            String name = this.modelsDir + File.separator + fileName;
            long localSize = new File(name).length();
            if (localSize == websize) continue;
            throw new IOException("Downloaded file: '" + name + "' is not the same size as the file at: '" + link + "'.");
        }
    }

    private void addWeights() {
        ModelWeight weights = this.descriptor.getWeights();
        int c = 0;
        for (WeightFormat w : weights.gettAllSupportedWeightObjects()) {
            try {
                if (w.getSource() != null) {
                    this.downloadableLinks.put(WEIGHTS_KEY + "_" + c++, this.descriptor.getModelURL() + w.getSource());
                    if (w.getSourceFileName().endsWith(".zip")) {
                        this.unzip = true;
                    }
                }
                if (w.getArchitecture() != null && w.getArchitecture().getSource() != null) {
                    this.downloadableLinks.put(WEIGHTS_KEY + "_" + c++, this.descriptor.getModelURL() + w.getArchitecture().getSource());
                }
                if (w.getEnvDependencies() == null || w.getEnvDependencies().getSource() == null) continue;
                this.downloadableLinks.put(WEIGHTS_KEY + "_" + c++, this.descriptor.getModelURL() + w.getEnvDependencies().getSource());
            }
            catch (Exception exception) {}
        }
    }

    private void addCovers() {
        int c = 0;
        for (String ss : this.descriptor.getCovers()) {
            if (ss != null && !DownloadModel.checkURL(ss)) {
                this.downloadableLinks.put(COVERS_KEY + "_" + c++, this.descriptor.getModelURL() + ss);
                continue;
            }
            if (ss == null) continue;
            this.downloadableLinks.put(COVERS_KEY + "_" + c++, ss);
        }
    }

    private void addTestInputs() {
        List fileNames = this.descriptor.getInputTensors().stream().map(tt -> tt.getTestTensorName()).collect(Collectors.toList());
        int c = 0;
        for (String ss : fileNames) {
            if (ss == null) continue;
            this.downloadableLinks.put(TEST_INPUTS_KEY + "_" + c++, this.descriptor.getModelURL() + ss);
        }
    }

    private void addTestOutputs() {
        List fileNames = this.descriptor.getOutputTensors().stream().map(tt -> tt.getTestTensorName()).collect(Collectors.toList());
        int c = 0;
        for (String ss : fileNames) {
            if (ss == null) continue;
            this.downloadableLinks.put(TEST_OUTPUTS_KEY + "_" + c++, this.descriptor.getModelURL() + ss);
        }
    }

    private void addSampleInputs() {
        List fileNames = this.descriptor.getInputTensors().stream().map(tt -> tt.getSampleTensorName()).collect(Collectors.toList());
        int c = 0;
        for (String ss : fileNames) {
            if (ss == null) continue;
            this.downloadableLinks.put(SAMPLE_INPUTS_KEY + "_" + c++, this.descriptor.getModelURL() + ss);
        }
    }

    private void addSampleOutputs() {
        List fileNames = this.descriptor.getOutputTensors().stream().map(tt -> tt.getSampleTensorName()).collect(Collectors.toList());
        int c = 0;
        for (String ss : fileNames) {
            if (ss == null) continue;
            this.downloadableLinks.put(SAMPLE_OUTPUTS_KEY + "_" + c++, this.descriptor.getModelURL() + ss);
        }
    }

    private void addRDF() {
        this.downloadableLinks.put(RDF_KEY, this.descriptor.getModelURL() + "rdf.yaml");
    }

    private void addAttachments() {
        List<String> attachments = this.descriptor.getAttachments();
        if (attachments == null) {
            return;
        }
        int c = 0;
        for (String kk : attachments) {
            this.downloadableLinks.put(ATTACH_KEY + "_" + c++, this.descriptor.getModelURL() + kk);
        }
    }

    public static boolean checkURL(String str) {
        try {
            URL url = new URL(str);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public List<String> getListOfLinks() {
        ArrayList<String> links = new ArrayList<String>();
        for (String kk : this.downloadableLinks.keySet()) {
            links.add(this.downloadableLinks.get(kk));
        }
        return links;
    }

    public static String addTimeStampToFileName(String str) {
        int extensionPos;
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("ddMMYYYY_HHmmss");
        String dateString = sdf.format(cal.getTime());
        int ind = str.lastIndexOf(File.separator);
        String fileName = str;
        if (ind != -1) {
            fileName = str.substring(ind + 1);
        }
        if ((extensionPos = fileName.lastIndexOf(".")) == -1) {
            return str + "_" + dateString;
        }
        String nameNoExtension = str.substring(0, extensionPos);
        String extension = str.substring(extensionPos);
        return nameNoExtension + "_" + dateString + extension;
    }

    public void downloadModel() throws IOException, InterruptedException, ExecutionException {
        this.downloadModel(Thread.currentThread());
    }

    public void downloadModel(Thread parentThread) throws IOException, InterruptedException, ExecutionException {
        File folder = new File(this.modelsDir);
        if (!folder.isDirectory() && !folder.mkdirs()) {
            throw new IOException("The provided directory where the model is going to be downloaded does not exist and cannot be created ->" + this.modelsDir);
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String link : this.getListOfLinks()) {
            urls.add(new URL(link));
        }
        MultiFileDownloader mfd = new MultiFileDownloader(urls, folder, parentThread);
        mfd.setPartialProgressConsumer(this.consumer);
        mfd.download();
        if (this.unzip) {
            this.unzipTfWeights();
        }
    }

    private void unzipTfWeights() throws IOException {
        if (this.descriptor.getWeights().getAllSuportedWeightNames().contains(EngineInfo.getBioimageioTfKey()) && !new File(this.modelsDir, "variables").isDirectory()) {
            String source = this.descriptor.getWeights().gettAllSupportedWeightObjects().stream().filter(ww -> ww.getFramework().equals(EngineInfo.getBioimageioTfKey())).findFirst().get().getSource();
            try {
                source = FileDownloader.getFileNameFromURLString(source);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("Unzipping model...");
            this.unzippingConsumer.accept(0.0);
            ZipUtils.unzipFolder(this.modelsDir + File.separator + source, this.modelsDir, this.unzippingConsumer);
        }
        this.unzip = false;
    }

    public LinkedHashMap<String, Long> getModelSizeFileByFile(boolean recalculate) throws MalformedURLException {
        if (this.map != null && !recalculate) {
            return this.map;
        }
        this.map = new LinkedHashMap();
        for (String link : this.getListOfLinks()) {
            this.map.put(link, FileDownloader.getFileSize(new URL(link)));
        }
        return this.map;
    }

    public String getProgress() {
        return this.progressString;
    }

    public Consumer<Double> getUnzippingConsumer() {
        return this.unzippingConsumer;
    }

    public boolean needsUnzipping() {
        return this.unzip;
    }

    public double getUnzippingProgress() {
        return this.unzippingProgress;
    }
}

