/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio.tiling;

import io.bioimage.modelrunner.bioimageio.tiling.PatchSpec;
import io.bioimage.modelrunner.utils.IndexingUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.LongStream;

public class TileGrid {
    private long[] tileSize;
    private int[] roiSize;
    private String tensorName;
    private List<long[]> tilePostionsInImage = new ArrayList<long[]>();
    private List<long[]> roiPositionsInTile = new ArrayList<long[]>();
    private List<long[]> roiPositionsInImage = new ArrayList<long[]>();

    private TileGrid() {
    }

    protected static TileGrid create(PatchSpec tileSpecs) {
        TileGrid ps = new TileGrid();
        ps.tensorName = tileSpecs.getTensorName();
        long[] imageDims = tileSpecs.getNonTiledTensorDims();
        int[] gridSize = tileSpecs.getTileGrid();
        ps.tileSize = tileSpecs.getTileSize();
        int tileCount = Arrays.stream(gridSize).reduce(1, (a, b) -> a * b);
        for (int j = 0; j < tileCount; ++j) {
            int[] patchIndex = IndexingUtils.flatIntoMultidimensionalIndex(j, gridSize);
            long[] patchSize = tileSpecs.getTileSize();
            int[][] padSize = tileSpecs.getPadding();
            int[] roiSize = IntStream.range(0, patchIndex.length).map(i -> (int)patchSize[i] - padSize[0][i] - padSize[1][i]).toArray();
            ps.roiSize = roiSize;
            ps.roiPositionsInTile.add(IntStream.range(0, padSize[0].length).mapToLong(i -> padSize[0][i]).toArray());
            long[] roiStart = LongStream.range(0L, patchIndex.length).map(i -> Math.min((long)(roiSize[(int)i] * patchIndex[(int)i]), imageDims[(int)i] - (long)roiSize[(int)i])).toArray();
            ps.roiPositionsInImage.add(roiStart);
            long[] patchStart = LongStream.range(0L, patchIndex.length).map(i -> Math.min((long)(roiSize[(int)i] * patchIndex[(int)i] - padSize[0][(int)i]), imageDims[(int)i] - (long)roiSize[(int)i] - (long)padSize[0][(int)i])).toArray();
            ps.tilePostionsInImage.add(patchStart);
        }
        return ps;
    }

    protected String getTensorName() {
        return this.tensorName;
    }

    protected long[] getTileSize() {
        return this.tileSize;
    }

    protected int[] getRoiSize() {
        return this.roiSize;
    }

    protected List<long[]> getTilePostionsInImage() {
        return this.tilePostionsInImage;
    }

    protected List<long[]> getRoiPositionsInTile() {
        return this.roiPositionsInTile;
    }

    protected List<long[]> getRoiPostionsInImage() {
        return this.roiPositionsInImage;
    }
}

