/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui;

import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.exceptions.LoadEngineException;
import io.bioimage.modelrunner.gui.ContentPanel;
import io.bioimage.modelrunner.gui.DefaultIcon;
import io.bioimage.modelrunner.gui.LogoPanel;
import io.bioimage.modelrunner.gui.ModelSelectionPanelGui;
import io.bioimage.modelrunner.gui.adapter.GuiAdapter;
import io.bioimage.modelrunner.gui.adapter.RunnerAdapter;
import io.bioimage.modelrunner.tensor.Tensor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;

public class ModelCard
extends JPanel {
    private static final long serialVersionUID = -5625832740571130175L;
    private final URL defaultLogoURL;
    private final double scale;
    private final String cardID;
    private JLabel nameLabel;
    private JLabel nicknameLabel;
    private JLabel unsupportedLabel;
    protected LogoPanel logoIcon;
    private boolean isUnsupported = false;
    protected static final String UNSUPPORTED_TEXT = "UNSUPPORTED";
    protected static final Color UNSUPPORTED_BG_COLOR = Color.red;
    protected static final Color UNSUPPORTED_FG_COLOR = Color.black;

    protected ModelCard(GuiAdapter adapter) {
        this(adapter, ModelSelectionPanelGui.MAIN_CARD_ID, 1.0);
    }

    protected ModelCard(GuiAdapter adapter, String cardID, double scale) {
        super(null);
        this.defaultLogoURL = adapter == null ? null : ContentPanel.class.getClassLoader().getResource(adapter.getIconPath());
        this.cardID = cardID;
        this.scale = scale;
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
        this.logoIcon = new LogoPanel();
        this.unsupportedLabel = new JLabel(UNSUPPORTED_TEXT, 0);
        this.unsupportedLabel.setFont(new Font("SansSerif", 1, 24));
        this.unsupportedLabel.setForeground(UNSUPPORTED_FG_COLOR);
        this.unsupportedLabel.setBackground(UNSUPPORTED_BG_COLOR);
        this.unsupportedLabel.setOpaque(true);
        this.unsupportedLabel.setBorder(BorderFactory.createEtchedBorder());
        this.unsupportedLabel.setVisible(true);
        this.nameLabel = new JLabel("loading...", 0);
        this.nameLabel.setFont(new Font("SansSerif", 1, (int)(16.0 * scale)));
        this.nicknameLabel = new JLabel("loading...", 0);
        this.nicknameLabel.setFont(new Font("SansSerif", 2, (int)(14.0 * scale)));
        this.add(this.nameLabel);
        this.add(this.unsupportedLabel);
        this.add(this.logoIcon);
        this.add(this.nicknameLabel);
        this.organiseComponents();
        this.hookImageListener();
    }

    private void organiseComponents() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ModelCard.this.layoutAll();
            }
        });
    }

    private void hookImageListener() {
        this.logoIcon.addPropertyChangeListener(evt -> {
            if ("image".equals(evt.getPropertyName())) {
                this.layoutAll();
            }
        });
    }

    private void layoutAll() {
        int leftH;
        int posx;
        int posY;
        double newW;
        double newH;
        int imW;
        int imH;
        Insets in = this.getInsets();
        int W = this.getWidth() - in.left - in.right;
        int H = this.getHeight() - in.top - in.bottom;
        int topInset = 2;
        int bottomInset = 2;
        int imTopInset = 2;
        int imBottomInset = 2;
        int sideInset = 2;
        this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(1, (float)(16.0 * this.scale)));
        this.nicknameLabel.setFont(this.nicknameLabel.getFont().deriveFont(0, (float)(14.0 * this.scale)));
        Dimension topSize = this.nameLabel.getPreferredSize();
        Dimension bottomSize = this.nicknameLabel.getPreferredSize();
        BufferedImage im = this.logoIcon.getImage();
        if (im == null) {
            imH = this.logoIcon.getPreferredSize().height;
            imW = this.logoIcon.getPreferredSize().width;
        } else {
            imH = im.getHeight();
            imW = im.getWidth();
        }
        double ratio = (double)imH / (double)imW;
        if (ratio > 1.0) {
            newH = H - topInset - bottomInset - imTopInset - imBottomInset - topSize.height - bottomSize.height;
            newW = newH / ratio;
            posY = imTopInset + topInset + topSize.height;
            posx = (int)((double)(W / 2) - newW / 2.0);
            if (newW > (double)(W + 2 * sideInset)) {
                newW = W - sideInset * 2;
                newH = newW * ratio;
                posx = sideInset;
                posY = (int)((double)(H / 2) - newH / 2.0);
            }
        } else {
            newW = W - sideInset * 2;
            newH = newW * ratio;
            posx = sideInset;
            posY = (int)((double)(H / 2) - newH / 2.0);
            if (newH > (double)(H - topInset - bottomInset - imTopInset - imBottomInset - topSize.height - bottomSize.height)) {
                newH = H - topInset - bottomInset - imTopInset - imBottomInset - topSize.height - bottomSize.height;
                newW = newH / ratio;
                posY = imTopInset + topInset + topSize.height;
                posx = (int)((double)(W / 2) - newW / 2.0);
            }
        }
        newH = Math.max(1.0, newH);
        newW = Math.max(1.0, newW);
        int nameX = Math.max(1, Math.min(topSize.width, W - sideInset * 2));
        int nameY = Math.max(1, topSize.height);
        int nicknameNameX = Math.max(1, Math.min(bottomSize.width, W - sideInset * 2));
        int nicknameNameY = Math.max(1, bottomSize.height);
        int sideInsetName = Math.max(sideInset, W / 2 - topSize.width / 2);
        int sideInsetNickname = Math.max(sideInset, W / 2 - bottomSize.width / 2);
        int posYNick = Math.max(0, H - bottomInset - bottomSize.height);
        this.nameLabel.setBounds(sideInsetName, topInset, nameX, nameY);
        this.nicknameLabel.setBounds(sideInsetNickname, posYNick, nicknameNameX, nicknameNameY);
        this.logoIcon.setBounds(posx, posY, (int)newW, (int)newH);
        int labelW = (int)newW;
        if (newW > 5.0) {
            labelW -= 4;
        }
        int labelY = posY;
        int labelH = (int)newH;
        if (newH > 15.0) {
            labelH = (int)(newH / 3.0);
            labelY += (int)(newH / 2.0) - labelH / 2;
        }
        if ((leftH = (int)((double)(posYNick - imBottomInset - posY) - newH)) > 30 && leftH > labelH) {
            labelH = leftH;
            labelY = (int)((double)posY + newH);
        }
        this.unsupportedLabel.setBounds(sideInset, labelY, this.getWidth() - sideInset * 2, labelH);
        this.unsupportedLabel.setVisible(this.isUnsupported);
        this.unsupportedLabel.setFont(this.unsupportedLabel.getFont().deriveFont(1, (float)((double)labelH / 3.5)));
    }

    public void setUnsupported(boolean unsupported) {
        if (this.isUnsupported != unsupported) {
            this.isUnsupported = unsupported;
            this.unsupportedLabel.setVisible(unsupported);
        }
    }

    public boolean isUnsupported() {
        return this.isUnsupported;
    }

    protected static ModelCard createModelCard(GuiAdapter adapter) {
        ModelCard modelCardPanel = new ModelCard(adapter);
        return modelCardPanel;
    }

    protected static ModelCard createModelCard(GuiAdapter adapter, String id, double scale) {
        ModelCard modelCardPanel = new ModelCard(adapter, id, scale);
        return modelCardPanel;
    }

    protected void updateCard(String name, String nickname, URL imagePath) {
        this.nameLabel.setText(name);
        this.nicknameLabel.setText(nickname);
        if (this.defaultLogoURL != null) {
            DefaultIcon.drawImOrLogo(imagePath, this.defaultLogoURL, this.logoIcon, this.cardID);
        } else {
            DefaultIcon.drawImOrLogo(imagePath, this.logoIcon, this.cardID);
        }
    }

    protected void updateCard(String name, String nickname, URL imagePath, boolean supported) {
        this.nameLabel.setText(name);
        this.nicknameLabel.setText(nickname);
        this.setUnsupported(!supported);
        if (this.defaultLogoURL != null) {
            DefaultIcon.drawImOrLogo(imagePath, this.defaultLogoURL, this.logoIcon, this.cardID);
        } else {
            DefaultIcon.drawImOrLogo(imagePath, this.logoIcon, this.cardID);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("Model Card Test");
            frame.setDefaultCloseOperation(3);
            frame.setSize(300, 400);
            frame.setLocationRelativeTo(null);
            GuiAdapter adapter = new GuiAdapter(){

                @Override
                public String getSoftwareName() {
                    return "JOHN DOE";
                }

                @Override
                public String getSoftwareDescription() {
                    return "The best AI software";
                }

                @Override
                public String getIconPath() {
                    return "/home/carlos/git/deep-icy/src/main/resources/deepicy_imgs/icy_logo.png";
                }

                @Override
                public String getModelsDir() {
                    return null;
                }

                @Override
                public String getEnginesDir() {
                    return null;
                }

                @Override
                public RunnerAdapter createRunner(ModelDescriptor descriptor) throws IOException, LoadEngineException {
                    return null;
                }

                @Override
                public RunnerAdapter createRunner(ModelDescriptor descriptor, String enginesPath) throws IOException, LoadEngineException {
                    return null;
                }

                @Override
                public <T extends RealType<T> & NativeType<T>> void displayRai(RandomAccessibleInterval<T> rai, String axesOrder, String imTitle) {
                }

                @Override
                public <T extends RealType<T> & NativeType<T>> List<Tensor<T>> getInputTensors(ModelDescriptor descriptor) {
                    return null;
                }

                @Override
                public List<String> getInputImageNames() {
                    return null;
                }

                @Override
                public <T extends RealType<T> & NativeType<T>> List<Tensor<T>> convertToInputTensors(Map<String, Object> inputs, ModelDescriptor descriptor) {
                    return null;
                }
            };
            ModelCard card = ModelCard.createModelCard(adapter);
            try {
                card.updateCard("My Model Name", "Friendly Nickname", new File("/home/carlos/git/deep-icy/src/main/resources/deepicy_imgs/icy_logo.png").toURI().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            card.setUnsupported(true);
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add((Component)card, "Center");
            frame.setVisible(true);
        });
    }
}

