/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui;

import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.exceptions.LoadEngineException;
import io.bioimage.modelrunner.gui.ModelCard;
import io.bioimage.modelrunner.gui.adapter.GuiAdapter;
import io.bioimage.modelrunner.gui.adapter.RunnerAdapter;
import io.bioimage.modelrunner.tensor.Tensor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;

public class ModelSelectionPanelGui
extends JPanel {
    private static final long serialVersionUID = 6264134076603842497L;
    protected ModelCard prevModelPanel;
    protected ModelCard selectedModelPanel;
    protected ModelCard nextModelPanel;
    protected JButton nextButton;
    protected JButton prevButton;
    protected TitledBorder lineBorder;
    protected String defaultString = "loading...";
    protected static final double MAIN_CARD_RT = 1.0;
    protected static final double SECOND_CARD_RT = 0.6;
    protected static String MAIN_CARD_ID = "main";
    protected static String PREV_CARD_ID = "prev";
    protected static String NEXT_CARD_ID = "next";
    protected static final double BTN_HEIGHT_RATIO = 0.07;
    protected static final double MAX_BTN_HEIGHT = 33.0;

    protected ModelSelectionPanelGui(GuiAdapter adapter) {
        super(null);
        this.setBackground(new Color(236, 240, 241));
        this.lineBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray, 2, true), "Local");
        Border paddingBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.setBorder(BorderFactory.createCompoundBorder(paddingBorder, this.lineBorder));
        this.prevModelPanel = ModelCard.createModelCard(adapter, PREV_CARD_ID, 0.6);
        this.selectedModelPanel = ModelCard.createModelCard(adapter, MAIN_CARD_ID, 1.0);
        this.nextModelPanel = ModelCard.createModelCard(adapter, NEXT_CARD_ID, 0.6);
        this.prevButton = new JButton("\u25c0");
        this.prevButton.setFont(new Font("SansSerif", 1, 10));
        this.nextButton = new JButton("\u25b6");
        this.nextButton.setFont(new Font("SansSerif", 1, 10));
        this.add(this.prevModelPanel);
        this.add(this.selectedModelPanel);
        this.add(this.nextModelPanel);
        this.add(this.prevButton);
        this.add(this.nextButton);
        this.organiseComponents();
    }

    private void organiseComponents() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Insets in = ModelSelectionPanelGui.this.getInsets();
                int W = ModelSelectionPanelGui.this.getWidth() - in.left - in.right;
                int rawW = ModelSelectionPanelGui.this.getWidth();
                int rawH = ModelSelectionPanelGui.this.getHeight();
                int inset = in.left;
                int insetTop = in.top;
                double btnH = Math.min(33.0, (double)rawH * 0.07);
                btnH = Math.max(1.0, btnH);
                int btnW = (int)Math.max(1.0, (double)W * 0.5);
                ModelSelectionPanelGui.this.prevButton.setBounds(in.left, rawH - in.left - (int)btnH, btnW, (int)btnH);
                ModelSelectionPanelGui.this.nextButton.setBounds(in.left + btnW, rawH - in.left - (int)btnH, btnW, (int)btnH);
                int hSide = (int)((double)(rawH - inset - insetTop) - btnH);
                int wSide = (int)((double)(W - 4 * inset) / 2.2);
                int side = Math.min(wSide, hSide);
                int mediumX = rawW / 2 - side / 2;
                int leftX = (int)((double)(mediumX - inset) - (double)side * 0.6);
                int rightX = mediumX + side + inset;
                int topY = (int)(((double)rawH - btnH) / 2.0 - (double)(side / 2));
                int bottomY = (int)((double)topY + (double)side * 0.4 / 2.0);
                ModelSelectionPanelGui.this.prevModelPanel.setBounds(leftX, bottomY, (int)Math.max(1.0, (double)side * 0.6), (int)Math.max(1.0, (double)side * 0.6));
                ModelSelectionPanelGui.this.selectedModelPanel.setBounds(mediumX, topY, side, side);
                ModelSelectionPanelGui.this.nextModelPanel.setBounds(rightX, bottomY, (int)Math.max(1.0, (double)side * 0.6), (int)Math.max(1.0, (double)side * 0.6));
            }
        });
    }

    protected void setBorderLabel(String text) {
        this.lineBorder.setTitle(text);
        this.validate();
        this.repaint();
    }

    protected void setArrowsEnabled(boolean enabled) {
        this.nextButton.setEnabled(enabled);
        this.prevButton.setEnabled(enabled);
    }

    protected void setLocalBorder() {
        this.setBorderLabel("Local");
    }

    protected void setBMZBorder() {
        this.setBorderLabel("Bioimage.io");
    }

    protected void setLoading() {
        this.defaultString = "loading...";
    }

    protected void setNotFound() {
        this.defaultString = "no models found";
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("CArrousel Test");
            frame.setDefaultCloseOperation(3);
            frame.setSize(300, 400);
            frame.setLocationRelativeTo(null);
            GuiAdapter adapter = new GuiAdapter(){

                @Override
                public String getSoftwareName() {
                    return "JOHN DOE";
                }

                @Override
                public String getSoftwareDescription() {
                    return "The best AI software";
                }

                @Override
                public String getIconPath() {
                    return "/home/carlos/git/deep-icy/src/main/resources/deepicy_imgs/icy_logo.png";
                }

                @Override
                public String getModelsDir() {
                    return null;
                }

                @Override
                public String getEnginesDir() {
                    return null;
                }

                @Override
                public RunnerAdapter createRunner(ModelDescriptor descriptor) throws IOException, LoadEngineException {
                    return null;
                }

                @Override
                public RunnerAdapter createRunner(ModelDescriptor descriptor, String enginesPath) throws IOException, LoadEngineException {
                    return null;
                }

                @Override
                public <T extends RealType<T> & NativeType<T>> void displayRai(RandomAccessibleInterval<T> rai, String axesOrder, String imTitle) {
                }

                @Override
                public <T extends RealType<T> & NativeType<T>> List<Tensor<T>> getInputTensors(ModelDescriptor descriptor) {
                    return null;
                }

                @Override
                public List<String> getInputImageNames() {
                    return null;
                }

                @Override
                public <T extends RealType<T> & NativeType<T>> List<Tensor<T>> convertToInputTensors(Map<String, Object> inputs, ModelDescriptor descriptor) {
                    return null;
                }
            };
            ModelSelectionPanelGui card = new ModelSelectionPanelGui(adapter);
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add((Component)card, "Center");
            frame.setVisible(true);
        });
    }
}

