/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class IndexingUtils {
    public static int multidimensionalIntoFlatIndex(int[] ind, int[] size) {
        int flat = 0;
        for (int i = 0; i < ind.length; ++i) {
            int inter = ind[i];
            for (int j = i + 1; j < size.length; ++j) {
                inter *= size[j];
            }
            flat += inter;
        }
        return flat;
    }

    public static void main(String[] args) {
        int[] size = new int[]{3, 3, 2};
        int[] pos0 = new int[]{0, 0, 0};
        int[] pos1 = new int[]{0, 0, 1};
        int[] pos2 = new int[]{0, 2, 1};
        int[] pos3 = new int[]{1, 0, 0};
        int[] posn = new int[]{1, 100, 7};
        int[] sizen = new int[]{3, 256, 15};
        System.out.println(IndexingUtils.multidimensionalIntoFlatIndex(pos0, size));
        System.out.println(IndexingUtils.multidimensionalIntoFlatIndex(pos1, size));
        System.out.println(IndexingUtils.multidimensionalIntoFlatIndex(pos2, size));
        System.out.println(IndexingUtils.multidimensionalIntoFlatIndex(pos3, size));
        System.out.println(IndexingUtils.multidimensionalIntoFlatIndex(posn, sizen));
        System.out.println(Arrays.toString(IndexingUtils.flatIntoMultidimensionalIndex(IndexingUtils.multidimensionalIntoFlatIndex(pos0, size), size)));
        System.out.println(Arrays.toString(IndexingUtils.flatIntoMultidimensionalIndex(IndexingUtils.multidimensionalIntoFlatIndex(pos1, size), size)));
        System.out.println(Arrays.toString(IndexingUtils.flatIntoMultidimensionalIndex(IndexingUtils.multidimensionalIntoFlatIndex(pos2, size), size)));
        System.out.println(Arrays.toString(IndexingUtils.flatIntoMultidimensionalIndex(IndexingUtils.multidimensionalIntoFlatIndex(pos3, size), size)));
        System.out.println(Arrays.toString(IndexingUtils.flatIntoMultidimensionalIndex(IndexingUtils.multidimensionalIntoFlatIndex(posn, sizen), sizen)));
    }

    public static int multidimensionalIntoFlatIndex(long[] ind, long[] size) {
        int flat = 0;
        for (int i = 0; i < ind.length; ++i) {
            int inter = (int)ind[i];
            for (int j = i + 1; j < size.length; ++j) {
                inter = (int)((long)inter * size[j]);
            }
            flat += inter;
        }
        return flat;
    }

    public static long[] flatIntoMultidimensionalIndex(long flat, long[] size) {
        long[] ind = new long[size.length];
        long rem = 0L + flat;
        for (int i = 0; i < ind.length; ++i) {
            int inter = 1;
            for (int j = i + 1; j < size.length; ++j) {
                inter = (int)((long)inter * size[j]);
            }
            ind[i] = rem / (long)inter;
            rem %= (long)inter;
        }
        return ind;
    }

    public static int[] flatIntoMultidimensionalIndex(int flat, int[] size) {
        int[] ind = new int[size.length];
        int rem = 0 + flat;
        for (int i = 0; i < ind.length; ++i) {
            int inter = 1;
            for (int j = i + 1; j < size.length; ++j) {
                inter *= size[j];
            }
            ind[i] = rem / inter;
            rem %= inter;
        }
        return ind;
    }

    public static Integer[] argsort(List<Integer> list) {
        Integer[] indices = new Integer[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            indices[i] = i;
        }
        indices = (Integer[])indices.clone();
        Arrays.sort(indices, Comparator.comparingInt(list::get));
        return indices;
    }
}

