/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui;

import io.bioimage.modelrunner.gui.HeaderGui;
import io.bioimage.modelrunner.gui.adapter.GuiAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.function.Consumer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class Header
extends JPanel {
    private static final long serialVersionUID = -7691139174208436363L;
    private final JLabel titleLabel;
    private final JLabel subtitleLabel;
    private JProgressBar progressBar;
    private JLabel progressLabel;

    public Header(GuiAdapter adapter) {
        super(new BorderLayout());
        this.setBackground(Color.GRAY);
        this.setBorder(new LineBorder(Color.BLACK, 2, true));
        this.titleLabel = new JLabel(adapter.getSoftwareName(), 0);
        this.titleLabel.setForeground(Color.WHITE);
        this.subtitleLabel = new JLabel(adapter.getSoftwareDescription(), 0);
        this.subtitleLabel.setForeground(Color.WHITE);
        this.createProgressBar();
        URL defaultIconUrl = Header.class.getClassLoader().getResource(adapter.getIconPath());
        this.add((Component)new HeaderGui(this.titleLabel, this.subtitleLabel, this.progressBar, this.progressLabel, defaultIconUrl), "Center");
    }

    private void createProgressBar() {
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(false);
        this.progressBar.setBackground(Color.LIGHT_GRAY);
        this.progressBar.setForeground(new Color(46, 204, 113));
        this.progressLabel = new JLabel("Processing...", 0);
        this.progressLabel.setBackground(Color.GRAY);
        this.progressLabel.setOpaque(true);
    }

    protected void setGUIStartInstallation() {
        SwingUtilities.invokeLater(() -> {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setStringPainted(true);
            this.progressBar.setVisible(true);
            this.progressBar.setString("0%");
            this.progressLabel.setText("Preparing installation...");
            this.progressLabel.setVisible(true);
        });
    }

    public Consumer<String> createStringConsumer() {
        Consumer<String> consumer = ss -> SwingUtilities.invokeLater(() -> this.progressLabel.setText("Installing " + new File((String)ss).getName()));
        return consumer;
    }

    public Consumer<Double> createProgressConsumer() {
        Consumer<Double> consumer = dd -> SwingUtilities.invokeLater(() -> {
            if (this.progressBar.isIndeterminate()) {
                this.progressBar.setIndeterminate(false);
            }
            double perc = Math.floor(dd * 1000.0) / 10.0;
            this.progressBar.setString(perc + "%");
            this.progressBar.setValue((int)perc);
            if (perc == 100.0) {
                this.progressLabel.setVisible(false);
                this.progressBar.setVisible(false);
            }
        });
        return consumer;
    }
}

