/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui;

import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.exceptions.LoadEngineException;
import io.bioimage.modelrunner.gui.DefaultIcon;
import io.bioimage.modelrunner.gui.Header;
import io.bioimage.modelrunner.gui.LogoPanel;
import io.bioimage.modelrunner.gui.adapter.GuiAdapter;
import io.bioimage.modelrunner.gui.adapter.RunnerAdapter;
import io.bioimage.modelrunner.tensor.Tensor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;

public class HeaderGui
extends JPanel {
    private static final long serialVersionUID = -306110026903658536L;
    protected final JLabel title;
    protected final JLabel subtitle;
    protected final JLabel barSubtitle;
    protected final JProgressBar bar;
    protected final URL logoURL;

    protected HeaderGui(JLabel title, JLabel subtitle, JProgressBar bar, JLabel barSubtitle, URL logoURL) {
        super(null);
        this.bar = bar;
        this.title = title;
        this.subtitle = subtitle;
        this.barSubtitle = barSubtitle;
        this.logoURL = logoURL;
        this.createAndShow();
    }

    private void createAndShow() {
        final JPanel empty = new JPanel();
        empty.setOpaque(false);
        this.add(empty);
        final LogoPanel logo = new LogoPanel();
        this.add(logo);
        DefaultIcon.drawLogo(this.logoURL, logo);
        this.title.setFont(this.title.getFont().deriveFont(1, 28.0f));
        this.add(this.title);
        this.subtitle.setFont(this.subtitle.getFont().deriveFont(0, 16.0f));
        this.add(this.subtitle);
        this.bar.setStringPainted(true);
        this.bar.setVisible(false);
        this.add(this.bar);
        this.barSubtitle.setVisible(false);
        this.add(this.barSubtitle);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                float sFontSize;
                float fontSize;
                Insets in = HeaderGui.this.getInsets();
                int W = HeaderGui.this.getWidth() - in.left - in.right;
                int H = HeaderGui.this.getHeight() - in.top - in.bottom;
                int logoInset = 2;
                double ratio = (double)W / (double)H;
                if (ratio > 6.0) {
                    fontSize = (float)H / 2.8f;
                    sFontSize = (float)H / 4.9f;
                } else {
                    fontSize = (float)W / 16.5f;
                    sFontSize = (float)W / 28.8f;
                }
                HeaderGui.this.title.setFont(HeaderGui.this.title.getFont().deriveFont(1, fontSize));
                HeaderGui.this.subtitle.setFont(HeaderGui.this.subtitle.getFont().deriveFont(0, sFontSize));
                Dimension tSz = HeaderGui.this.title.getPreferredSize();
                Dimension sSz = HeaderGui.this.subtitle.getPreferredSize();
                int remainingPixels = H - tSz.height - sSz.height;
                int titleGap = Math.max(1, remainingPixels / 6);
                int headerTop = Math.max(0, (remainingPixels - titleGap) / 2);
                int logoSize = Math.min(H - logoInset * 2, sSz.width / 2);
                logoSize = Math.max(1, logoSize);
                int xTitle = (W - tSz.width) / 2;
                int xSubtitle = (W - sSz.width) / 2;
                int yTitle = headerTop;
                int ySubtitle = headerTop + tSz.height + titleGap;
                HeaderGui.this.title.setBounds(xTitle, yTitle, tSz.width, tSz.height);
                HeaderGui.this.subtitle.setBounds(xSubtitle, ySubtitle, sSz.width, sSz.height);
                int minBarGap = 2;
                int textW = Math.max(xTitle + tSz.width, xSubtitle + sSz.width);
                int barGap = Math.max(minBarGap, (W - textW) / 10);
                int xBar = textW + barGap;
                int barH = sSz.height;
                int yBar = -barH - titleGap / 2 + (yTitle + ySubtitle + tSz.height) / 2;
                int barW = Math.max(1, W - textW - barGap * 2);
                HeaderGui.this.bar.setBounds(xBar, yBar, barW, barH);
                int yString = titleGap / 2 + (yTitle + ySubtitle + tSz.height) / 2;
                HeaderGui.this.barSubtitle.setFont(HeaderGui.this.barSubtitle.getFont().deriveFont(0, sFontSize * 0.6f));
                int barSubtitleW = Math.max(1, W - textW - barGap * 2);
                HeaderGui.this.barSubtitle.setBounds(xBar, yString, barSubtitleW, barH);
                int logoInsetX = Math.max(logoInset, logoSize / 10);
                int xLogo = xSubtitle - logoSize - logoInsetX;
                if (xLogo < 1) {
                    xLogo = 1;
                }
                empty.setBounds(0, 0, xLogo, Math.max(H, 1));
                int logoInsetY = Math.max(logoInset, (H - logoSize) / 2);
                logo.setBounds(xLogo, logoInsetY, logoSize, logoSize);
            }
        });
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("Header Test");
            frame.setDefaultCloseOperation(3);
            frame.setSize(300, 400);
            frame.setLocationRelativeTo(null);
            GuiAdapter adapter = new GuiAdapter(){

                @Override
                public String getSoftwareName() {
                    return "JOHN DOE";
                }

                @Override
                public String getSoftwareDescription() {
                    return "The best AI software";
                }

                @Override
                public String getIconPath() {
                    return "/home/carlos/git/deep-icy/src/main/resources/deepicy_imgs/icy_logo.png";
                }

                @Override
                public String getModelsDir() {
                    return null;
                }

                @Override
                public String getEnginesDir() {
                    return null;
                }

                @Override
                public RunnerAdapter createRunner(ModelDescriptor descriptor) throws IOException, LoadEngineException {
                    return null;
                }

                @Override
                public RunnerAdapter createRunner(ModelDescriptor descriptor, String enginesPath) throws IOException, LoadEngineException {
                    return null;
                }

                @Override
                public <T extends RealType<T> & NativeType<T>> void displayRai(RandomAccessibleInterval<T> rai, String axesOrder, String imTitle) {
                }

                @Override
                public <T extends RealType<T> & NativeType<T>> List<Tensor<T>> getInputTensors(ModelDescriptor descriptor) {
                    return null;
                }

                @Override
                public List<String> getInputImageNames() {
                    return null;
                }

                @Override
                public <T extends RealType<T> & NativeType<T>> List<Tensor<T>> convertToInputTensors(Map<String, Object> inputs, ModelDescriptor descriptor) {
                    return null;
                }
            };
            Header header = new Header(adapter);
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add((Component)header, "Center");
            frame.setVisible(true);
        });
    }
}

