/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.protocols.gui;

import icy.gui.frame.progress.AnnounceFrame;
import icy.network.NetworkUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.abstract_.Plugin;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.util.StringUtil;
import japa.parser.JavaParser;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.body.JavadocComment;
import japa.parser.ast.body.TypeDeclaration;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import org.pushingpixels.substance.internal.ui.SubstanceSplitPaneUI;
import org.pushingpixels.substance.internal.utils.SubstanceSplitPaneDivider;
import plugins.adufour.blocks.util.BlocksFinder;
import plugins.adufour.blocks.util.MenuItemListener;

public class BlockSearchPanel
extends JPanel
implements MenuItemListener {
    private static final int MIN_CHARACTERS_FOR_SEARCH = 2;
    private static final int SEARCH_TEXT_FONT_SIZE = 14;
    private static final String DEFAULT_SEARCH_TEXT = "Search for blocks...";
    private static final int SCROLL_SPEED = 32;
    private static final String DEFAULT_INFO_TEXT = "<html><body style=\"font-family: Tahoma\"><i>Search and click on a block above to see its documentation.</i></body></html>";
    private JTextField searchField;
    private JLabel searchIcon = new JLabel((Icon)((Object)new IcyIcon(ResourceUtil.ICON_SEARCH)));
    private String currentSearchText;
    private Box searchBar;
    private BlocksFinder finder;
    private Box blockList;
    private JScrollPane blockListDisplay;
    private JTextPane blockInfo;
    private JScrollPane blockInfoDisplay;
    private JSplitPane results;

    public BlockSearchPanel() {
        this.searchField = new JTextField(DEFAULT_SEARCH_TEXT);
        this.currentSearchText = this.searchField.getText();
        this.searchBar = Box.createHorizontalBox();
        this.finder = new BlocksFinder();
        this.blockList = Box.createVerticalBox();
        this.blockListDisplay = new JScrollPane(this.blockList, 20, 31);
        this.blockInfo = new JTextPane();
        this.blockInfo.setContentType("text/html");
        this.blockInfo.setText(DEFAULT_INFO_TEXT);
        this.blockInfoDisplay = new JScrollPane(this.blockInfo, 20, 30);
        this.results = new JSplitPane(0, this.blockListDisplay, this.blockInfoDisplay);
        this.searchIcon.setAlignmentX(0.0f);
        this.searchField.setAlignmentX(0.0f);
        this.searchField.setMinimumSize(new Dimension(180, 28));
        this.searchField.setFont(new Font("Arial", 0, 14));
        this.searchField.setPreferredSize(this.searchField.getMinimumSize());
        this.searchField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
                BlockSearchPanel.this.searchField.setText(BlockSearchPanel.this.currentSearchText);
            }

            @Override
            public void focusGained(FocusEvent arg0) {
                if (BlockSearchPanel.this.searchField.getText().equals(BlockSearchPanel.DEFAULT_SEARCH_TEXT)) {
                    BlockSearchPanel.this.searchField.setText("");
                }
            }
        });
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                BlockSearchPanel.this.blockList.removeAll();
                if (BlockSearchPanel.this.searchField.getText().length() >= 2) {
                    BlockSearchPanel.this.updateBlockList();
                } else {
                    BlockSearchPanel.this.blockList.setVisible(false);
                }
                BlockSearchPanel.this.currentSearchText = BlockSearchPanel.this.searchField.getText();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                BlockSearchPanel.this.blockList.removeAll();
                if (BlockSearchPanel.this.searchField.getText().length() >= 2) {
                    BlockSearchPanel.this.updateBlockList();
                    if (!BlockSearchPanel.this.blockList.isVisible()) {
                        BlockSearchPanel.this.blockList.setVisible(true);
                    }
                }
                BlockSearchPanel.this.currentSearchText = BlockSearchPanel.this.searchField.getText();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }
        });
        this.searchBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.searchBar.add(this.searchIcon);
        this.searchBar.add(Box.createHorizontalStrut(5));
        this.searchBar.add(this.searchField);
        this.searchBar.add(Box.createHorizontalGlue());
        this.blockList.setVisible(false);
        this.blockListDisplay.getVerticalScrollBar().setUnitIncrement(32);
        this.blockListDisplay.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 5, 0), new LineBorder(Color.GRAY)));
        this.blockListDisplay.setPreferredSize(new Dimension(this.blockListDisplay.getWidth(), 250));
        this.blockInfo.setEditable(false);
        this.blockInfo.setBackground(Color.LIGHT_GRAY);
        this.blockInfo.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED) && Desktop.isDesktopSupported()) {
                    if (event.getURL() != null) {
                        NetworkUtil.openBrowser(event.getURL().toString());
                    } else {
                        new AnnounceFrame("Error looking up online documentation.");
                    }
                }
            }
        });
        this.blockInfoDisplay.setBorder(BorderFactory.createEmptyBorder(5, 0, 15, 0));
        this.blockInfoDisplay.setPreferredSize(new Dimension(200, 150));
        this.blockInfoDisplay.getVerticalScrollBar().setUnitIncrement(32);
        this.results.setOneTouchExpandable(true);
        this.results.setContinuousLayout(true);
        this.results.setUI((SplitPaneUI)((Object)new MySplitPaneUI()));
        this.setLayout(new BorderLayout());
        this.setBorder(new CompoundBorder(this.getBorder(), new EmptyBorder(0, 5, 5, 5)));
        this.setPreferredSize(this.getMinimumSize());
        this.add((Component)this.searchBar, "North");
        this.add((Component)this.results, "Center");
    }

    @Override
    public Component add(Component c) {
        return this.blockList.add(c);
    }

    private void updateBlockList() {
        this.finder.createSearchMenu(this, this.searchField.getText());
        this.revalidate();
        this.repaint();
    }

    @Override
    public void displayDoc(PluginDescriptor d) {
        for (Component c : this.blockList.getComponents()) {
            if (d == ((BlocksFinder.DND_MenuItem)c).getDescriptor()) {
                c.setBackground(c.getBackground());
                continue;
            }
            c.setBackground(c.getForeground());
        }
        Class<? extends Plugin> _class = d.getPluginClass();
        String name = d.getName();
        String description = "<h3>Public description:</h3>";
        String author = d.getAuthor();
        if (d.getDescription().isEmpty()) {
            description = description + "<i>No description available.\nPlease leave a comment on the plugin page to request it.</i>";
        } else if (d.getDescription().equalsIgnoreCase(name + " plugin")) {
            name = StringUtil.getFlattened(_class.getSimpleName());
            if (name.toLowerCase().endsWith(" block")) {
                name = name.substring(0, name.toLowerCase().lastIndexOf(" block"));
            }
            description = description + "<i>This plug-in has no description.</i>";
        } else {
            description = description + "<i>" + d.getDescription() + "</i>";
        }
        try {
            InputStream stream = d.getPluginClass().getResourceAsStream(d.getSimpleClassName() + ".java");
            CompilationUnit unit = JavaParser.parse((InputStream)stream);
            stream.close();
            if (unit.getComments() != null) {
                TypeDeclaration declaration = (TypeDeclaration)unit.getTypes().get(0);
                JavadocComment doc = declaration.getJavaDoc();
                String docString = doc.getContent().trim().replace("* \n", "<br/>\n");
                String[] lines = (docString = docString.replace("* ", "").replace("\n", "")).split("<br/> ");
                if (lines.length > 0) {
                    description = description + "<h3>Developer documentation:</h3>";
                    description = description + "<i>";
                    for (String line : lines) {
                        if (line.startsWith("@")) {
                            if (!line.startsWith("@author") || !author.isEmpty()) continue;
                            author = line.replace("@author ", "");
                            continue;
                        }
                        while (line.contains("@link")) {
                            int start = line.indexOf("{@link");
                            int end = line.indexOf("}", start);
                            String link = line.substring(start, end + 1);
                            String[] linkWords = link.substring(7, link.length() - 1).split(" ");
                            String linkReplacement = "<b>";
                            if (linkWords.length == 1) {
                                linkReplacement = linkReplacement + linkWords[0];
                            } else {
                                linkReplacement = linkReplacement + linkWords[1];
                                for (int i = 2; i < linkWords.length; ++i) {
                                    linkReplacement = linkReplacement + " " + linkWords[i];
                                }
                            }
                            linkReplacement = linkReplacement + "</b>";
                            line = line.replace(link, linkReplacement);
                        }
                        description = description + line + "<br/>";
                    }
                    description = description + "</i>";
                }
            }
        }
        catch (Exception stream) {
            // empty catch block
        }
        String doc = "<html><body style=\"font-family: Tahoma\">";
        doc = doc + "<h2 align=\"center\">" + name + "</h2>";
        doc = doc + description;
        if (!author.isEmpty()) {
            doc = doc + "<p><b>Author: </b>" + author + "</p>";
        }
        if (!d.getWeb().isEmpty()) {
            doc = doc + "<p><a href=\"" + d.getWeb() + "\" ><b>More information...</b></a><br/>";
        }
        doc = doc + "</body></html>";
        this.blockInfo.setText(doc);
        this.blockInfo.setCaretPosition(0);
        this.blockInfoDisplay.revalidate();
        this.blockInfoDisplay.repaint();
    }

    private class MySplitPaneUI
    extends SubstanceSplitPaneUI {
        private MySplitPaneUI() {
        }

        public BasicSplitPaneDivider createDefaultDivider() {
            return new MySplitPaneDivider(this);
        }

        private class MySplitPaneDivider
        extends SubstanceSplitPaneDivider {
            public MySplitPaneDivider(SubstanceSplitPaneUI ui) {
                super(ui);
            }

            protected JButton createLeftOneTouchButton() {
                JButton button = super.createLeftOneTouchButton();
                button.setPreferredSize(new Dimension(40, 40));
                return button;
            }

            protected JButton createRightOneTouchButton() {
                JButton button = super.createRightOneTouchButton();
                button.setPreferredSize(new Dimension(40, 40));
                return button;
            }
        }
    }
}

