/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.deepicy.gui.consumers;

import icy.gui.main.ActiveSequenceListener;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import io.bioimage.modelrunner.gui.custom.ConsumerInterface;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.bioimageanalysis.icy.deepicy.tensor.SequenceRaiManager;

public abstract class SmallPluginAdapter
extends ConsumerInterface
implements ActiveSequenceListener {
    public abstract void setComponents(List<JComponent> var1);

    public abstract void setVarNames(List<String> var1);

    protected abstract void changeOnFocusGained(Sequence var1);

    public SmallPluginAdapter() {
        Icy.getMainInterface().addActiveSequenceListener((ActiveSequenceListener)this);
    }

    public String getModelsDir() {
        return new File("models").getAbsolutePath();
    }

    public <T extends RealType<T> & NativeType<T>> void display(RandomAccessibleInterval<T> rai, String axes, String name) {
        Sequence imp = SequenceRaiManager.convert(rai, axes);
        imp.setName(name);
        Icy.getMainInterface().addSequence(imp);
    }

    public <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> getFocusedImageAsRai() {
        Sequence imp = Icy.getMainInterface().getActiveSequence();
        if (imp == null) {
            return null;
        }
        RandomAccessibleInterval rai = SequenceRaiManager.convert(imp, "xyczt");
        if (imp.getDimension5D().sizeT == 1) {
            return Views.hyperSlice((RandomAccessibleInterval)Views.hyperSlice(rai, (int)4, (long)0L), (int)3, (long)0L);
        }
        return Views.hyperSlice(rai, (int)3, (long)0L);
    }

    public Object getFocusedImage() {
        return Icy.getMainInterface().getActiveSequence();
    }

    public String getFocusedImageName() {
        Sequence imp = Icy.getMainInterface().getActiveSequence();
        if (imp == null) {
            return null;
        }
        return imp.getName();
    }

    public Integer getFocusedImageChannels() {
        Sequence imp = Icy.getMainInterface().getActiveSequence();
        if (imp == null) {
            return null;
        }
        return imp.getDimension5D().sizeC;
    }

    public Integer getFocusedImageSlices() {
        Sequence imp = Icy.getMainInterface().getActiveSequence();
        if (imp == null) {
            return null;
        }
        return imp.getDimension5D().sizeZ;
    }

    public Integer getFocusedImageFrames() {
        Sequence imp = Icy.getMainInterface().getActiveSequence();
        if (imp == null) {
            return null;
        }
        return imp.getDimension5D().sizeT;
    }

    public Integer getFocusedImageWidth() {
        Sequence imp = Icy.getMainInterface().getActiveSequence();
        if (imp == null) {
            return null;
        }
        return imp.getWidth();
    }

    public Integer getFocusedImageHeight() {
        Sequence imp = Icy.getMainInterface().getActiveSequence();
        if (imp == null) {
            return null;
        }
        return imp.getDimension5D().sizeY;
    }

    public void sequenceActivated(Sequence sequence) {
        this.changeOnFocusGained(sequence);
    }

    public void sequenceDeactivated(Sequence sequence) {
    }

    public void activeSequenceChanged(SequenceEvent event) {
    }
}

