/*
 * Decompiled with CFR 0.152.
 */
package plugins.carlosuc3m.deepicy;

import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.PluginActionable;
import icy.sequence.Sequence;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptorFactory;
import io.bioimage.modelrunner.bioimageio.description.TensorSpec;
import io.bioimage.modelrunner.exceptions.LoadModelException;
import io.bioimage.modelrunner.exceptions.RunModelException;
import io.bioimage.modelrunner.gui.custom.CellposeGUI;
import io.bioimage.modelrunner.gui.custom.ConsumerInterface;
import io.bioimage.modelrunner.tensor.Tensor;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.bioimageanalysis.icy.deepicy.engines.Runner;
import org.bioimageanalysis.icy.deepicy.gui.GuiUtils;
import org.bioimageanalysis.icy.deepicy.gui.consumers.CellposeAdapter;
import org.bioimageanalysis.icy.deepicy.tensor.SequenceRaiManager;
import org.bioimageanalysis.icy.deepicy.utils.IcyGui;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarSequence;

public class DeepIcyCellpose
extends PluginActionable
implements Block {
    private boolean isProtocolBlock = false;
    private EzVarText selectModelFolder;
    private VarSequence selectImage;
    private VarSequence outputImage;

    public void run() {
        if (this.isProtocolBlock) {
            this.runProtocolBlock();
        } else {
            this.display();
        }
    }

    private void display() {
        File modelsDir = new File("models");
        if (!modelsDir.isDirectory() && !modelsDir.mkdir()) {
            throw new RuntimeException("Unable to create 'models' folder inside Icy directory. Please create it yourself.");
        }
        CellposeAdapter adapter = new CellposeAdapter();
        SwingUtilities.invokeLater(() -> {
            final CellposeGUI gui = new CellposeGUI((ConsumerInterface)adapter);
            IcyFrame frame = new IcyFrame("deepIcy Cellpose");
            frame.addFrameListener(new IcyFrameListener(){

                public void icyFrameClosed(IcyFrameEvent e) {
                    gui.close();
                }

                public void icyFrameOpened(IcyFrameEvent e) {
                }

                public void icyFrameClosing(IcyFrameEvent e) {
                }

                public void icyFrameIconified(IcyFrameEvent e) {
                }

                public void icyFrameDeiconified(IcyFrameEvent e) {
                }

                public void icyFrameActivated(IcyFrameEvent e) {
                }

                public void icyFrameDeactivated(IcyFrameEvent e) {
                }

                public void icyFrameInternalized(IcyFrameEvent e) {
                }

                public void icyFrameExternalized(IcyFrameEvent e) {
                }
            });
            gui.setCancelCallback(() -> frame.dispose());
            frame.add((Component)gui);
            frame.pack();
            frame.setVisible(true);
            this.addIcyFrame(frame);
        });
    }

    public static void main(String[] args) {
        Icy.main((String[])args);
        PluginLauncher.start((PluginDescriptor)PluginLoader.getPlugin((String)DeepIcyCellpose.class.getName()));
    }

    public void declareInput(VarList inputMap) {
        this.selectImage = new VarSequence("Input image", null);
        this.selectModelFolder = new EzVarText("Cellpose model", new String[]{"cyto3", "cyto2", "cyto", "nuclei", "your custom model (write the path to it)"}, 0, Boolean.valueOf(true));
        this.isProtocolBlock = true;
        inputMap.add("inputImage", (Var)this.selectImage);
        inputMap.add("cellposeModel", this.selectModelFolder.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        this.outputImage = new VarSequence("Output image", null);
        outputMap.add("outputImageSelector", (Var)this.outputImage);
    }

    private void runProtocolBlock() {
        try {
            if (this.selectModelFolder.getValue() != null) {
                this.runProtocolBlockModelLocally(null);
            } else {
                ModelDescriptor md = ModelDescriptorFactory.readFromLocalFile((String)((String)this.selectModelFolder.getValue() + File.separator + "rdf.yaml"));
                this.runProtocolBlockModelLocally(md);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private <T extends RealType<T> & NativeType<T>> void runProtocolBlockModelLocally(ModelDescriptor model) throws Exception {
        if (Thread.interrupted()) {
            throw new InterruptedException("Interrupted before model loading");
        }
        Runner runner = Runner.create(model);
        try {
            runner.load();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(((TensorSpec)runner.getDescriptor().getInputTensors().get(0)).getName(), this.selectImage.getValue());
            List list = new IcyGui().convertToInputTensors(map, runner.getDescriptor());
            List outs = runner.run(list);
            for (Tensor tt : outs) {
                if (!GuiUtils.isEDTAlive()) {
                    return;
                }
                Sequence im = SequenceRaiManager.convert(tt.getData(), tt.getAxesOrderString());
                this.outputImage.setValue(im);
            }
        }
        catch (LoadModelException | RunModelException | IOException e) {
            e.printStackTrace();
        }
    }
}

