/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.deepicy.tensor;

import icy.sequence.Sequence;
import io.bioimage.modelrunner.tensor.Utils;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import plugins.tinevez.imglib2icy.ImgLib2IcyFunctions;

public class SequenceRaiManager {
    private static final String ICY_AXES_ORDER = "xyczb";

    public static <T extends RealType<T> & NativeType<T>> Sequence convert(RandomAccessibleInterval<T> rai, String axesOrder) {
        String newImAxesOrder = SequenceRaiManager.removeExtraDims(rai, ICY_AXES_ORDER, axesOrder);
        rai = SequenceRaiManager.transposeToAxesOrder(rai, axesOrder, newImAxesOrder);
        return ImgLib2IcyFunctions.wrap(SequenceRaiManager.intervalToImg(rai));
    }

    public static <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> convert(Sequence imp, String axesOrder) {
        RandomAccessibleInterval<T> rai = ImgLib2IcyFunctions.wrap((Sequence)imp);
        String impAxesOrder = "";
        String[] ijAxesOrder = ICY_AXES_ORDER.split("");
        int[] dims = new int[5];
        dims[1] = imp.getHeight();
        dims[0] = imp.getWidth();
        dims[2] = (int)imp.getDimension5D().getSizeC();
        dims[3] = (int)imp.getDimension5D().getSizeZ();
        dims[4] = (int)imp.getDimension5D().getSizeT();
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i] == 1) continue;
            impAxesOrder = impAxesOrder + ijAxesOrder[i];
        }
        String newImAxesOrder = SequenceRaiManager.addExtraDims(rai, impAxesOrder, axesOrder);
        for (int i = 0; i < newImAxesOrder.length() - impAxesOrder.length(); ++i) {
            rai = Views.addDimension((RandomAccessibleInterval)rai, (long)0L, (long)0L);
        }
        rai = SequenceRaiManager.transposeToAxesOrder(rai, newImAxesOrder, axesOrder);
        return rai;
    }

    public static <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> permute(RandomAccessibleInterval<T> rai, String ogAxesOrder, String targetAxesOrder) {
        String newImAxesOrder = SequenceRaiManager.addExtraDims(rai, ogAxesOrder, targetAxesOrder);
        for (int i = 0; i < newImAxesOrder.length() - ogAxesOrder.length(); ++i) {
            rai = Views.addDimension(rai, (long)0L, (long)0L);
        }
        return SequenceRaiManager.transposeToAxesOrder(rai, newImAxesOrder, targetAxesOrder);
    }

    private static <T extends RealType<T> & NativeType<T>> String removeExtraDims(RandomAccessibleInterval<T> rai, String ogAxes, String targetAxes) {
        String nAxes = "";
        for (String ax : ogAxes.split("")) {
            if (!targetAxes.contains(ax)) continue;
            nAxes = nAxes + ax;
        }
        return nAxes;
    }

    private static <T extends RealType<T> & NativeType<T>> String addExtraDims(RandomAccessibleInterval<T> rai, String ogAxes, String targetAxes) {
        for (String ax : targetAxes.split("")) {
            if (ogAxes.contains(ax)) continue;
            ogAxes = ogAxes + ax;
        }
        return ogAxes;
    }

    private static <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> transposeToAxesOrder(RandomAccessibleInterval<T> rai, String ogAxes, String targetAxes) {
        int[] transformation = new int[ogAxes.length()];
        int c = 0;
        for (String ss : targetAxes.split("")) {
            transformation[c++] = ogAxes.indexOf(ss);
        }
        return Utils.rearangeAxes(rai, (int[])transformation);
    }

    public static <T extends RealType<T> & NativeType<T>> Img<T> intervalToImg(RandomAccessibleInterval<T> interval) {
        ArrayImg img = new ArrayImgFactory((NativeType)((RealType)interval.getType())).create(interval);
        LoopBuilder.setImages(interval, (RandomAccessibleInterval)img).forEachPixel((in, out) -> out.set((Type)in));
        return img;
    }
}

