/*
 * Decompiled with CFR 0.152.
 */
package plugins.carlosuc3m.deepicy;

import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.PluginActionable;
import icy.sequence.Sequence;
import io.bioimage.modelrunner.apposed.appose.Types;
import io.bioimage.modelrunner.exceptions.RunModelException;
import io.bioimage.modelrunner.gui.custom.CellposeGUI;
import io.bioimage.modelrunner.gui.custom.CellposePluginUI;
import io.bioimage.modelrunner.gui.custom.ConsumerInterface;
import io.bioimage.modelrunner.model.special.cellpose.Cellpose;
import io.bioimage.modelrunner.tensor.Tensor;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Cast;
import net.imglib2.view.Views;
import org.bioimageanalysis.icy.deepicy.gui.consumers.CellposeAdapter;
import org.bioimageanalysis.icy.deepicy.tensor.SequenceRaiManager;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzVarFloat;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarSequence;

public class DeepIcyCellpose
extends PluginActionable
implements Block {
    private boolean isProtocolBlock = false;
    private EzVarText selectModelFolder;
    private EzVarText cytoColor;
    private EzVarText nucleiColor;
    private EzVarFloat diameter;
    private VarSequence selectImage;
    private VarSequence outputImage;

    public void run() {
        if (this.isProtocolBlock) {
            try {
                this.runCellpose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.display();
        }
    }

    private void display() {
        File modelsDir = new File("models");
        if (!modelsDir.isDirectory() && !modelsDir.mkdir()) {
            throw new RuntimeException("Unable to create 'models' folder inside Icy directory. Please create it yourself.");
        }
        CellposeAdapter adapter = new CellposeAdapter();
        SwingUtilities.invokeLater(() -> {
            final CellposePluginUI gui = new CellposePluginUI((ConsumerInterface)adapter);
            IcyFrame frame = new IcyFrame("deepIcy Cellpose");
            frame.addFrameListener(new IcyFrameListener(){

                public void icyFrameClosed(IcyFrameEvent e) {
                    gui.close();
                }

                public void icyFrameOpened(IcyFrameEvent e) {
                }

                public void icyFrameClosing(IcyFrameEvent e) {
                }

                public void icyFrameIconified(IcyFrameEvent e) {
                }

                public void icyFrameDeiconified(IcyFrameEvent e) {
                }

                public void icyFrameActivated(IcyFrameEvent e) {
                }

                public void icyFrameDeactivated(IcyFrameEvent e) {
                }

                public void icyFrameInternalized(IcyFrameEvent e) {
                }

                public void icyFrameExternalized(IcyFrameEvent e) {
                }
            });
            gui.setCancelCallback(() -> frame.dispose());
            frame.add((Component)gui);
            frame.pack();
            frame.setVisible(true);
            frame.setResizable(true);
            frame.setSize(400, 200);
            this.addIcyFrame(frame);
        });
    }

    public static void main(String[] args) {
        Icy.main((String[])args);
        PluginLauncher.start((PluginDescriptor)PluginLoader.getPlugin((String)DeepIcyCellpose.class.getName()));
    }

    public void declareInput(VarList inputMap) {
        this.selectImage = new VarSequence("Input image", null);
        this.selectModelFolder = new EzVarText("Cellpose model", new String[]{"cyto3", "cyto2", "cyto", "nuclei", "your custom model (write the path to it)"}, 0, Boolean.valueOf(true));
        this.cytoColor = new EzVarText("Cytoplasm Color", new String[]{"gray", "red", "green", "blue"}, 0, Boolean.valueOf(false));
        this.nucleiColor = new EzVarText("Nuclei Color", new String[]{"gray", "red", "green", "blue"}, 0, Boolean.valueOf(false));
        this.diameter = new EzVarFloat("Diameter (-1 for auto)", -1.0f, -1.0f, 2.1474836E9f);
        this.isProtocolBlock = true;
        inputMap.add("inputImage", (Var)this.selectImage);
        inputMap.add("cellposeModel", this.selectModelFolder.getVariable());
        inputMap.add("cytoColor", this.cytoColor.getVariable());
        inputMap.add("nucleiColor", this.nucleiColor.getVariable());
        inputMap.add("diameter", this.diameter.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        this.outputImage = new VarSequence("Output image", null);
        outputMap.add("outputImageSelector", (Var)this.outputImage);
    }

    private <T extends RealType<T> & NativeType<T>> void runCellpose() throws Exception {
        this.installCellpose();
        if (this.selectImage.getValue() == null) {
            throw new IOException("No image open");
        }
        RandomAccessibleInterval rai = SequenceRaiManager.convert((Sequence)this.selectImage.getValue(), "xycz");
        String selectedModel = (String)this.selectModelFolder.getValue();
        if (selectedModel.equals("cyto3") || selectedModel.equals("cyto2") || selectedModel.equals("cyto") || selectedModel.equals("nuclei")) {
            selectedModel = Cellpose.findPretrainedModelInstalled((String)selectedModel, (String)new File("models").getAbsolutePath());
        }
        Cellpose cellpose = Cellpose.init((String)selectedModel);
        cellpose.loadModel();
        cellpose.setChannels(new int[]{(Integer)CellposeGUI.CHANNEL_MAP.get(this.cytoColor.getValue()), (Integer)CellposeGUI.CHANNEL_MAP.get(this.nucleiColor.getValue())});
        if (((Float)this.diameter.getValue()).floatValue() > 0.0f) {
            cellpose.setDiameter(((Float)this.diameter.getValue()).floatValue());
        }
        try {
            this.runCellposeOnFramesStack(rai, cellpose);
            cellpose.close();
        }
        catch (Exception ex) {
            cellpose.close();
            throw new RunModelException(Types.stackTrace((Throwable)ex));
        }
    }

    private <T extends RealType<T> & NativeType<T>, R extends RealType<R> & NativeType<R>> void runCellposeOnFramesStack(RandomAccessibleInterval<R> rai, Cellpose model) throws RunModelException {
        long[] dims = rai.dimensionsAsLongArray();
        RandomAccessibleInterval outMaskRai = (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.unsignedShorts((long[])new long[]{dims[0], dims[1], dims[3]}));
        int i = 0;
        while ((long)i < rai.dimensionsAsLongArray()[3]) {
            ArrayList<Tensor> inList = new ArrayList<Tensor>();
            Tensor inIm = Tensor.build((String)"input", (String)"xyc", (RandomAccessibleInterval)Views.hyperSlice(rai, (int)3, (long)i));
            inList.add(inIm);
            ArrayList<Tensor> outputList = new ArrayList<Tensor>();
            Tensor outMask = Tensor.build((String)"labels", (String)"xy", (RandomAccessibleInterval)Views.hyperSlice((RandomAccessibleInterval)outMaskRai, (int)2, (long)i));
            outputList.add(outMask);
            model.run(inList, outputList);
            ++i;
        }
        Sequence im = SequenceRaiManager.convert(outMaskRai, "xyz");
        this.outputImage.setValue(im);
    }

    private void installCellpose() {
    }
}

