/*
 * Decompiled with CFR 0.152.
 */
package plugins.carlosuc3m.deepicy;

import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.PluginActionable;
import icy.sequence.Sequence;
import io.bioimage.modelrunner.apposed.appose.MambaInstallException;
import io.bioimage.modelrunner.apposed.appose.Types;
import io.bioimage.modelrunner.exceptions.LoadModelException;
import io.bioimage.modelrunner.exceptions.RunModelException;
import io.bioimage.modelrunner.gui.custom.ConsumerInterface;
import io.bioimage.modelrunner.gui.custom.StardistGUI;
import io.bioimage.modelrunner.model.special.stardist.Stardist2D;
import io.bioimage.modelrunner.model.special.stardist.StardistAbstract;
import io.bioimage.modelrunner.tensor.Tensor;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Cast;
import net.imglib2.view.Views;
import org.apache.commons.compress.archivers.ArchiveException;
import org.bioimageanalysis.icy.deepicy.gui.consumers.StardistAdapter;
import org.bioimageanalysis.icy.deepicy.tensor.SequenceRaiManager;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzVarFloat;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarSequence;

public class DeepIcyStardist
extends PluginActionable
implements Block {
    private boolean isProtocolBlock = false;
    private EzVarText selectModelFolder;
    private EzVarFloat maxPercentile;
    private EzVarFloat minPercentile;
    private VarSequence selectImage;
    private VarSequence outputImage;
    private static final String ONE_CHANNEL = "2D_versatile_fluo (1 channel)";
    private static final String THREE_CHANNEL = "2D_versatile_he (3 channel)";
    private static final String CUSTOM_STR = "your custom model (write the path to it)";

    public void run() {
        if (this.isProtocolBlock) {
            try {
                this.runStardist();
            }
            catch (MambaInstallException | LoadModelException | RunModelException | IOException | InterruptedException | RuntimeException | URISyntaxException | ArchiveException e) {
                e.printStackTrace();
            }
        } else {
            this.display();
        }
    }

    public void display() {
        File modelsDir = new File("models");
        if (!modelsDir.isDirectory() && !modelsDir.mkdir()) {
            throw new RuntimeException("Unable to create 'models' folder inside Icy directory. Please create it yourself.");
        }
        StardistAdapter adapter = new StardistAdapter();
        SwingUtilities.invokeLater(() -> {
            final StardistGUI gui = new StardistGUI((ConsumerInterface)adapter);
            IcyFrame frame = new IcyFrame("deepIcy StarDist");
            frame.addFrameListener(new IcyFrameListener(){

                public void icyFrameClosed(IcyFrameEvent e) {
                    gui.close();
                }

                public void icyFrameOpened(IcyFrameEvent e) {
                }

                public void icyFrameClosing(IcyFrameEvent e) {
                }

                public void icyFrameIconified(IcyFrameEvent e) {
                }

                public void icyFrameDeiconified(IcyFrameEvent e) {
                }

                public void icyFrameActivated(IcyFrameEvent e) {
                }

                public void icyFrameDeactivated(IcyFrameEvent e) {
                }

                public void icyFrameInternalized(IcyFrameEvent e) {
                }

                public void icyFrameExternalized(IcyFrameEvent e) {
                }
            });
            gui.setCancelCallback(() -> frame.dispose());
            frame.add((Component)gui);
            frame.pack();
            frame.setVisible(true);
            this.addIcyFrame(frame);
        });
    }

    public static void main(String[] args) {
        Icy.main((String[])args);
        PluginLauncher.start((PluginDescriptor)PluginLoader.getPlugin((String)DeepIcyStardist.class.getName()));
    }

    public void declareInput(VarList inputMap) {
        this.selectImage = new VarSequence("Input image", null);
        this.selectModelFolder = new EzVarText("StarDist model", new String[]{ONE_CHANNEL, THREE_CHANNEL, CUSTOM_STR}, 0, Boolean.valueOf(true));
        this.minPercentile = new EzVarFloat("Min Percentile (normalization)", 1.0f, 0.0f, 100.0f, 0.1f);
        this.maxPercentile = new EzVarFloat("Max Percentile (normalization)", 99.8f, 0.0f, 100.0f, 0.1f);
        this.isProtocolBlock = true;
        inputMap.add("inputImage", (Var)this.selectImage);
        inputMap.add("stardistModel", this.selectModelFolder.getVariable());
        inputMap.add("minPercentile", this.minPercentile.getVariable());
        inputMap.add("maxPercentile", this.maxPercentile.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        this.outputImage = new VarSequence("Output image", null);
        outputMap.add("outputImageSelector", (Var)this.outputImage);
    }

    private <T extends RealType<T> & NativeType<T>> void runStardist() throws IOException, RunModelException, LoadModelException, InterruptedException, RuntimeException, MambaInstallException, ArchiveException, URISyntaxException {
        this.installStardist(this.weightsInstalled(), StardistAbstract.isInstalled());
        if (this.selectImage.getValue() == null) {
            throw new IOException("No image open");
        }
        RandomAccessibleInterval rai = SequenceRaiManager.convert((Sequence)this.selectImage.getValue(), "xycz");
        String selectedModel = (String)this.selectModelFolder.getValue();
        Object model = null;
        model = selectedModel.equals(ONE_CHANNEL) || selectedModel.equals(THREE_CHANNEL) ? Stardist2D.fromPretained((String)selectedModel, (String)new File("models").getAbsolutePath(), (boolean)false) : StardistAbstract.init((String)selectedModel);
        model.scaleRangeMaxPercentile = ((Float)this.maxPercentile.getValue()).floatValue();
        model.scaleRangeMinPercentile = ((Float)this.minPercentile.getValue()).floatValue();
        try {
            this.runStardistOnFramesStack((RandomAccessibleInterval)rai, (StardistAbstract)model);
            model.close();
        }
        catch (Exception ex) {
            model.close();
            throw new RunModelException(Types.stackTrace((Throwable)ex));
        }
    }

    private void installStardist(boolean weightsInstalled, boolean envInstalled) throws IOException, InterruptedException, RuntimeException, MambaInstallException, ArchiveException, URISyntaxException {
        if (!envInstalled) {
            StardistAbstract.installRequirements(str -> System.out.println((String)str));
        }
        if (!weightsInstalled) {
            Consumer<Double> cons = dd -> {
                dd = (double)Math.round(dd * 1000.0) / 10.0;
                System.out.println("Downloading " + (String)this.selectModelFolder.getValue() + ": " + dd + "%");
            };
            Stardist2D.donwloadPretrained((String)((String)this.selectModelFolder.getValue()), (String)new File("models").getAbsolutePath(), cons);
        }
    }

    private <T extends RealType<T> & NativeType<T>, R extends RealType<R> & NativeType<R>> void runStardistOnFramesStack(RandomAccessibleInterval<R> rai, StardistAbstract model) throws RunModelException {
        long[] dims = rai.dimensionsAsLongArray();
        RandomAccessibleInterval outMaskRai = (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.floats((long[])new long[]{dims[0], dims[1], dims[3]}));
        int i = 0;
        while ((long)i < rai.dimensionsAsLongArray()[3]) {
            ArrayList<Tensor> inList = new ArrayList<Tensor>();
            Tensor inIm = Tensor.build((String)"input", (String)"xyc", (RandomAccessibleInterval)Views.hyperSlice(rai, (int)3, (long)i));
            inList.add(inIm);
            ArrayList<Tensor> outputList = new ArrayList<Tensor>();
            Tensor outMask = Tensor.build((String)"mask", (String)"xy", (RandomAccessibleInterval)Views.hyperSlice((RandomAccessibleInterval)outMaskRai, (int)2, (long)i));
            outputList.add(outMask);
            model.run(inList, outputList);
            ++i;
        }
        Sequence im = SequenceRaiManager.convert(outMaskRai, "xyz");
        this.outputImage.setValue(im);
    }

    private boolean weightsInstalled() {
        String model = (String)this.selectModelFolder.getValue();
        if (model.equals(CUSTOM_STR)) {
            return true;
        }
        try {
            Stardist2D pretrained = Stardist2D.fromPretained((String)model, (String)new File("models").getAbsolutePath(), (boolean)false);
            if (pretrained == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

