/*
 * Decompiled with CFR 0.152.
 */
package plugins.carlosuc3m.deepicy;

import icy.gui.dialog.MessageDialog;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.PluginActionable;
import icy.sequence.Sequence;
import io.bioimage.modelrunner.apposed.appose.Types;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptorFactory;
import io.bioimage.modelrunner.bioimageio.description.TensorSpec;
import io.bioimage.modelrunner.exceptions.LoadModelException;
import io.bioimage.modelrunner.exceptions.RunModelException;
import io.bioimage.modelrunner.gui.Gui;
import io.bioimage.modelrunner.gui.adapter.GuiAdapter;
import io.bioimage.modelrunner.tensor.Tensor;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.bioimageanalysis.icy.deepicy.engines.Runner;
import org.bioimageanalysis.icy.deepicy.gui.GuiUtils;
import org.bioimageanalysis.icy.deepicy.tensor.SequenceRaiManager;
import org.bioimageanalysis.icy.deepicy.utils.IcyGui;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarListener;

public class DeepIcy
extends PluginActionable
implements Block {
    private boolean isProtocolBlock = false;
    private Map<String, ModelDescriptor> modelsMap;
    private EzVarText selectModelFolder;
    private EzVarText selectModelName;
    private VarSequence selectImage;
    private VarSequence outputImage;
    private static final String LOADING_MODELS_STR = "Loading models...";
    private static final String SELECT_MODEL_STR = "Please select a model";
    private static final String IMAGE_NOT_SELECTED_HEADER = "Please select an image";
    private static final String IMAGE_NOT_SELECTED_MSG = "In order to run the Protocol, and image must be selected as input tensor";
    private static final String MODEL_EXECUTION_HEADER = "Error during the execution of the model";
    private final VarListener<String> modelListener = new VarListener<String>(){

        public void valueChanged(Var<String> source, String oldValue, String newValue) {
            if (!oldValue.equals(newValue) && !newValue.equals(DeepIcy.SELECT_MODEL_STR)) {
                ModelDescriptor descriptor = (ModelDescriptor)DeepIcy.this.modelsMap.get(DeepIcy.this.selectModelFolder.getValue());
                DeepIcy.this.selectModelName.setValue((Object)descriptor.getName());
            } else if (!oldValue.equals(newValue) && newValue.equals(DeepIcy.SELECT_MODEL_STR)) {
                DeepIcy.this.selectModelName.setValue((Object)"");
            }
        }

        public void referenceChanged(Var<String> source, Var<? extends String> oldReference, Var<? extends String> newReference) {
        }
    };

    public void run() {
        if (!this.isProtocolBlock) {
            this.display();
        } else {
            if (!this.checkBlockInputs()) {
                return;
            }
            this.runProtocolBlock();
        }
    }

    private void display() {
        File modelsDir = new File("models");
        if (!modelsDir.isDirectory() && !modelsDir.mkdir()) {
            throw new RuntimeException("Unable to create 'models' folder inside ImageJ/Fiji directory. Please create it yourself.");
        }
        SwingUtilities.invokeLater(() -> {
            final Gui gui = new Gui((GuiAdapter)new IcyGui());
            gui.setPreferredSize(new Dimension(600, 700));
            IcyFrame frame = new IcyFrame("deepIcy");
            frame.addFrameListener(new IcyFrameListener(){

                public void icyFrameClosed(IcyFrameEvent e) {
                    gui.onClose();
                }

                public void icyFrameOpened(IcyFrameEvent e) {
                }

                public void icyFrameClosing(IcyFrameEvent e) {
                }

                public void icyFrameIconified(IcyFrameEvent e) {
                }

                public void icyFrameDeiconified(IcyFrameEvent e) {
                }

                public void icyFrameActivated(IcyFrameEvent e) {
                }

                public void icyFrameDeactivated(IcyFrameEvent e) {
                }

                public void icyFrameInternalized(IcyFrameEvent e) {
                }

                public void icyFrameExternalized(IcyFrameEvent e) {
                }
            });
            frame.add((Component)gui);
            frame.pack();
            frame.setVisible(true);
            frame.setResizable(true);
            this.addIcyFrame(frame);
        });
    }

    public static void main(String[] args) {
        Icy.main((String[])args);
        PluginLauncher.start((PluginDescriptor)PluginLoader.getPlugin((String)DeepIcy.class.getName()));
    }

    public void declareInput(VarList inputMap) {
        this.isProtocolBlock = true;
        this.initializeBlockVars();
        this.selectModelFolder.getVariable().addListener(this.modelListener);
        inputMap.add("inputImage", (Var)this.selectImage);
        inputMap.add("modelFolderSelector", this.selectModelFolder.getVariable());
        inputMap.add("modelNameSelector", this.selectModelName.getVariable());
    }

    private void initializeBlockVars() {
        this.selectModelFolder = new EzVarText("Model folder", new String[]{LOADING_MODELS_STR}, 0, Boolean.valueOf(false));
        List models = ModelDescriptorFactory.getModelsAtLocalRepo((String)new File("models").getAbsolutePath());
        ArrayList<String> modelsList = new ArrayList<String>();
        modelsList.add(SELECT_MODEL_STR);
        modelsList.addAll(models.stream().map(i -> new File(i.getModelPath()).getName()).collect(Collectors.toList()));
        Object[] modelsArr = modelsList.toArray(new String[modelsList.size()]);
        this.selectModelFolder.setDefaultValues(modelsArr, 0, false);
        this.selectModelName = new EzVarText("Model name", "", 1);
        this.selectImage = new VarSequence("Input image", null);
        this.modelsMap = new HashMap<String, ModelDescriptor>();
        for (ModelDescriptor md : models) {
            this.modelsMap.put(new File(md.getModelPath()).getName(), md);
        }
        this.selectModelName.getVariable().setEnabled(false);
    }

    public void declareOutput(VarList outputMap) {
        this.outputImage = new VarSequence("Output image", null);
        outputMap.add("outputImageSelector", (Var)this.outputImage);
    }

    private boolean checkBlockInputs() {
        return this.checkImageIsSelected();
    }

    private boolean checkImageIsSelected() {
        if (this.selectImage.getValue() != null) {
            return true;
        }
        MessageDialog.showDialog((String)IMAGE_NOT_SELECTED_HEADER, (String)IMAGE_NOT_SELECTED_MSG, (int)0);
        return false;
    }

    private void runProtocolBlock() {
        try {
            if (this.modelsMap.get(this.selectModelFolder.getValue()) != null) {
                this.runProtocolBlockModelLocally(this.modelsMap.get(this.selectModelFolder.getValue()));
            } else {
                ModelDescriptor md = ModelDescriptorFactory.readFromLocalFile((String)((String)this.selectModelFolder.getValue() + File.separator + "rdf.yaml"));
                this.runProtocolBlockModelLocally(md);
            }
        }
        catch (Exception ex) {
            MessageDialog.showDialog((String)MODEL_EXECUTION_HEADER, (String)Types.stackTrace((Throwable)ex), (int)0);
        }
    }

    private <T extends RealType<T> & NativeType<T>> void runProtocolBlockModelLocally(ModelDescriptor model) throws Exception {
        if (Thread.interrupted()) {
            throw new InterruptedException("Interrupted before model loading");
        }
        Runner runner = Runner.create(model);
        try {
            runner.load();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(((TensorSpec)runner.getDescriptor().getInputTensors().get(0)).getName(), this.selectImage.getValue());
            List list = new IcyGui().convertToInputTensors(map, runner.getDescriptor());
            List outs = runner.run(list);
            for (Tensor tt : outs) {
                if (!GuiUtils.isEDTAlive()) {
                    return;
                }
                Sequence im = SequenceRaiManager.convert(tt.getData(), tt.getAxesOrderString());
                this.outputImage.setValue(im);
            }
        }
        catch (LoadModelException | RunModelException | IOException e) {
            e.printStackTrace();
        }
    }
}

