/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.frame;

import icy.file.FileUtil;
import icy.image.ImageUtil;
import icy.util.ClassUtil;
import icy.util.Random;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class SplashScreenFrame
extends JFrame {
    private static final long serialVersionUID = -519109094312389176L;
    private final SplashPanel splash = new SplashPanel();

    public SplashScreenFrame() {
        super("Icy");
        this.setUndecorated(true);
        this.add(this.splash);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public class SplashPanel
    extends JPanel {
        private static final long serialVersionUID = -6955085853269659076L;
        private static final String SPLASH_FOLDER = "image/splash";
        private static final int DEFAULT_WIDTH = 960;
        private static final int DEFAULT_HEIGTH = 300;
        private BufferedImage image = null;

        public SplashPanel() {
            String[] files = FileUtil.getFiles(SPLASH_FOLDER, null, false, false, false);
            if (files.length > 0) {
                this.image = ImageUtil.load(files[Random.nextInt(files.length)]);
            } else {
                try {
                    URL url;
                    files = ClassUtil.getResourcesInPackage(SPLASH_FOLDER, null, true, false, false, false).toArray(new String[0]);
                    if (files.length > 0 && (url = this.getClass().getResource("/" + files[Random.nextInt(files.length)])) != null) {
                        this.image = ImageUtil.load(url, true);
                    }
                }
                catch (Exception e) {
                    System.err.println("Warning: cannot load splashscreen image");
                }
            }
            if (this.image != null) {
                this.setPreferredSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
            } else {
                this.setPreferredSize(new Dimension(960, 300));
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, this);
            }
        }
    }
}

