/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.inspector;

import icy.gui.component.IcyTextField;
import icy.main.Icy;
import icy.resource.ResourceUtil;
import icy.swimmingPool.SwimmingObject;
import icy.swimmingPool.SwimmingPool;
import icy.swimmingPool.SwimmingPoolEvent;
import icy.swimmingPool.SwimmingPoolListener;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SwimmingPoolPanel
extends JPanel
implements IcyTextField.TextChangeListener,
ListSelectionListener,
SwimmingPoolListener {
    private static final long serialVersionUID = 1565643301342039659L;
    static final String[] columnNames = new String[]{"", "Name", "Type"};
    final SwimmingPool swimmingPool = Icy.getMainInterface().getSwimmingPool();
    ArrayList<SwimmingObject> objects;
    final AbstractTableModel tableModel;
    final JTable table;
    final JComboBox objectType;
    final JPanel objectTypePanel;
    final IcyTextField nameFilter;
    final JButton refreshButton;
    final JButton deleteAllButton;
    final JButton deleteButton;

    public SwimmingPoolPanel(boolean showTypeFilter, boolean showNameFilter, boolean showButtons) {
        if (this.swimmingPool != null) {
            this.swimmingPool.addListener(this);
        }
        this.objects = new ArrayList();
        this.objectType = new JComboBox(new DefaultComboBoxModel());
        this.objectType.setToolTipText("Select type to display");
        this.objectType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SwimmingPoolPanel.this.objectType.getSelectedIndex() != -1) {
                    SwimmingPoolPanel.this.refreshObjects();
                    SwimmingPoolPanel.this.refreshTableData();
                }
            }
        });
        this.objectTypePanel = new JPanel();
        this.objectTypePanel.setLayout(new BoxLayout(this.objectTypePanel, 3));
        this.objectTypePanel.setVisible(showTypeFilter);
        JPanel internalRepPanel = new JPanel();
        internalRepPanel.setLayout(new BoxLayout(internalRepPanel, 2));
        internalRepPanel.add(new JLabel("Object type :"));
        internalRepPanel.add(Box.createHorizontalStrut(8));
        internalRepPanel.add(this.objectType);
        internalRepPanel.add(Box.createHorizontalGlue());
        this.objectTypePanel.add(internalRepPanel);
        this.objectTypePanel.add(Box.createVerticalStrut(8));
        this.nameFilter = new IcyTextField();
        this.nameFilter.addTextChangeListener(this);
        this.nameFilter.setVisible(showNameFilter);
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwimmingPoolPanel.this.refreshObjectTypeList();
                SwimmingPoolPanel.this.refreshObjects();
            }
        });
        this.deleteAllButton = new JButton("Delete all");
        this.deleteAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwimmingPoolPanel.this.swimmingPool.removeAll();
            }
        });
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (SwimmingObject so : SwimmingPoolPanel.this.getSelectedObjects()) {
                    SwimmingPoolPanel.this.swimmingPool.remove(so);
                }
            }
        });
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 8, 8));
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 2));
        buttonsPanel.setVisible(showButtons);
        buttonsPanel.add(this.refreshButton);
        buttonsPanel.add(Box.createHorizontalStrut(64));
        buttonsPanel.add(this.deleteAllButton);
        buttonsPanel.add(Box.createHorizontalStrut(8));
        buttonsPanel.add(this.deleteButton);
        buttonsPanel.add(Box.createHorizontalGlue());
        this.tableModel = new AbstractTableModel(){
            private static final long serialVersionUID = -8573364273165723214L;

            @Override
            public int getColumnCount() {
                return columnNames.length;
            }

            @Override
            public String getColumnName(int column) {
                return columnNames[column];
            }

            @Override
            public int getRowCount() {
                return SwimmingPoolPanel.this.objects.size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                SwimmingObject so = SwimmingPoolPanel.this.objects.get(row);
                switch (column) {
                    case 0: {
                        return ResourceUtil.scaleIcon(so.getIcon(), 24);
                    }
                    case 1: {
                        return so.getName();
                    }
                    case 2: {
                        return so.getObjectSimpleClassName();
                    }
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return ImageIcon.class;
                }
                return String.class;
            }
        };
        this.table = new JTable(this.tableModel);
        TableColumnModel colModel = this.table.getColumnModel();
        TableColumn col = colModel.getColumn(0);
        col.setPreferredWidth(32);
        col.setMinWidth(32);
        col.setResizable(false);
        col = colModel.getColumn(1);
        col.setPreferredWidth(100);
        col.setMinWidth(60);
        col = colModel.getColumn(2);
        col.setPreferredWidth(80);
        col.setMinWidth(40);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setRowHeight(24);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setShowVerticalLines(false);
        this.table.setAutoCreateRowSorter(true);
        this.table.setAutoResizeMode(0);
        this.setLayout(new BoxLayout(this, 3));
        this.add(Box.createVerticalStrut(2));
        if (showTypeFilter) {
            this.add(this.objectTypePanel);
        }
        if (showNameFilter) {
            this.add(this.nameFilter);
        }
        if (showTypeFilter || showNameFilter) {
            this.add(Box.createVerticalStrut(8));
        }
        this.add(this.table.getTableHeader());
        this.add(new JScrollPane(this.table));
        if (showButtons) {
            this.add(buttonsPanel);
        }
        this.validate();
        this.refreshObjectTypeList();
        this.refreshObjects();
    }

    public void setTypeFilter(String type) {
        this.objectType.setSelectedItem(type);
    }

    public void setNameFilter(String name) {
        this.nameFilter.setText(name);
    }

    protected void refreshObjects() {
        if (this.swimmingPool != null) {
            this.objects = this.filterList(this.swimmingPool.getObjects(), this.nameFilter.getText());
        } else {
            this.objects.clear();
        }
    }

    protected int getObjectIndex(SwimmingObject object) {
        return this.objects.indexOf(object);
    }

    protected int getObjectModelIndex(SwimmingObject object) {
        return this.getObjectIndex(object);
    }

    protected int getObjectTableIndex(SwimmingObject object) {
        int ind = this.getObjectModelIndex(object);
        if (ind == -1) {
            return ind;
        }
        try {
            return this.table.convertRowIndexToView(ind);
        }
        catch (IndexOutOfBoundsException e) {
            return -1;
        }
    }

    public ArrayList<SwimmingObject> getSelectedObjects() {
        ArrayList<SwimmingObject> result = new ArrayList<SwimmingObject>();
        int[] nArray = this.table.getSelectedRows();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int rowIndex = nArray[n2];
            int index = -1;
            if (rowIndex != -1) {
                try {
                    index = this.table.convertRowIndexToModel(rowIndex);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (index >= 0 || index < this.objects.size()) {
                result.add(this.objects.get(index));
            }
            ++n2;
        }
        return result;
    }

    public void setSelectedObjects(ArrayList<SwimmingObject> sos) {
        this.table.clearSelection();
        for (SwimmingObject so : sos) {
            int index = this.getObjectTableIndex(so);
            if (index <= -1) continue;
            this.table.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    protected void refreshObjectTypeList() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.objectType.getModel();
        Object savedItem = model.getSelectedItem();
        model.removeAllElements();
        model.addElement("ALL");
        if (this.swimmingPool != null) {
            for (String type : SwimmingObject.getObjectTypes(this.swimmingPool.getObjects())) {
                model.addElement(type);
            }
        }
        if (savedItem != null) {
            model.setSelectedItem(savedItem);
        } else {
            this.objectType.setSelectedIndex(0);
        }
    }

    private ArrayList<SwimmingObject> filterList(ArrayList<SwimmingObject> list, String nameFilterText) {
        ArrayList<SwimmingObject> result = new ArrayList<SwimmingObject>();
        boolean typeEmpty = this.objectType.getSelectedIndex() == 0;
        boolean nameEmpty = StringUtil.isEmpty(nameFilterText, true);
        String typeFilter = !typeEmpty ? this.objectType.getSelectedItem().toString() : "";
        String nameFilterUp = !nameEmpty ? nameFilterText.toUpperCase() : "";
        for (SwimmingObject so : list) {
            if (!typeEmpty && !so.getObjectSimpleClassName().equals(typeFilter) || !nameEmpty && so.getName().indexOf(nameFilterUp) == -1) continue;
            result.add(so);
        }
        return result;
    }

    protected void refreshTableData() {
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                ArrayList<SwimmingObject> sos = SwimmingPoolPanel.this.getSelectedObjects();
                SwimmingPoolPanel.this.tableModel.fireTableDataChanged();
                SwimmingPoolPanel.this.setSelectedObjects(sos);
            }
        });
    }

    protected void refreshButtonsPanel() {
        this.deleteButton.setEnabled(this.getSelectedObjects().size() > 0);
        this.deleteAllButton.setEnabled(this.objects.size() > 0);
    }

    protected void pluginsChanged() {
        this.refreshObjects();
        this.refreshTableData();
        this.refreshButtonsPanel();
    }

    @Override
    public void textChanged(IcyTextField source, boolean validate) {
        this.pluginsChanged();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.refreshButtonsPanel();
    }

    @Override
    public void swimmingPoolChangeEvent(SwimmingPoolEvent swimmingPoolEvent) {
        this.refreshObjectTypeList();
        this.refreshObjects();
    }
}

