/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom.areax;

import icy.type.geom.areax.EmptyPathException;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;

public class ShapeBounds {
    public static Rectangle2D getBounds(Shape ... shapes) {
        Rectangle2D r = null;
        int a = 0;
        while (a < shapes.length) {
            try {
                Rectangle2D t = ShapeBounds.getBounds(shapes[a], null);
                if (r == null) {
                    r = t;
                } else {
                    r.add(t);
                }
            }
            catch (EmptyPathException emptyPathException) {
                // empty catch block
            }
            ++a;
        }
        return r;
    }

    public static Rectangle2D getBounds(Shape shape, AffineTransform transform) throws EmptyPathException {
        return ShapeBounds.getBounds(shape.getPathIterator(transform));
    }

    public static Rectangle2D getBounds(PathIterator pi) {
        double[] coeff = new double[4];
        double[] deriv_coeff = new double[3];
        double[] coords = new double[6];
        double[] bounds = null;
        double lastX = 0.0;
        double lastY = 0.0;
        double endX = 0.0;
        double endY = 0.0;
        while (!pi.isDone()) {
            block17: {
                int type = pi.currentSegment(coords);
                switch (type) {
                    case 0: {
                        if (bounds == null) {
                            bounds = new double[]{coords[0], coords[0], coords[1], coords[1]};
                        }
                        endX = coords[0];
                        endY = coords[1];
                        break;
                    }
                    case 1: {
                        endX = coords[0];
                        endY = coords[1];
                        break;
                    }
                    case 2: {
                        endX = coords[2];
                        endY = coords[3];
                        break;
                    }
                    case 3: {
                        endX = coords[4];
                        endY = coords[5];
                        break;
                    }
                    default: {
                        break block17;
                    }
                }
                if (endX < bounds[0]) {
                    bounds[0] = endX;
                }
                if (endX > bounds[1]) {
                    bounds[1] = endX;
                }
                if (endY < bounds[2]) {
                    bounds[2] = endY;
                }
                if (endY > bounds[3]) {
                    bounds[3] = endY;
                }
                switch (type) {
                    case 2: {
                        ShapeBounds.accumulateExtremaBoundsForQuad(bounds, 0, lastX, coords[0], coords[2], coeff, deriv_coeff);
                        ShapeBounds.accumulateExtremaBoundsForQuad(bounds, 2, lastY, coords[1], coords[3], coeff, deriv_coeff);
                        break;
                    }
                    case 3: {
                        ShapeBounds.accumulateExtremaBoundsForCubic(bounds, 0, lastX, coords[0], coords[2], coords[4], coeff, deriv_coeff);
                        ShapeBounds.accumulateExtremaBoundsForCubic(bounds, 2, lastY, coords[1], coords[3], coords[5], coeff, deriv_coeff);
                        break;
                    }
                }
                lastX = endX;
                lastY = endY;
            }
            pi.next();
        }
        if (bounds != null) {
            return new Rectangle2D.Double((double)bounds[0], (double)bounds[2], (double)(bounds[1] - bounds[0]), (double)(bounds[3] - bounds[2]));
        }
        return new Rectangle2D.Double();
    }

    private static void accumulateExtremaBoundsForQuad(double[] bounds, int boundsOffset, double x1, double ctrlX, double x2, double[] coeff, double[] deriv_coeff) {
        if (ctrlX < bounds[boundsOffset] || ctrlX > bounds[boundsOffset + 1]) {
            double dx21 = ctrlX - x1;
            coeff[2] = x2 - ctrlX - dx21;
            coeff[1] = 2.0 * dx21;
            coeff[0] = x1;
            deriv_coeff[0] = coeff[1];
            deriv_coeff[1] = 2.0 * coeff[2];
            double t = -deriv_coeff[0] / deriv_coeff[1];
            if (t > 0.0 && t < 1.0) {
                double v = coeff[0] + t * (coeff[1] + t * coeff[2]);
                double margin = Math.ulp(Math.abs(coeff[0]) + Math.abs(coeff[1]) + Math.abs(coeff[2]));
                if (v - margin < bounds[boundsOffset]) {
                    bounds[boundsOffset] = v - margin;
                }
                if (v + margin > bounds[boundsOffset + 1]) {
                    bounds[boundsOffset + 1] = v + margin;
                }
            }
        }
    }

    private static void accumulateExtremaBoundsForCubic(double[] bounds, int boundsOffset, double x1, double ctrlX1, double ctrlX2, double x2, double[] coeff, double[] deriv_coeff) {
        if (ctrlX1 < bounds[boundsOffset] || ctrlX1 > bounds[boundsOffset + 1] || ctrlX2 < bounds[boundsOffset] || ctrlX2 > bounds[boundsOffset + 1]) {
            double dx32 = 3.0 * (ctrlX2 - ctrlX1);
            double dx21 = 3.0 * (ctrlX1 - x1);
            coeff[3] = x2 - x1 - dx32;
            coeff[2] = dx32 - dx21;
            coeff[1] = dx21;
            coeff[0] = x1;
            deriv_coeff[0] = coeff[1];
            deriv_coeff[1] = 2.0 * coeff[2];
            deriv_coeff[2] = 3.0 * coeff[3];
            double[] tExtrema = deriv_coeff;
            int tExtremaCount = QuadCurve2D.solveQuadratic(deriv_coeff, tExtrema);
            if (tExtremaCount > 0) {
                double margin = Math.ulp(Math.abs(coeff[0]) + Math.abs(coeff[1]) + Math.abs(coeff[2]) + Math.abs(coeff[3]));
                int i = 0;
                while (i < tExtremaCount) {
                    double t = tExtrema[i];
                    if (t > 0.0 && t < 1.0) {
                        double v = coeff[0] + t * (coeff[1] + t * (coeff[2] + t * coeff[3]));
                        if (v - margin < bounds[boundsOffset]) {
                            bounds[boundsOffset] = v - margin;
                        }
                        if (v + margin > bounds[boundsOffset + 1]) {
                            bounds[boundsOffset + 1] = v + margin;
                        }
                    }
                    ++i;
                }
            }
        }
    }
}

