/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.versionmanagement;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.reflect.TypeToken;
import io.bioimage.modelrunner.versionmanagement.AvailableEngines;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SupportedVersions {
    private static HashMap<String, Object> ALL_VERSIONS;
    private static String javaVersionsKey;
    private LinkedTreeMap<String, Object> versionsDic;
    private Set<String> versionSet;

    public static void main(String[] args) {
        String vv = SupportedVersions.getClosestSupportedPythonVersion("tensorflow", "2.13.0");
        String v1 = SupportedVersions.getClosestSupportedPythonVersion("tensorflow", "2");
        String v2 = SupportedVersions.getClosestSupportedPythonVersion("tensorflow", "2.8");
        String v3 = SupportedVersions.getClosestSupportedPythonVersion("tensorflow", "2.1");
        String v4 = SupportedVersions.getClosestSupportedPythonVersion("tensorflow", "2.1.70");
        String v5 = SupportedVersions.getClosestSupportedPythonVersion("tensorflow", "3");
        String v7 = SupportedVersions.getClosestSupportedPythonVersion("onnx", "20");
        String v8 = SupportedVersions.getClosestSupportedPythonVersion("onnx", "13");
        System.out.print(false);
    }

    public SupportedVersions(String engine) {
        engine = AvailableEngines.getSupportedFrameworkTag(engine);
        this.versionsDic = engine == null ? new LinkedTreeMap() : SupportedVersions.getSupportedVersionsForEngine(engine);
        this.versionSet = this.versionsDic == null ? Collections.emptySet() : this.versionsDic.keySet();
    }

    public String getClosestSupportedPythonVersion(String version) {
        return SupportedVersions.findVersionInJSON(version, this.versionSet);
    }

    public String getCorrespondingJavaVersion(String version) {
        version = SupportedVersions.findVersionInJSON(version, this.versionSet);
        return SupportedVersions.getJavaVersionFromVersionJSON(version, this.versionsDic);
    }

    public static HashMap<String, Object> readVersionsJson() {
        BufferedReader br = new BufferedReader(new InputStreamReader(SupportedVersions.class.getClassLoader().getResourceAsStream("supportedVersions.json")));
        Gson g = new Gson();
        Type mapType = new TypeToken<HashMap<String, Object>>(){}.getType();
        HashMap supportedVersions = (HashMap)g.fromJson((Reader)br, mapType);
        return supportedVersions;
    }

    public static LinkedTreeMap<String, Object> getSupportedVersionsForEngine(String engine) {
        if (ALL_VERSIONS == null) {
            ALL_VERSIONS = SupportedVersions.readVersionsJson();
        }
        engine = AvailableEngines.getSupportedFrameworkTag(engine);
        LinkedTreeMap engineVersions = (LinkedTreeMap)ALL_VERSIONS.get(engine);
        return engineVersions;
    }

    private static String findVersionInJSON(String version, Set<String> versionSet) {
        List auxVersionList;
        if (versionSet.contains(version)) {
            return version;
        }
        if (version.indexOf(".") != -1 && version.indexOf(".") != version.lastIndexOf(".")) {
            int secondDotPos = version.substring(version.indexOf(".") + 1).indexOf(".");
            version = version.substring(0, version.indexOf(".") + 1 + secondDotPos);
        }
        if ((auxVersionList = versionSet.stream().map(s -> {
            if (s.indexOf(".") == -1 || s.indexOf(".") == s.lastIndexOf(".")) {
                return s;
            }
            return s.substring(0, s.lastIndexOf("."));
        }).collect(Collectors.toList())).contains(version)) {
            return (String)versionSet.toArray()[auxVersionList.indexOf(version)];
        }
        if (version.indexOf(".") != -1) {
            version = version.substring(0, version.indexOf("."));
        }
        if ((auxVersionList = auxVersionList.stream().map(s -> {
            if (s.indexOf(".") == -1) {
                return s;
            }
            return s.substring(0, s.indexOf("."));
        }).collect(Collectors.toList())).contains(version)) {
            return (String)versionSet.toArray()[auxVersionList.indexOf(version)];
        }
        return null;
    }

    private static String getJavaVersionFromVersionJSON(String version, LinkedTreeMap<String, Object> allVersions) {
        if (version == null) {
            return null;
        }
        LinkedTreeMap versionJSON = (LinkedTreeMap)allVersions.get((Object)version);
        return (String)versionJSON.get((Object)javaVersionsKey);
    }

    public Set<String> getSupportedVersions() {
        return this.versionSet;
    }

    public static String getJavaVersionForPythonVersion(String engine, String version) {
        SupportedVersions sv = new SupportedVersions(engine);
        return sv.getCorrespondingJavaVersion(version);
    }

    public static String getClosestSupportedPythonVersion(String engine, String version) {
        SupportedVersions sv = new SupportedVersions(engine);
        return sv.getClosestSupportedPythonVersion(version);
    }

    static {
        javaVersionsKey = "javaVersion";
    }
}

