/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.engine;

import io.bioimage.modelrunner.apposed.appose.MambaInstallException;
import io.bioimage.modelrunner.bioimageio.description.weights.WeightFormat;
import io.bioimage.modelrunner.engine.EngineInfo;
import io.bioimage.modelrunner.tensor.Tensor;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.apache.commons.compress.archivers.ArchiveException;

public abstract class AbstractEngine
implements AutoCloseable {
    private static String JAX_KEY = "jax";
    private static String PYTORCH_STATE_DIC_KEY = "pytorch_state_dict";
    private static final String[] SUPPORTED_ENGINE_NAMES = new String[]{EngineInfo.getTensorflowKey(), EngineInfo.getBioimageioTfKey(), EngineInfo.getBioimageioPytorchKey(), EngineInfo.getPytorchKey(), EngineInfo.getOnnxKey(), EngineInfo.getKerasKey(), EngineInfo.getBioimageioKerasKey(), PYTORCH_STATE_DIC_KEY, JAX_KEY};

    public static AbstractEngine initialize(WeightFormat ww) {
        return null;
    }

    public static AbstractEngine initialize(String name, String version, boolean gpu, boolean isPython) {
        return null;
    }

    public static AbstractEngine initializeSimilar(WeightFormat ww) {
        return null;
    }

    public static AbstractEngine initializeSimilar(String name, String version, Boolean gpu, Boolean isPython) {
        return null;
    }

    public static boolean isSupported(String name) {
        return Arrays.stream(SUPPORTED_ENGINE_NAMES).filter(kk -> name.equals(kk)).findFirst().orElse(null) != null;
    }

    public static String[] getSupportedEngineKeys() {
        return SUPPORTED_ENGINE_NAMES;
    }

    public abstract String getName();

    public abstract boolean isPython();

    public abstract String getVersion();

    public abstract boolean supportsGPU();

    public abstract String getDir();

    public abstract boolean isInstalled();

    public abstract void install() throws IOException, InterruptedException, MambaInstallException, ArchiveException, URISyntaxException;

    public abstract void loadModel(String var1, String var2) throws IOException, InterruptedException;

    public abstract void unloadModel() throws IOException, InterruptedException;

    public abstract boolean isModelLoaded(String var1, String var2) throws IOException, InterruptedException;

    public abstract <T extends RealType<T> & NativeType<T>> void runModel(List<Tensor<T>> var1, List<Tensor<T>> var2) throws IOException, InterruptedException;
}

