/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.intensity;

import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import plugins.kernel.roi.descriptor.intensity.ROIIntensityDescriptorsPlugin;

public class ROIMaxIntensityDescriptor
extends ROIDescriptor {
    public static final String ID = "Max intensity";

    public ROIMaxIntensityDescriptor() {
        super(ID, "Max Intensity", Double.class);
    }

    @Override
    public String getDescription() {
        return "Maximum intensity";
    }

    @Override
    public boolean separateChannel() {
        return true;
    }

    @Override
    public boolean needRecompute(SequenceEvent change) {
        return change.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA;
    }

    @Override
    public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        return ROIMaxIntensityDescriptor.computeMaxIntensity(roi, sequence);
    }

    public static double computeMaxIntensity(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        return ROIIntensityDescriptorsPlugin.computeIntensityDescriptors((ROI)roi, (Sequence)sequence, (boolean)false).max;
    }
}

