/*
 * Decompiled with CFR 0.152.
 */
package icy.resource.icon;

import icy.image.ImageUtil;
import icy.resource.ResourceUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public class BasicResizableIcon
implements ResizableIcon {
    protected static final int DEFAULT_ICONSIZE = 48;
    protected ImageIcon icon;
    protected final Image image;
    protected Dimension dim;

    public BasicResizableIcon(Image image) {
        this.image = image;
        if (image != null) {
            ImageUtil.waitImageReady(image);
            this.dim = new Dimension(image.getWidth(null), image.getHeight(null));
        } else {
            this.dim = new Dimension();
        }
        this.buildIcon(this.dim.width);
    }

    public BasicResizableIcon(ImageIcon srcIcon) {
        this(srcIcon.getImage());
    }

    public BasicResizableIcon() {
        this((Image)null);
    }

    protected void buildIcon(int size) {
        this.icon = this.image != null ? ResourceUtil.getImageIcon(this.image, size) : null;
    }

    public void setDimension(Dimension dim) {
        int size;
        this.dim = dim;
        if (this.icon != null && (size = (int)dim.getWidth()) != this.icon.getIconWidth()) {
            this.buildIcon(size);
        }
    }

    public int getIconHeight() {
        if (this.icon != null) {
            return this.icon.getIconHeight();
        }
        return this.dim.height;
    }

    public int getIconWidth() {
        if (this.icon != null) {
            return this.icon.getIconWidth();
        }
        return this.dim.width;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.icon != null) {
            this.icon.paintIcon(c, g, x, y);
        } else {
            g.drawLine(x, y, x + this.dim.width, y + this.dim.height);
            g.drawLine(x + this.dim.width, y, x, y + this.dim.height);
        }
    }
}

