/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio.description.weights;

import io.bioimage.modelrunner.bioimageio.description.weights.ModelArchitecture;
import io.bioimage.modelrunner.bioimageio.description.weights.ModelDependencies;
import io.bioimage.modelrunner.bioimageio.description.weights.ModelWeight;
import io.bioimage.modelrunner.bioimageio.description.weights.WeightFormat;
import io.bioimage.modelrunner.utils.CommonUtils;
import io.bioimage.modelrunner.versionmanagement.SupportedVersions;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.Set;

public class TorchscriptWeights
implements WeightFormat {
    private String compatiblePythonVersion;
    private String weightsFormat = ModelWeight.getTorchscriptID();
    private String trainingVersion;
    private String sha256;
    private String source;
    private String parent;
    boolean gpu = false;
    private String compatibleVersion;
    private ModelArchitecture architecture;
    private ModelDependencies dependencies;

    public TorchscriptWeights(Map<String, Object> weights) {
        Set<String> keys = weights.keySet();
        for (String k : keys) {
            Object fieldElement = weights.get(k);
            switch (k) {
                case "pytorch_version": {
                    this.setTrainingVersion(fieldElement);
                    break;
                }
                case "source": {
                    this.setSource(fieldElement);
                    break;
                }
                case "parent": {
                    this.setParent(fieldElement);
                    break;
                }
                case "sha256": {
                    this.setSha256(fieldElement);
                    break;
                }
                case "architecture": {
                    this.setArchitecture(fieldElement);
                    break;
                }
                case "dependencies": {
                    this.setDependencies(fieldElement);
                }
            }
        }
        if (this.trainingVersion == null) {
            this.trainingVersion = "1.13.1";
        }
        this.setCompatibleVersion();
    }

    @Override
    public String getFramework() {
        return this.weightsFormat;
    }

    @Override
    public String getTrainingVersion() {
        return this.trainingVersion;
    }

    public void setTrainingVersion(Object v) {
        if (v instanceof String && !((String)v).contains("+") && !((String)v).contains("cu") && !((String)v).contains("cuda")) {
            this.trainingVersion = (String)v;
        } else if (v instanceof String && ((String)v).contains("+")) {
            this.trainingVersion = ((String)v).substring(0, ((String)v).indexOf("+")).trim();
        } else if (v instanceof String && ((String)v).contains("cuda")) {
            this.trainingVersion = ((String)v).substring(0, ((String)v).indexOf("cuda")).trim();
        } else if (v instanceof String && ((String)v).contains("cu")) {
            this.trainingVersion = ((String)v).substring(0, ((String)v).indexOf("cu")).trim();
        } else if (v instanceof Double) {
            this.trainingVersion = "" + v;
        } else if (v instanceof Float) {
            this.trainingVersion = "" + v;
        } else if (v instanceof Long) {
            this.trainingVersion = "" + v;
        } else if (v instanceof Integer) {
            this.trainingVersion = "" + v;
        }
    }

    @Override
    public String getSha256() {
        return this.sha256;
    }

    public void setSha256(Object s) {
        if (s instanceof String) {
            this.sha256 = (String)s;
        }
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public void setSource(Object s) {
        if (s instanceof String) {
            this.source = (String)s;
        }
    }

    @Override
    public String getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        if (parent instanceof String) {
            this.parent = (String)parent;
        }
    }

    @Override
    public ModelArchitecture getArchitecture() {
        return this.architecture;
    }

    private void setArchitecture(Object architecture) {
        if (architecture instanceof Map) {
            this.architecture = new ModelArchitecture((Map)architecture);
        }
    }

    @Override
    public ModelDependencies getEnvDependencies() {
        return this.dependencies;
    }

    private void setDependencies(Object dependencies) {
        if (dependencies instanceof Map) {
            this.dependencies = new ModelDependencies((Map)dependencies);
        }
    }

    @Override
    public String getSourceFileName() {
        if (this.source == null) {
            return this.source;
        }
        try {
            return CommonUtils.getFileNameFromURLString(this.source);
        }
        catch (MalformedURLException e) {
            if (this.source.startsWith("https://zenodo.org/") && this.source.endsWith("/content")) {
                return new File(this.source.substring(0, this.source.length() - "/content".length())).getName();
            }
            return new File(this.source).getName();
        }
    }

    @Override
    public void supportGPU(boolean support) {
        this.gpu = support;
    }

    @Override
    public boolean isSupportGPU() {
        return this.gpu;
    }

    @Override
    public String getJavaTrainingVersion() {
        return this.compatibleVersion;
    }

    private void setCompatibleVersion() {
        if (this.trainingVersion == null) {
            this.compatibleVersion = null;
        }
        this.compatibleVersion = SupportedVersions.getJavaVersionForPythonVersion("pytorch", this.trainingVersion);
    }

    @Override
    public String getClosestSupportedPythonVersion() {
        if (this.trainingVersion == null) {
            return null;
        }
        if (this.compatiblePythonVersion == null) {
            this.compatiblePythonVersion = SupportedVersions.getClosestSupportedPythonVersion("pytorch", this.trainingVersion);
        }
        return this.compatiblePythonVersion;
    }
}

