/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.deepicy.gui.consumers;

import icy.sequence.Sequence;
import io.bioimage.modelrunner.gui.custom.CellposeGUI;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.bioimageanalysis.icy.deepicy.gui.consumers.SmallPluginAdapter;

public class CellposeAdapter
extends SmallPluginAdapter {
    private JComboBox<String> cytoCbox;
    private JComboBox<String> nucleiCbox;

    @Override
    public void setComponents(List<JComponent> components) {
        this.componentsGui = components;
        if (this.varNames != null && this.varNames.indexOf("Cytoplasm Color:") != -1) {
            this.cytoCbox = (JComboBox)this.componentsGui.get(this.varNames.indexOf("Cytoplasm Color:"));
        }
        if (this.varNames != null && this.varNames.indexOf("Nuclei Color:") != -1) {
            this.nucleiCbox = (JComboBox)this.componentsGui.get(this.varNames.indexOf("Nuclei Color:"));
        }
    }

    @Override
    public void setVarNames(List<String> componentNames) {
        this.varNames = componentNames;
        if (this.componentsGui != null && this.varNames.indexOf("Cytoplasm Color:") != -1) {
            this.cytoCbox = (JComboBox)this.componentsGui.get(this.varNames.indexOf("Cytoplasm Color:"));
        }
        if (this.componentsGui != null && this.varNames.indexOf("Nuclei Color:") != -1) {
            this.nucleiCbox = (JComboBox)this.componentsGui.get(this.varNames.indexOf("Nuclei Color:"));
        }
    }

    @Override
    protected void changeOnFocusGained(Sequence imp) {
        this.updateComboBox(imp, this.cytoCbox);
        this.updateComboBox(imp, this.nucleiCbox);
    }

    private void updateComboBox(Sequence imp, JComboBox<String> cbox) {
        if (cbox == null) {
            return;
        }
        if (imp != null && imp.getDimension5D().sizeC == 3 && cbox.getItemCount() != 2) {
            cbox.setModel(new DefaultComboBoxModel<String>(CellposeGUI.RGB_LIST));
        } else if (imp != null && imp.getDimension5D().sizeC == 1 && cbox.getItemCount() != 1) {
            cbox.setModel(new DefaultComboBoxModel<String>(CellposeGUI.GRAYSCALE_LIST));
        } else if (imp == null || imp.getDimension5D().sizeC != 1 && imp.getDimension5D().sizeC == 3) {
            cbox.setModel(new DefaultComboBoxModel<String>(CellposeGUI.RGB_LIST));
        }
    }
}

