/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui;

import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.gui.DefaultIcon;
import io.bioimage.modelrunner.gui.Gui;
import io.bioimage.modelrunner.gui.ModelSelectionPanelGui;
import io.bioimage.modelrunner.gui.adapter.GuiAdapter;
import java.awt.Color;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;

public class ModelSelectionPanel
extends ModelSelectionPanelGui {
    private static final long serialVersionUID = 6264134076603842497L;
    private List<String> modelNames;
    private List<String> modelNicknames;
    private List<URL> modelImagePaths;
    private List<ModelDescriptor> models;

    protected ModelSelectionPanel(GuiAdapter adapter) {
        super(adapter);
        this.setBackground(new Color(236, 240, 241));
    }

    private void setCardsData() {
        this.modelNames = this.models.stream().map(mm -> mm == null ? "no models found" : mm.getName()).collect(Collectors.toList());
        this.modelNicknames = this.models.stream().map(mm -> mm == null ? "no models found" : mm.getNickname()).collect(Collectors.toList());
        this.modelImagePaths = this.models.stream().map(mm -> {
            if (mm == null || mm.getCovers() == null || mm.getCovers().size() == 0) {
                return this.getClass().getClassLoader().getResource(DefaultIcon.DIJ_ICON_PATH);
            }
            File imFile = new File(mm.getCovers().get(0));
            if (!imFile.exists() && mm.getModelPath() != null) {
                imFile = new File(mm.getModelPath() + File.separator + mm.getCovers().get(0));
            } else if (mm.getModelPath() == null) {
                try {
                    return new URL(mm.getModelURL() + mm.getCovers().get(0));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (!imFile.exists()) {
                return this.getClass().getClassLoader().getResource(DefaultIcon.DIJ_ICON_PATH);
            }
            try {
                return imFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                return this.getClass().getClassLoader().getResource(DefaultIcon.DIJ_ICON_PATH);
            }
        }).collect(Collectors.toList());
    }

    protected void setModels(List<ModelDescriptor> models) {
        this.models = models;
        this.setCardsData();
        if (SwingUtilities.isEventDispatchThread()) {
            this.redrawModelCards(0);
        } else {
            SwingUtilities.invokeLater(() -> this.redrawModelCards(0));
        }
    }

    protected void setModelAt(ModelDescriptor model, int pos) {
        Objects.requireNonNull(model);
        if (pos > this.models.size()) {
            throw new IllegalArgumentException("Wanted position of the model (" + pos + ") out of range (" + this.models.size() + ").");
        }
        this.models.set(pos, model);
        this.modelNames.set(pos, model.getName() == null ? this.defaultString : model.getName());
        this.modelNicknames.set(pos, model.getNickname() == null ? this.defaultString : model.getNickname());
        if (model.getCovers() == null || model.getCovers().size() == 0) {
            this.modelImagePaths.set(pos, this.getClass().getClassLoader().getResource(DefaultIcon.DIJ_ICON_PATH));
            return;
        }
        File imFile = new File(model.getCovers().get(0));
        if (!imFile.exists() && model.getModelPath() != null) {
            imFile = new File(model.getModelPath() + File.separator + model.getCovers().get(0));
        } else if (model.getModelPath() == null) {
            try {
                this.modelImagePaths.set(pos, new URL(model.getModelURL() + model.getCovers().get(0)));
                return;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (!imFile.exists()) {
            this.modelImagePaths.set(pos, this.getClass().getClassLoader().getResource(DefaultIcon.DIJ_ICON_PATH));
            return;
        }
        try {
            this.modelImagePaths.set(pos, imFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            this.modelImagePaths.set(pos, this.getClass().getClassLoader().getResource(DefaultIcon.DIJ_ICON_PATH));
        }
    }

    protected void redrawModelCards(int currentIndex) {
        boolean prevSupported = true;
        boolean mainSupported = true;
        boolean nextSupported = true;
        if (this.models.get(this.getWrappedIndex(currentIndex - 1)) != null) {
            boolean bl = prevSupported = !Gui.UNSUPPORTED_MODELS.contains(this.models.get(this.getWrappedIndex(currentIndex - 1)).getNickname()) && this.models.get(this.getWrappedIndex(currentIndex - 1)).getWeights().getAllSuportedWeightNames().size() != 0;
        }
        if (this.models.get(currentIndex) != null) {
            boolean bl = mainSupported = !Gui.UNSUPPORTED_MODELS.contains(this.models.get(currentIndex).getNickname()) && this.models.get(currentIndex).getWeights().getAllSuportedWeightNames().size() != 0;
        }
        if (this.models.get(this.getWrappedIndex(currentIndex + 1)) != null) {
            nextSupported = !Gui.UNSUPPORTED_MODELS.contains(this.models.get(this.getWrappedIndex(currentIndex + 1)).getNickname()) && this.models.get(this.getWrappedIndex(currentIndex + 1)).getWeights().getAllSuportedWeightNames().size() != 0;
        }
        this.prevModelPanel.updateCard(this.modelNames.get(this.getWrappedIndex(currentIndex - 1)), this.modelNicknames.get(this.getWrappedIndex(currentIndex - 1)), this.modelImagePaths.get(this.getWrappedIndex(currentIndex - 1)), prevSupported);
        this.selectedModelPanel.updateCard(this.modelNames.get(currentIndex), this.modelNicknames.get(currentIndex), this.modelImagePaths.get(currentIndex), mainSupported);
        this.nextModelPanel.updateCard(this.modelNames.get(this.getWrappedIndex(currentIndex + 1)), this.modelNicknames.get(this.getWrappedIndex(currentIndex + 1)), this.modelImagePaths.get(this.getWrappedIndex(currentIndex + 1)), nextSupported);
    }

    private int getWrappedIndex(int index) {
        int size = this.getModelNames().size();
        return size == 0 ? size : (index % size + size) % size;
    }

    public List<String> getModelNames() {
        return this.modelNames;
    }

    public List<String> getModelNicknames() {
        return this.modelNicknames;
    }

    public List<URL> getCoverPaths() {
        return this.modelImagePaths;
    }

    public List<ModelDescriptor> getModels() {
        return this.models;
    }
}

