/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.intensity;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginROIDescriptor;
import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.sequence.SequenceDataIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import plugins.kernel.roi.descriptor.intensity.ROIMaxIntensityDescriptor;
import plugins.kernel.roi.descriptor.intensity.ROIMeanIntensityDescriptor;
import plugins.kernel.roi.descriptor.intensity.ROIMinIntensityDescriptor;
import plugins.kernel.roi.descriptor.intensity.ROIStandardDeviationDescriptor;
import plugins.kernel.roi.descriptor.intensity.ROISumIntensityDescriptor;

public class ROIIntensityDescriptorsPlugin
extends Plugin
implements PluginROIDescriptor {
    public static final String ID_MIN_INTENSITY = "Min intensity";
    public static final String ID_MEAN_INTENSITY = "Mean intensity";
    public static final String ID_MAX_INTENSITY = "Max intensity";
    public static final String ID_SUM_INTENSITY = "Sum intensity";
    public static final String ID_STANDARD_DEVIATION = "Standard deviation";
    public static final ROIMinIntensityDescriptor minIntensityDescriptor = new ROIMinIntensityDescriptor();
    public static final ROIMeanIntensityDescriptor meanIntensityDescriptor = new ROIMeanIntensityDescriptor();
    public static final ROIMaxIntensityDescriptor maxIntensityDescriptor = new ROIMaxIntensityDescriptor();
    public static final ROISumIntensityDescriptor sumIntensityDescriptor = new ROISumIntensityDescriptor();
    public static final ROIStandardDeviationDescriptor standardDeviationDescriptor = new ROIStandardDeviationDescriptor();

    public static IntensityDescriptorInfos computeIntensityDescriptors(ROI roi, Sequence sequence, boolean allowMultiChannel) throws UnsupportedOperationException, InterruptedException {
        if (!allowMultiChannel && roi.getBounds5D().getSizeC() > 1.0) {
            throw new UnsupportedOperationException("Not allowed to cannot compute intensity descriptor on a multi channel ROI (sizeC > 1).");
        }
        IntensityDescriptorInfos result = new IntensityDescriptorInfos();
        long numPixels = 0L;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double sum = 0.0;
        double sum2 = 0.0;
        SequenceDataIterator it = new SequenceDataIterator(sequence, roi, true);
        while (!it.done()) {
            if ((numPixels & 0xFFFFL) == 0L && Thread.interrupted()) {
                throw new InterruptedException("ROI intensity descriptor computation interrupted.");
            }
            double value = it.get();
            if (min > value) {
                min = value;
            }
            if (max < value) {
                max = value;
            }
            sum += value;
            sum2 += value * value;
            ++numPixels;
            it.next();
        }
        if (numPixels > 0L) {
            result.min = min;
            result.max = max;
            result.sum = sum;
            double mean = sum / (double)numPixels;
            double x1 = sum2 / (double)numPixels;
            double x2 = mean * mean;
            result.mean = mean;
            result.deviation = Math.sqrt(x1 - x2);
        } else {
            result.min = 0.0;
            result.mean = 0.0;
            result.max = 0.0;
            result.sum = 0.0;
            result.deviation = 0.0;
        }
        return result;
    }

    @Override
    public List<ROIDescriptor> getDescriptors() {
        ArrayList<ROIDescriptor> result = new ArrayList<ROIDescriptor>();
        result.add(minIntensityDescriptor);
        result.add(meanIntensityDescriptor);
        result.add(maxIntensityDescriptor);
        result.add(sumIntensityDescriptor);
        result.add(standardDeviationDescriptor);
        return result;
    }

    @Override
    public Map<ROIDescriptor, Object> compute(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        HashMap<ROIDescriptor, Object> result = new HashMap<ROIDescriptor, Object>();
        try {
            IntensityDescriptorInfos intensityInfos = ROIIntensityDescriptorsPlugin.computeIntensityDescriptors(roi, sequence, false);
            result.put(minIntensityDescriptor, intensityInfos.min);
            result.put(meanIntensityDescriptor, intensityInfos.mean);
            result.put(maxIntensityDescriptor, intensityInfos.max);
            result.put(sumIntensityDescriptor, intensityInfos.sum);
            result.put(standardDeviationDescriptor, intensityInfos.deviation);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ": cannot compute descriptors for '" + roi.getName() + "'", e);
        }
        return result;
    }

    public static class IntensityDescriptorInfos {
        public double min;
        public double mean;
        public double max;
        public double sum;
        public double deviation;
    }
}

