/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio.description;

import io.bioimage.modelrunner.bioimageio.BioimageioRepo;
import io.bioimage.modelrunner.bioimageio.description.Axis;
import io.bioimage.modelrunner.bioimageio.description.AxisV05;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.TensorSpec;
import io.bioimage.modelrunner.bioimageio.description.TensorSpecV05;
import io.bioimage.modelrunner.bioimageio.description.weights.ModelWeight;
import io.bioimage.modelrunner.model.python.DLModelPytorchProtected;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ModelDescriptorV05
extends ModelDescriptor {
    protected ModelDescriptorV05(Map<String, Object> yamlElements) {
        this.yamlElements = yamlElements;
        this.buildModelDescription();
        if (this.modelID == null) {
            this.modelID = this.findID();
        }
        if (this.modelID.length() - this.modelID.replace("/", "").length() >= 2 && this.modelID.substring(this.modelID.indexOf("/") + 1).indexOf("/") - this.modelID.indexOf("/") > 2) {
            this.modelID = this.modelID.substring(0, this.modelID.indexOf("/") + this.modelID.substring(this.modelID.indexOf("/") + 1).indexOf("/") + 1);
        }
    }

    @Override
    public String getNickname() {
        return this.modelID;
    }

    @Override
    public boolean areRequirementsInstalled() {
        if (this.weights.getAllSuportedWeightNames().size() > 1 || !this.weights.getAllSuportedWeightNames().get(0).equals(ModelWeight.getPytorchID())) {
            return true;
        }
        return DLModelPytorchProtected.isInstalled();
    }

    @Override
    protected List<String> buildAttachments() {
        ArrayList<String> strs = new ArrayList<String>();
        Object att = this.yamlElements.get("attachments");
        if (att == null) {
            return new ArrayList<String>();
        }
        if (!(att instanceof List)) {
            System.err.println("Cannot parse the attachments of: " + this.name);
            return new ArrayList<String>();
        }
        for (Object ll : (List)att) {
            if (ll instanceof String) {
                strs.add((String)ll);
                continue;
            }
            if (!(ll instanceof Map) || !((Map)ll).keySet().contains("source")) continue;
            strs.add((String)((Map)ll).get("source"));
        }
        return strs;
    }

    @Override
    protected List<TensorSpec> buildInputTensors() {
        Object object = this.yamlElements.get("inputs");
        if (!(object instanceof List)) {
            return null;
        }
        List list = (List)object;
        ArrayList<TensorSpec> tensors = new ArrayList<TensorSpec>(list.size());
        for (Object elem : list) {
            if (!(elem instanceof Map)) continue;
            tensors.add(new TensorSpecV05((Map)elem, true));
        }
        return tensors;
    }

    @Override
    protected List<TensorSpec> buildOutputTensors() {
        Object object = this.yamlElements.get("outputs");
        if (!(object instanceof List)) {
            return null;
        }
        List list = (List)object;
        ArrayList<TensorSpec> tensors = new ArrayList<TensorSpec>(list.size());
        for (Object elem : list) {
            if (!(elem instanceof Map)) continue;
            tensors.add(new TensorSpecV05((Map)elem, false));
        }
        return tensors;
    }

    @Override
    protected void calculateTotalInputHalo() {
        for (TensorSpec out : this.output_tensors) {
            for (Axis ax : out.getAxesInfo().getAxesList()) {
                int axHalo = ax.getHalo();
                if (axHalo == 0) continue;
                String ref = ax.getReferenceTensor();
                if (ref == null) {
                    this.input_tensors.stream().forEach(tt -> {
                        AxisV05 inAx = tt.getAxesInfo().getAxesList().stream().filter(xx -> xx.getAxis().equals(ax.getAxis())).findFirst().orElse(null);
                        if (inAx == null || inAx.getHalo() > axHalo) {
                            return;
                        }
                        inAx.halo = axHalo;
                    });
                    return;
                }
                double axScale = ax.getScale();
                double axOffset = ax.getOffset();
                double nHalo = ((double)axHalo + axOffset) / axScale;
                AxisV05 inAx = (AxisV05)this.findInputTensor(ref).getAxesInfo().getAxis(ax.getReferenceAxis());
                if (inAx == null || (double)inAx.getHalo() > nHalo) {
                    return;
                }
                inAx.halo = (int)nHalo;
            }
        }
    }

    @Override
    protected String findID() {
        Map bioimageMap;
        Map configMap;
        if (this.yamlElements.get("config") != null && this.yamlElements.get("config") instanceof Map && (configMap = (Map)this.yamlElements.get("config")).get("bioimageio") != null && configMap.get("bioimageio") instanceof Map && (bioimageMap = (Map)configMap.get("bioimageio")).get("nickname") != null) {
            return (String)bioimageMap.get("nickname");
        }
        return (String)this.yamlElements.get("id");
    }

    @Override
    protected void addBioEngine() {
        if (this.getName().equals("cellpose-python")) {
            this.supportBioengine = true;
            return;
        }
        if (this.getName().equals("bestfitting-inceptionv3-single-cell")) {
            return;
        }
        if (this.getName().equals("stardist")) {
            this.supportBioengine = true;
            return;
        }
        if (this.modelID == null) {
            this.supportBioengine = false;
            return;
        }
        this.supportBioengine = BioimageioRepo.isModelOnTheBioengineById(this.modelID);
    }

    @Override
    public String getModelFamily() {
        return "bioimage.io";
    }

    protected void setInputTestNpyName(int n, String newName) {
        ((TensorSpecV05)this.input_tensors.get((int)n)).testTensorName = newName;
    }

    protected void setOutputTestNpyName(int n, String newName) {
        ((TensorSpecV05)this.output_tensors.get((int)n)).testTensorName = newName;
    }
}

