/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio.description;

import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.TransformSpec;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;

public class SpecialModels {
    protected static final String STARDIST_KEY = "stardist";
    protected static final String CELLPOSE_KEY = "stardist";

    public static void checkSpecialModels(ModelDescriptor descriptor) {
        try {
            if (descriptor.getConfig().getSpecMap().containsKey("stardist")) {
                SpecialModels.completeStardist(descriptor);
            } else if (descriptor.getConfig().getSpecMap().containsKey("stardist")) {
                SpecialModels.completeCellpose(descriptor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void completeStardist(ModelDescriptor descriptor) {
        boolean is3D = descriptor.getInputTensors().get(0).getAxesOrder().length() == 5;
        Map stardistMap = (Map)descriptor.getConfig().getSpecMap().get("stardist");
        Map stardistThres = (Map)stardistMap.get("thresholds");
        HashMap<String, Object> stardistPostProcessing = new HashMap<String, Object>();
        HashMap<String, Object> outerKwargs = new HashMap<String, Object>();
        stardistPostProcessing.put(TransformSpec.getTransformationNameKey(), "python");
        outerKwargs.put("env_yaml", descriptor.getModelPath() + File.separator + "stardist.yaml");
        String fname = "stardist_postprocessing.py";
        if (is3D) {
            fname = "stardist_postprocessing_3D.py";
        }
        outerKwargs.put("script", descriptor.getModelPath() + File.separator + fname);
        outerKwargs.put("n_outputs", 1);
        outerKwargs.put("kwargs", "stardist_postprocessing");
        HashMap kwargs = new HashMap();
        kwargs.put("nms_thresh", stardistThres.get("nms"));
        kwargs.put("prob_thresh", stardistThres.get("prob"));
        outerKwargs.put("kwargs", kwargs);
        stardistPostProcessing.put("kwargs", outerKwargs);
        if (SpecialModels.extractStardist(descriptor) && descriptor.getOutputTensors().get(0).getPostprocessing().size() == 0) {
            descriptor.getOutputTensors().get(0).getPostprocessing().add(TransformSpec.build(stardistPostProcessing));
        } else if (SpecialModels.extractStardist(descriptor)) {
            TransformSpec post = descriptor.getOutputTensors().get(0).getPostprocessing().get(0);
            if (!new File((String)post.getKwargs().get("env_yaml")).isFile()) {
                post.getKwargs().put("env_yaml", descriptor.getModelPath() + File.separator + (String)post.getKwargs().get("env_yaml"));
            }
            if (!new File((String)post.getKwargs().get("script")).isFile()) {
                post.getKwargs().put("script", descriptor.getModelPath() + File.separator + (String)post.getKwargs().get("script"));
            }
        }
    }

    private static boolean extractStardist(ModelDescriptor descriptor) {
        boolean is3D;
        boolean bl = is3D = descriptor.getInputTensors().get(0).getAxesOrder().length() == 5;
        if (descriptor.getModelPath() == null) {
            return true;
        }
        File envFile = new File(descriptor.getModelPath() + File.separator + "stardist.yaml");
        String fname = "stardist_postprocessing.py";
        if (is3D) {
            fname = "stardist_postprocessing_3D.py";
        }
        File scriptFile = new File(descriptor.getModelPath() + File.separator + fname);
        if (!envFile.isFile()) {
            try (InputStream envStream = SpecialModels.class.getClassLoader().getResourceAsStream("op_environments/stardist.yaml");){
                Files.copy(envStream, envFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (!scriptFile.isFile()) {
            try (InputStream scriptStream = SpecialModels.class.getClassLoader().getResourceAsStream("ops/stardist_postprocessing/" + fname);){
                Files.copy(scriptStream, scriptFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static void completeCellpose(ModelDescriptor descriptor) {
    }
}

