/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui.custom;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ButtonsPanel
extends JPanel {
    private static final long serialVersionUID = 5381352117710530216L;
    protected JButton cancelButton;
    protected JButton installButton;
    protected JButton runButton;
    private static final double BUTTON_WRATIO = 0.3333333333333333;

    protected ButtonsPanel() {
        this.setLayout(null);
        this.cancelButton = new JButton("Cancel");
        this.installButton = new JButton("Install");
        this.runButton = new JButton("Run");
        this.add(this.cancelButton);
        this.add(this.installButton);
        this.add(this.runButton);
        this.organiseComponents();
    }

    private void organiseComponents() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int rawW = ButtonsPanel.this.getWidth();
                int rawH = ButtonsPanel.this.getHeight();
                int inset = 2;
                int w = (int)((double)(rawW - 2 * inset) * 0.3333333333333333);
                ButtonsPanel.this.cancelButton.setBounds(0, 0, w, rawH);
                ButtonsPanel.this.installButton.setBounds(w + inset, 0, w, rawH);
                ButtonsPanel.this.runButton.setBounds((w + inset) * 2, 0, w, rawH);
            }
        });
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("Buttons pannel");
                frame.setDefaultCloseOperation(3);
                frame.getContentPane().add(new ButtonsPanel());
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                frame.setSize(200, 200);
            }
        });
    }
}

