/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui.workers;

import io.bioimage.modelrunner.apposed.appose.MambaInstallException;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.model.python.DLModelPytorch;
import io.bioimage.modelrunner.model.special.cellpose.Cellpose;
import io.bioimage.modelrunner.model.special.stardist.StardistAbstract;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import javax.swing.SwingWorker;
import org.apache.commons.compress.archivers.ArchiveException;

public class InstallEnvWorker
extends SwingWorker<Void, Void> {
    private final String modelFamily;
    private Consumer<String> consumer;
    private final CountDownLatch latch;
    private final Runnable callback;
    private Thread workerThread;

    public InstallEnvWorker(ModelDescriptor descriptor, CountDownLatch latch, Runnable callback) {
        this.modelFamily = descriptor.getModelFamily();
        this.latch = latch;
        this.callback = callback;
    }

    public InstallEnvWorker(String modelFamily, CountDownLatch latch, Runnable callback) {
        this.modelFamily = modelFamily;
        this.latch = latch;
        this.callback = callback;
    }

    public void setConsumer(Consumer<String> consumer) {
        this.consumer = consumer;
    }

    public String getModelFamily() {
        return this.modelFamily;
    }

    public CountDownLatch getCountDownLatch() {
        return this.latch;
    }

    @Override
    protected Void doInBackground() {
        this.workerThread = Thread.currentThread();
        try {
            if (this.modelFamily.toLowerCase().equals("stardist")) {
                StardistAbstract.installRequirements(this.consumer);
            } else if (this.modelFamily.toLowerCase().equals("cellpose")) {
                Cellpose.installRequirements(this.consumer);
            } else if (this.modelFamily.toLowerCase().equals("bioimage.io")) {
                DLModelPytorch.installRequirements(this.consumer);
            }
        }
        catch (MambaInstallException | IOException | RuntimeException | URISyntaxException | ArchiveException e) {
            e.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected void done() {
        this.latch.countDown();
        if (this.callback != null) {
            this.callback.run();
        }
    }

    public void stopBackground() {
        if (this.workerThread != null && this.workerThread.isAlive()) {
            this.workerThread.interrupt();
        }
    }
}

