/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio.description;

import io.bioimage.modelrunner.bioimageio.description.Axes;
import io.bioimage.modelrunner.bioimageio.description.AxesV05;
import io.bioimage.modelrunner.bioimageio.description.TensorSpec;
import io.bioimage.modelrunner.bioimageio.description.TransformSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TensorSpecV05
implements TensorSpec {
    private final boolean input;
    private final Axes axes;
    private final String id;
    private final String description;
    private List<TransformSpec> preprocessing;
    private List<TransformSpec> postprocessing;
    protected String sampleTensorName;
    protected String testTensorName;
    protected String dataType = "float32";
    protected String unit = "arbitrary unit";

    protected TensorSpecV05(Map<String, Object> tensorSpecMap, boolean input) {
        Map sampleMap;
        this.id = tensorSpecMap.get("id") == null ? (String)tensorSpecMap.get("name") : (String)tensorSpecMap.get("id");
        if (tensorSpecMap.get("axes") == null || !(tensorSpecMap.get("axes") instanceof List)) {
            throw new IllegalArgumentException("Invalid tensor specifications for '" + this.id + "'. The axes are incorrectly specified. For more info, visit the Bioimage.io docs.");
        }
        this.axes = new AxesV05((List)tensorSpecMap.get("axes"));
        this.description = (String)tensorSpecMap.get("description");
        this.input = input;
        List preprocessingTensors = (List)tensorSpecMap.get("preprocessing");
        if (preprocessingTensors == null) {
            this.preprocessing = new ArrayList<TransformSpec>(0);
        } else {
            this.preprocessing = new ArrayList<TransformSpec>(preprocessingTensors.size());
            for (Object elem : preprocessingTensors) {
                if (((Map)elem).get("id") != null && ((Map)elem).get("id").equals("ensure_dtype")) continue;
                this.preprocessing.add(TransformSpec.build((Map)elem));
            }
        }
        List postprocessingTensors = (List)tensorSpecMap.get("postprocessing");
        if (postprocessingTensors == null) {
            this.postprocessing = new ArrayList<TransformSpec>(0);
        } else {
            this.postprocessing = new ArrayList<TransformSpec>(postprocessingTensors.size());
            for (Object elem : postprocessingTensors) {
                if (((Map)elem).get("id") != null && ((Map)elem).get("id").equals("ensure_dtype")) continue;
                this.postprocessing.add(TransformSpec.build((Map)elem));
            }
        }
        if (tensorSpecMap.get("sample_tensor") != null && tensorSpecMap.get("sample_tensor") instanceof Map && (sampleMap = (Map)tensorSpecMap.get("sample_tensor")).get("source") != null && sampleMap.get("source") instanceof String) {
            this.sampleTensorName = (String)sampleMap.get("source");
        }
        if (tensorSpecMap.get("test_tensor") != null && tensorSpecMap.get("test_tensor") instanceof Map && (sampleMap = (Map)tensorSpecMap.get("test_tensor")).get("source") != null && sampleMap.get("source") instanceof String) {
            this.testTensorName = (String)sampleMap.get("source");
        }
        if (tensorSpecMap.get("data") != null && tensorSpecMap.get("data") instanceof Map) {
            Map typeData = (Map)tensorSpecMap.get("data");
            if (typeData.get("type") != null && typeData.get("type") instanceof String) {
                this.dataType = (String)typeData.get("type");
            }
            if (typeData.get("unit") != null && typeData.get("unit") instanceof String) {
                this.unit = (String)typeData.get("unit");
            }
        }
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<TransformSpec> getPreprocessing() {
        if (!this.input) {
            return new ArrayList<TransformSpec>();
        }
        return this.preprocessing;
    }

    @Override
    public List<TransformSpec> getPostprocessing() {
        if (this.input) {
            return new ArrayList<TransformSpec>();
        }
        return this.postprocessing;
    }

    @Override
    public String getAxesOrder() {
        return this.axes.getAxesOrder();
    }

    @Override
    public String getSampleTensorName() {
        return this.sampleTensorName;
    }

    @Override
    public String getTestTensorName() {
        return this.testTensorName;
    }

    @Override
    public int[] getMinTileSizeArr() {
        return this.axes.getMinTileSizeArr();
    }

    @Override
    public int[] getTileStepArr() {
        return this.axes.getTileStepArr();
    }

    @Override
    public double[] getTileScaleArr() {
        return this.axes.getTileScaleArr();
    }

    @Override
    public Axes getAxesInfo() {
        return this.axes;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public String getPixelSizeUnit() {
        return this.unit;
    }

    @Override
    public int[] getHaloArr() {
        return this.axes.getHaloArr();
    }

    @Override
    public boolean isImage() {
        return this.axes.getAxesOrder().contains("x") && this.axes.getAxesOrder().contains("y");
    }
}

