/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio.description;

import io.bioimage.modelrunner.utils.CommonUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;

public class TestArtifact {
    private String string;
    private URL url;
    private Path path;
    private String filename;
    private static List<String> allowedExtensions = Arrays.asList(".npy");

    public static TestArtifact build(String sampleInputUrl) {
        TestArtifact sampleInput = new TestArtifact();
        if (sampleInputUrl == null) {
            return null;
        }
        sampleInput.string = sampleInputUrl;
        if (!sampleInput.isExtensionAllowed()) {
            return null;
        }
        sampleInput.createSampleInputURL();
        sampleInput.createSampleInputPath();
        sampleInput.createName();
        return sampleInput;
    }

    private void createName() {
        try {
            this.filename = CommonUtils.getFileNameFromURLString(this.string);
        }
        catch (MalformedURLException e) {
            this.filename = new File(this.string).getName();
        }
    }

    public boolean isExtensionAllowed() {
        if (this.getFileExtension() == null) {
            return false;
        }
        return allowedExtensions.contains(this.getFileExtension().toLowerCase());
    }

    public String getFileExtension() {
        if (this.string == null) {
            return null;
        }
        if (this.string.lastIndexOf(".") == -1) {
            return null;
        }
        if (this.string.startsWith("https://zenodo.org/") && this.string.endsWith("/content")) {
            return this.string.substring(this.string.lastIndexOf("."), this.string.length() - "/content".length());
        }
        return this.string.substring(this.string.lastIndexOf("."));
    }

    private void createSampleInputURL() {
        try {
            this.url = new URL(this.string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void createSampleInputPath() {
        try {
            this.path = Paths.get(this.string, new String[0]);
            if (!this.path.toFile().exists()) {
                this.path = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addLocalModelPath(Path p) {
        if (!p.toFile().exists()) {
            return;
        }
        Path nPath = p.resolve(this.filename);
        if (nPath.toFile().exists()) {
            this.path = nPath;
        }
    }

    public String getString() {
        return this.string;
    }

    public URL getUrl() {
        return this.url;
    }

    public Path getLocalPath() {
        return this.path;
    }

    public String toString() {
        String str = "TestNpy {";
        str = str + " string=" + this.string;
        if (this.url != null) {
            str = str + " url=" + this.url.toString();
        }
        if (this.path != null) {
            str = str + " path=" + this.path.toString();
        }
        str = str + " }";
        return str;
    }

    public static List<String> getAllowedExtensions() {
        return allowedExtensions;
    }

    public String getName() {
        return this.filename;
    }
}

