/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.tensor.shm;

import com.sun.jna.Pointer;
import io.bioimage.modelrunner.numpy.DecodeNumpy;
import io.bioimage.modelrunner.system.PlatformDetection;
import io.bioimage.modelrunner.tensor.shm.SharedMemoryArrayLinux;
import io.bioimage.modelrunner.tensor.shm.SharedMemoryArrayMacOS;
import io.bioimage.modelrunner.tensor.shm.SharedMemoryArrayWin;
import io.bioimage.modelrunner.utils.CommonUtils;
import java.io.Closeable;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.FileAlreadyExistsException;
import java.util.UUID;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;

public interface SharedMemoryArray
extends Closeable {
    public static final int O_RDONLY = 0;
    public static final int O_RDWR = 2;
    public static final int O_CREAT = 64;
    public static final int PROT_READ = 1;
    public static final int PROT_WRITE = 2;
    public static final int MAP_SHARED = 1;
    public static final String[] SPECIAL_CHARS_LIST = new String[]{"/", "\\", "#", "\u00b7", "!", "\u00a1", "\u00bf", "?", "@", "|", "$", ">", "<", ";"};

    public static <T extends RealType<T> & NativeType<T>> SharedMemoryArray readOrCreate(String name, long[] shape, T datatype) throws FileAlreadyExistsException {
        String strDType = CommonUtils.getDataType(datatype);
        int size = DecodeNumpy.DATA_TYPES_MAP.get(strDType);
        for (long i : shape) {
            size = (int)((long)size * i);
        }
        if (PlatformDetection.isWindows()) {
            return SharedMemoryArrayWin.readOrCreate(name, size, shape, strDType, null, false);
        }
        if (PlatformDetection.isLinux()) {
            return SharedMemoryArrayLinux.readOrCreate(name, size, shape, strDType, null, false);
        }
        return SharedMemoryArrayMacOS.readOrCreate(name, size, shape, strDType, null, false);
    }

    public static <T extends RealType<T> & NativeType<T>> SharedMemoryArray readOrCreate(String name, long[] shape, T datatype, boolean isFortran, boolean isNpy) throws FileAlreadyExistsException {
        String strDType = CommonUtils.getDataType(datatype);
        int size = DecodeNumpy.DATA_TYPES_MAP.get(strDType);
        for (long i : shape) {
            size = (int)((long)size * i);
        }
        if (isNpy) {
            size = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(shape, datatype, isFortran);
        }
        if (PlatformDetection.isWindows()) {
            return SharedMemoryArrayWin.readOrCreate(name, size, shape, strDType, isNpy, isFortran);
        }
        if (PlatformDetection.isLinux()) {
            return SharedMemoryArrayLinux.readOrCreate(name, size, shape, strDType, isNpy, isFortran);
        }
        return SharedMemoryArrayMacOS.readOrCreate(name, size, shape, strDType, isNpy, isFortran);
    }

    public static SharedMemoryArray readOrCreate(String name, int size) throws FileAlreadyExistsException {
        if (PlatformDetection.isWindows()) {
            return SharedMemoryArrayWin.readOrCreate(name, size);
        }
        if (PlatformDetection.isLinux()) {
            return SharedMemoryArrayLinux.readOrCreate(name, size);
        }
        return SharedMemoryArrayMacOS.readOrCreate(name, size);
    }

    public static <T extends RealType<T> & NativeType<T>> SharedMemoryArray create(long[] shape, T datatype) {
        String strDType = CommonUtils.getDataType(datatype);
        int size = DecodeNumpy.DATA_TYPES_MAP.get(strDType);
        for (long i : shape) {
            size = (int)((long)size * i);
        }
        if (PlatformDetection.isWindows()) {
            return SharedMemoryArrayWin.create(size, shape, strDType, true, false);
        }
        if (PlatformDetection.isLinux()) {
            return SharedMemoryArrayLinux.create(size, shape, strDType, true, false);
        }
        return SharedMemoryArrayMacOS.create(size, shape, strDType, true, false);
    }

    public static <T extends RealType<T> & NativeType<T>> SharedMemoryArray create(long[] shape, T datatype, boolean isFortran, boolean isNpy) {
        String strDType = CommonUtils.getDataType(datatype);
        int size = DecodeNumpy.DATA_TYPES_MAP.get(strDType);
        for (long i : shape) {
            size = (int)((long)size * i);
        }
        if (isNpy) {
            size = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(shape, datatype, isFortran);
        }
        if (PlatformDetection.isWindows()) {
            return SharedMemoryArrayWin.create(size, shape, strDType, isNpy, isFortran);
        }
        if (PlatformDetection.isLinux()) {
            return SharedMemoryArrayLinux.create(size, shape, strDType, isNpy, isFortran);
        }
        return SharedMemoryArrayMacOS.create(size, shape, strDType, isNpy, isFortran);
    }

    public static SharedMemoryArray create(int size) {
        if (PlatformDetection.isWindows()) {
            return SharedMemoryArrayWin.create(size);
        }
        if (PlatformDetection.isLinux()) {
            return SharedMemoryArrayLinux.create(size);
        }
        return SharedMemoryArrayMacOS.create(size);
    }

    public static SharedMemoryArray read(String name) {
        if (PlatformDetection.isWindows()) {
            return SharedMemoryArrayWin.read(name);
        }
        if (PlatformDetection.isLinux()) {
            return SharedMemoryArrayLinux.read(name);
        }
        return SharedMemoryArrayMacOS.read(name);
    }

    public static long getSize(String name) {
        if (PlatformDetection.isWindows()) {
            return SharedMemoryArrayWin.getSHMSize(name);
        }
        if (PlatformDetection.isLinux()) {
            return SharedMemoryArrayLinux.getSHMSize(name);
        }
        return SharedMemoryArrayMacOS.getSHMSize(name);
    }

    public static <T extends RealType<T> & NativeType<T>> SharedMemoryArray createSHMAFromRAI(String name, RandomAccessibleInterval<T> rai) throws FileAlreadyExistsException {
        return SharedMemoryArray.createSHMAFromRAI(name, rai, false, true);
    }

    public static <T extends RealType<T> & NativeType<T>> SharedMemoryArray createSHMAFromRAI(RandomAccessibleInterval<T> rai) {
        return SharedMemoryArray.createSHMAFromRAI(rai, false, true);
    }

    public static <T extends RealType<T> & NativeType<T>> SharedMemoryArray createSHMAFromRAI(RandomAccessibleInterval<T> rai, boolean isFortranOrder, boolean isNumpy) {
        try {
            return SharedMemoryArray.createSHMAFromRAI(SharedMemoryArray.createShmName(), rai, isFortranOrder, isNumpy);
        }
        catch (FileAlreadyExistsException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public static <T extends RealType<T> & NativeType<T>> SharedMemoryArray createSHMAFromRAI(String name, RandomAccessibleInterval<T> rai, boolean isFortranOrder, boolean isNumpy) throws FileAlreadyExistsException {
        if (PlatformDetection.isWindows()) {
            return SharedMemoryArrayWin.createSHMAFromRAI(name, rai, isFortranOrder, isNumpy);
        }
        if (PlatformDetection.isLinux()) {
            return SharedMemoryArrayLinux.createSHMAFromRAI(name, rai, isFortranOrder, isNumpy);
        }
        return SharedMemoryArrayMacOS.createSHMAFromRAI(name, rai, isFortranOrder, isNumpy);
    }

    public static void checkMemorySegmentName(String name) throws IllegalArgumentException {
        String auxName = PlatformDetection.isWindows() && name.startsWith("Local\\") ? name.substring("Local\\".length()) : (name.startsWith("/") ? name.substring(1) : name);
        for (String specialChar : SPECIAL_CHARS_LIST) {
            if (!auxName.contains(specialChar)) continue;
            throw new IllegalArgumentException("Argument 'name' should not contain the special character '" + specialChar + "'.");
        }
        if (PlatformDetection.isMacOS() && auxName.length() > 29) {
            throw new IllegalArgumentException("Parameter 'name' cannot have more than 29 characters. Shared memory segments cannot have names with more than 29 characters.");
        }
    }

    public static String createShmName() {
        if (PlatformDetection.isWindows()) {
            return "Local" + File.separator + UUID.randomUUID().toString();
        }
        if (PlatformDetection.isLinux()) {
            return "/shm-" + UUID.randomUUID();
        }
        return ("/shm-" + UUID.randomUUID()).substring(0, 30);
    }

    public static <T extends RealType<T> & NativeType<T>> int getArrayByteSize(long[] shape, T type) {
        return SharedMemoryArray.getArrayByteSize(shape, type, false, false);
    }

    public static <T extends RealType<T> & NativeType<T>> int getArrayByteSize(long[] shape, T type, boolean isNpy, boolean isFortran) {
        int noByteSize = 1;
        int headerSize = 0;
        if (isNpy) {
            headerSize = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(shape, type, isFortran);
        }
        for (long l : shape) {
            noByteSize = (int)((long)noByteSize * l);
        }
        if (type instanceof ByteType || type instanceof UnsignedByteType) {
            return noByteSize * 1 + headerSize;
        }
        if (type instanceof ShortType || type instanceof UnsignedShortType) {
            return noByteSize * 2 + headerSize;
        }
        if (type instanceof IntType || type instanceof UnsignedIntType || type instanceof FloatType) {
            return noByteSize * 4 + headerSize;
        }
        if (type instanceof LongType || type instanceof DoubleType) {
            return noByteSize * 8 + headerSize;
        }
        throw new IllegalArgumentException("Type not supported: " + type.getClass().toString());
    }

    public Object getSharedMemoryBlockID();

    public String getName();

    public String getNameForPython();

    public Pointer getPointer();

    public int getSize();

    public String getOriginalDataType();

    public long[] getOriginalShape();

    public <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> getSharedRAI();

    public <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> getSharedRAI(long[] var1, T var2);

    public <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> getSharedRAI(long[] var1, T var2, boolean var3);

    public void setBuffer(ByteBuffer var1);

    public ByteBuffer getDataBuffer();

    public ByteBuffer getDataBufferNoHeader();

    public boolean isNumpyFormat();
}

