/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.utils;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class FileUtils {
    public static void copyFolder(Path src, Path dest) throws IOException {
        if (!Files.exists(dest, new LinkOption[0])) {
            Files.createDirectories(dest, new FileAttribute[0]);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(src);){
            for (Path entry : stream) {
                Path newDest = dest.resolve(entry.getFileName());
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    FileUtils.copyFolder(entry, newDest);
                    continue;
                }
                Files.copy(entry, newDest, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }
}

