/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.ezplug;

import icy.file.FileUtil;
import icy.main.Icy;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginImageAnalysis;
import icy.plugin.interface_.PluginLibrary;
import icy.system.IcyHandledException;
import icy.type.value.IntegerValue;
import java.awt.Component;
import java.io.File;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import javax.swing.JOptionPane;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzException;
import plugins.adufour.ezplug.EzGUI;
import plugins.adufour.ezplug.EzPanel;
import plugins.adufour.ezplug.EzStatus;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarIO;
import plugins.adufour.vars.util.VarException;

public abstract class EzPlug
extends Plugin
implements PluginImageAnalysis,
PluginLibrary,
Runnable {
    public static final String EZPLUG_MAINTAINERS = "Alexandre Dufour (adufour@pasteur.fr)";
    private static IntegerValue nbInstances;
    private EzGUI ezgui;
    private final HashMap<String, EzVar<?>> ezVars;
    private boolean timeTrial = false;
    private long startTime;
    private Thread executionThread = null;
    private final EzStatus status = new EzStatus();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EzPlug() {
        this.ezVars = new HashMap();
        IntegerValue integerValue = nbInstances;
        synchronized (integerValue) {
            nbInstances.setValue((Integer)nbInstances.getValue() + 1);
        }
    }

    protected void addComponent(Component component) {
        if (component == null) {
            throw new EzException(this, "null graphical component", false);
        }
        EzGUI g = this.getUI();
        if (g != null) {
            g.addComponent(component);
        }
    }

    protected void addEzComponent(EzComponent component) {
        EzGUI g;
        if (component == null) {
            throw new EzException(this, "A plug-in variable was not initialized properly", false);
        }
        if (component instanceof EzVar) {
            this.registerVariable((EzVar)component);
        }
        if (component instanceof EzPanel) {
            this.registerVariables((EzPanel)component);
        }
        if ((g = this.getUI()) != null) {
            g.addEzComponent(component, true);
        }
    }

    public abstract void clean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanFromUI() {
        block5: {
            try {
                this.clean();
            }
            catch (EzException eze) {
                if (eze.catchException) break block5;
                throw eze;
            }
        }
        this.ezVars.clear();
        this.ezgui = null;
        IntegerValue integerValue = nbInstances;
        synchronized (integerValue) {
            nbInstances.setValue((Integer)nbInstances.getValue() - 1);
        }
    }

    @Override
    @Deprecated
    public void compute() {
        if (Icy.getMainInterface().isHeadLess()) {
            this.execute();
            return;
        }
        try {
            this.createUI();
            this.showUI();
        }
        catch (EzException e) {
            if (e.catchException) {
                JOptionPane.showMessageDialog(this.ezgui.getFrame(), e.getMessage(), "Error", 0);
            }
            throw e;
        }
    }

    public void createUI() {
        this.ezgui = new EzGUI(this);
        this.initialize();
        this.ezgui.repack(true);
        for (EzVar<?> var : this.ezVars.values()) {
            var.fireVariableChangedInternal();
        }
        this.addIcyFrame(this.ezgui);
    }

    protected abstract void execute();

    public static String generateEzPlugCodeFragment(String className) {
        StringWriter sw = new StringWriter();
        sw.write("import " + EzPlug.class.getPackage().getName() + ".*;\n\n");
        sw.write("public class " + className + " extends " + EzPlug.class.getName() + "\n{\n");
        for (Method m : EzPlug.class.getDeclaredMethods()) {
            if (!Modifier.isAbstract(m.getModifiers())) continue;
            Class<?> returnType = m.getReturnType();
            sw.write("  public " + (returnType == null ? "void" : returnType.getName()) + " ");
            sw.write(m.getName() + "(");
            Class<?>[] params = m.getParameterTypes();
            if (params.length > 0) {
                int cpt = 1;
                sw.write(params[0].getName() + " arg" + cpt++);
                for (int i = 1; i < params.length; ++i) {
                    sw.write(", " + params[i].getName() + " arg" + cpt++);
                }
            }
            sw.write(")\n  {\n");
            sw.write("  // TODO: write your code here\n");
            sw.write("  }\n\n");
        }
        sw.write(125);
        return sw.toString();
    }

    @Override
    public String getName() {
        return this.getDescriptor().getName();
    }

    public static int getNbInstances() {
        return (Integer)nbInstances.getValue();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public EzGUI getUI() {
        return this.ezgui;
    }

    protected EzStatus getStatus() {
        return this.status;
    }

    public void hideUI() {
        if (this.ezgui == null) {
            return;
        }
        this.ezgui.setVisible(false);
    }

    public boolean isHeadLess() {
        return this.getUI() == null;
    }

    protected abstract void initialize();

    public void stopExecution() {
        if (this.executionThread != null) {
            this.executionThread.interrupt();
        }
    }

    public void loadParameters(File file) {
        block4: {
            try {
                EzVarIO.load(this, file, this.ezVars);
            }
            catch (EzException e) {
                if (!Icy.getMainInterface().isHeadLess()) {
                    JOptionPane.showMessageDialog(this.ezgui.getFrame(), e.getMessage(), "Error", 0);
                } else {
                    System.err.println("EzVarIO: " + e.getMessage());
                }
                if (e.catchException) break block4;
                throw e;
            }
        }
    }

    <T> void registerVariable(EzVar<T> var) {
        String varID = var.getID();
        if (this.ezVars.containsKey(varID)) {
            throw new IllegalArgumentException("Variable " + varID + " already exists");
        }
        this.ezVars.put(varID, var);
    }

    void registerVariables(EzPanel ezPanel) {
        for (EzComponent panelComponent : ezPanel) {
            if (panelComponent instanceof EzVar) {
                this.registerVariable((EzVar)panelComponent);
                continue;
            }
            if (!(panelComponent instanceof EzPanel)) continue;
            this.registerVariables((EzPanel)panelComponent);
        }
    }

    @Override
    public synchronized void run() {
        this.executionThread = Thread.currentThread();
        try {
            try {
                this.startTime = System.nanoTime();
                this.status.setCompletion(Double.NaN);
                this.status.setMessage("Running");
                this.execute();
                if (this.timeTrial) {
                    System.out.println(this.getName() + " executed in " + (System.nanoTime() - this.startTime) / 1000000L + " ms");
                }
            }
            catch (VarException e) {
                if (this.isHeadLess()) {
                    throw e;
                }
                String message = "Parameter: " + (e.source == null ? "(unknown)" : e.source.getName()) + "\n";
                message = message + "Message: " + e.getMessage();
                throw new EzException(this, message, true);
            }
        }
        catch (EzException e) {
            if (e.catchException) {
                String message = "Plugin: " + (e.source == null ? "(unknown)" : e.source.getName()) + "\n";
                message = message + e.getMessage();
                throw new IcyHandledException(message);
            }
            throw e;
        }
        finally {
            this.status.done();
        }
    }

    public void saveParameters(File file) {
        EzVarIO.save(this, this.ezVars, file);
    }

    public void showUI() {
        if (this.ezgui == null) {
            this.createUI();
        }
        this.ezgui.setVisible(true);
        this.ezgui.toFront();
    }

    public void setTimeDisplay(boolean displayRunningTime) {
        this.timeTrial = displayRunningTime;
    }

    static {
        String path = new File("").getAbsolutePath() + "/" + "plugins.adufour.vars".replace('.', '/');
        if (FileUtil.exists(path)) {
            try {
                FileUtil.delete(new File(path), true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        nbInstances = new IntegerValue(0);
    }
}

