/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi3d;

import icy.canvas.IcyCanvas;
import icy.painter.VtkPainter;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle3D;
import icy.vtk.IcyVtkPanel;
import icy.vtk.VtkUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.InputEvent;
import java.awt.geom.PathIterator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import plugins.kernel.canvas.VtkCanvas;
import plugins.kernel.roi.roi2d.ROI2DShape;
import plugins.kernel.roi.roi3d.ROI3DStack;
import vtk.vtkActor;
import vtk.vtkCellArray;
import vtk.vtkInformation;
import vtk.vtkMapper;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkProperty;

public abstract class ROI3DStackShape
extends ROI3DStack<ROI2DShape> {
    public ROI3DStackShape(Class<? extends ROI2DShape> roiClass) {
        super(roiClass);
    }

    @Override
    protected ROI.ROIPainter createPainter() {
        return new ROI3DStackShapePainter();
    }

    @Override
    public boolean isOverEdge(IcyCanvas canvas, double x, double y, double z) {
        ROI2DShape slice = (ROI2DShape)this.getSlice((int)z);
        if (slice != null) {
            return slice.isOverEdge(canvas, x, y);
        }
        return false;
    }

    public class ROI3DStackShapePainter
    extends ROI3DStack.ROI3DStackPainter
    implements VtkPainter,
    Runnable {
        protected vtkPolyData outline = null;
        protected vtkPolyDataMapper outlineMapper = null;
        protected vtkActor outlineActor = null;
        protected vtkInformation vtkInfo = null;
        protected vtkCellArray vCells = null;
        protected vtkPoints vPoints = null;
        protected vtkPolyData polyData = null;
        protected vtkPolyDataMapper polyMapper = null;
        protected vtkActor actor = null;
        protected boolean needRebuild;
        protected double[] scaling = new double[3];
        protected WeakReference<VtkCanvas> canvas3d;

        public ROI3DStackShapePainter() {
            Arrays.fill(this.scaling, 1.0);
            this.needRebuild = true;
            this.canvas3d = new WeakReference<Object>(null);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (this.actor != null) {
                this.actor.Delete();
            }
            if (this.polyMapper != null) {
                this.polyMapper.Delete();
            }
            if (this.polyData != null) {
                this.polyData.Delete();
            }
            if (this.vPoints != null) {
                this.vPoints.Delete();
            }
            if (this.vCells != null) {
                this.vCells.Delete();
            }
            if (this.outlineActor != null) {
                this.outlineActor.SetPropertyKeys(null);
                this.outlineActor.Delete();
            }
            if (this.vtkInfo != null) {
                this.vtkInfo.Remove(VtkCanvas.visibilityKey);
                this.vtkInfo.Delete();
            }
            if (this.outlineMapper != null) {
                this.outlineMapper.Delete();
            }
            if (this.outline != null) {
                this.outline.GetPointData().GetScalars().Delete();
                this.outline.GetPointData().Delete();
                this.outline.Delete();
            }
        }

        protected void initVtkObjects() {
            this.outline = VtkUtil.getOutline(0.0, 1.0, 0.0, 1.0, 0.0, 1.0);
            this.outlineMapper = new vtkPolyDataMapper();
            this.outlineActor = new vtkActor();
            this.outlineActor.SetMapper((vtkMapper)this.outlineMapper);
            this.outlineActor.SetPickable(0);
            this.outlineActor.GetProperty().SetRepresentationToWireframe();
            this.vtkInfo = new vtkInformation();
            this.vtkInfo.Set(VtkCanvas.visibilityKey, 0);
            this.outlineActor.SetPropertyKeys(this.vtkInfo);
            this.polyData = new vtkPolyData();
            this.polyMapper = new vtkPolyDataMapper();
            this.polyMapper.SetInputData(this.polyData);
            this.actor = new vtkActor();
            this.actor.SetMapper((vtkMapper)this.polyMapper);
            Color col = this.getColor();
            double r = (double)col.getRed() / 255.0;
            double g = (double)col.getGreen() / 255.0;
            double b = (double)col.getBlue() / 255.0;
            this.outlineActor.GetProperty().SetColor(r, g, b);
            vtkProperty property = this.actor.GetProperty();
            property.SetPointSize((float)this.getStroke());
            property.SetColor(r, g, b);
        }

        protected void rebuildVtkObjects() {
            int ind;
            VtkCanvas canvas = (VtkCanvas)this.canvas3d.get();
            if (canvas == null) {
                return;
            }
            IcyVtkPanel vtkPanel = canvas.getVtkPanel();
            if (vtkPanel == null) {
                return;
            }
            Sequence seq = canvas.getSequence();
            if (seq == null) {
                return;
            }
            Rectangle3D bounds = ROI3DStackShape.this.getBounds3D();
            VtkUtil.setOutlineBounds(this.outline, bounds.getMinX() * this.scaling[0], bounds.getMaxX() * this.scaling[0], bounds.getMinY() * this.scaling[1], bounds.getMaxY() * this.scaling[1], bounds.getMinZ() * this.scaling[2], bounds.getMaxZ() * this.scaling[2], canvas);
            ArrayList<double[]> point3DList = new ArrayList<double[]>();
            ArrayList<int[]> polyList = new ArrayList<int[]>();
            double[] coords = new double[6];
            double xm = 0.0;
            double ym = 0.0;
            double x0 = 0.0;
            double y0 = 0.0;
            double x1 = 0.0;
            double y1 = 0.0;
            double xs = this.scaling[0];
            double ys = this.scaling[1];
            double z = bounds.getMinZ();
            while (z <= bounds.getMaxZ()) {
                ROI2DShape roi2dShape = (ROI2DShape)ROI3DStackShape.this.getSlice((int)z);
                if (roi2dShape != null) {
                    double z0 = (z + 0.0) * this.scaling[2];
                    double z1 = (z + 1.0) * this.scaling[2];
                    PathIterator path = roi2dShape.getPathIterator(null, 0.5);
                    while (!path.isDone()) {
                        switch (path.currentSegment(coords)) {
                            case 0: {
                                x0 = xm = coords[0] * xs;
                                y0 = ym = coords[1] * ys;
                                break;
                            }
                            case 1: {
                                x1 = coords[0] * xs;
                                y1 = coords[1] * ys;
                                ind = point3DList.size();
                                point3DList.add(new double[]{x0, y0, z0});
                                point3DList.add(new double[]{x1, y1, z0});
                                point3DList.add(new double[]{x0, y0, z1});
                                point3DList.add(new double[]{x1, y1, z1});
                                polyList.add(new int[]{1 + ind, 2 + ind, 0 + ind});
                                polyList.add(new int[]{3 + ind, 2 + ind, 1 + ind});
                                x0 = x1;
                                y0 = y1;
                                break;
                            }
                            case 4: {
                                x1 = xm;
                                y1 = ym;
                                ind = point3DList.size();
                                point3DList.add(new double[]{x0, y0, z0});
                                point3DList.add(new double[]{x1, y1, z0});
                                point3DList.add(new double[]{x0, y0, z1});
                                point3DList.add(new double[]{x1, y1, z1});
                                polyList.add(new int[]{1 + ind, 2 + ind, 0 + ind});
                                polyList.add(new int[]{3 + ind, 2 + ind, 1 + ind});
                                x0 = x1;
                                y0 = y1;
                            }
                        }
                        path.next();
                    }
                }
                z += 1.0;
            }
            double[][] vertices = new double[point3DList.size()][3];
            int[][] indexes = new int[polyList.size()][3];
            ind = 0;
            for (double[] pt3D : point3DList) {
                vertices[ind++] = pt3D;
            }
            ind = 0;
            for (int[] poly : polyList) {
                indexes[ind++] = poly;
            }
            vtkCellArray previousCells = this.vCells;
            vtkPoints previousPoints = this.vPoints;
            this.vCells = VtkUtil.getCells(polyList.size(), VtkUtil.prepareCells(indexes));
            this.vPoints = VtkUtil.getPoints(vertices);
            vtkPanel.lock();
            try {
                this.outlineMapper.SetInputData(this.outline);
                this.outlineMapper.Update();
                this.polyData.SetPolys(this.vCells);
                this.polyData.SetPoints(this.vPoints);
                this.polyMapper.Update();
                if (previousCells != null) {
                    previousCells.Delete();
                }
                if (previousPoints != null) {
                    previousPoints.Delete();
                }
            }
            finally {
                vtkPanel.unlock();
            }
            this.updateVtkDisplayProperties();
        }

        protected void updateVtkDisplayProperties() {
            IcyVtkPanel vtkPanel;
            if (this.actor == null) {
                return;
            }
            VtkCanvas cnv = (VtkCanvas)this.canvas3d.get();
            vtkProperty vtkProperty2 = this.actor.GetProperty();
            Color col = this.getDisplayColor();
            double r = (double)col.getRed() / 255.0;
            double g = (double)col.getGreen() / 255.0;
            double b = (double)col.getBlue() / 255.0;
            float strk = (float)this.getStroke();
            IcyVtkPanel icyVtkPanel = vtkPanel = cnv != null ? cnv.getVtkPanel() : null;
            if (vtkPanel != null) {
                vtkPanel.lock();
            }
            try {
                this.outlineActor.GetProperty().SetColor(r, g, b);
                if (ROI3DStackShape.this.isSelected()) {
                    this.outlineActor.GetProperty().SetRepresentationToWireframe();
                    this.outlineActor.SetVisibility(1);
                    this.vtkInfo.Set(VtkCanvas.visibilityKey, 1);
                } else {
                    this.outlineActor.GetProperty().SetRepresentationToPoints();
                    this.outlineActor.SetVisibility(0);
                    this.vtkInfo.Set(VtkCanvas.visibilityKey, 0);
                }
                vtkProperty2.SetColor(r, g, b);
                vtkProperty2.SetPointSize(strk);
                this.setVtkObjectsColor(col);
            }
            finally {
                if (vtkPanel != null) {
                    vtkPanel.unlock();
                }
            }
            this.painterChanged();
        }

        protected void setVtkObjectsColor(Color color) {
            if (this.outline != null) {
                VtkUtil.setPolyDataColor(this.outline, color, (VtkCanvas)this.canvas3d.get());
            }
            if (this.polyData != null) {
                VtkUtil.setPolyDataColor(this.polyData, color, (VtkCanvas)this.canvas3d.get());
            }
        }

        @Override
        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (ROI3DStackShape.this.isActiveFor(canvas)) {
                if (canvas instanceof VtkCanvas) {
                    double[] s;
                    VtkCanvas cnv = (VtkCanvas)canvas;
                    if (this.canvas3d.get() != cnv) {
                        this.canvas3d = new WeakReference<VtkCanvas>(cnv);
                    }
                    if (!Arrays.equals(this.scaling, s = cnv.getVolumeScale())) {
                        this.scaling = s;
                        this.needRebuild = true;
                    }
                    if (this.needRebuild) {
                        if (this.actor == null) {
                            this.initVtkObjects();
                        }
                        ThreadUtil.runSingle(this);
                        this.needRebuild = false;
                    }
                } else {
                    super.paint(g, sequence, canvas);
                }
            }
        }

        @Override
        protected boolean updateFocus(InputEvent e, Point5D imagePoint, IcyCanvas canvas) {
            if (canvas instanceof VtkCanvas) {
                boolean focused = this.actor != null && this.actor == ((VtkCanvas)canvas).getPickedObject();
                ROI3DStackShape.this.setFocused(focused);
                return focused;
            }
            return super.updateFocus(e, imagePoint, canvas);
        }

        @Override
        public vtkProp[] getProps() {
            if (this.actor == null) {
                this.initVtkObjects();
            }
            return new vtkActor[]{this.actor, this.outlineActor};
        }

        @Override
        public void run() {
            this.rebuildVtkObjects();
        }
    }
}

