/*
 * Decompiled with CFR 0.152.
 */
package icy.roi.edit;

import icy.roi.ROI;
import icy.roi.edit.AbstractROIEdit;
import icy.type.point.Point5D;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class PositionROIEdit
extends AbstractROIEdit {
    Point5D prevPos;
    Point5D currentPos;

    public PositionROIEdit(ROI roi, Point5D prevPos, boolean mergeable) {
        super(roi, "ROI position changed");
        this.prevPos = prevPos;
        this.currentPos = roi.getPosition5D();
        this.setMergeable(mergeable);
    }

    public PositionROIEdit(ROI roi, Point5D prevPos) {
        this(roi, prevPos, true);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.getROI().setPosition5D(this.prevPos);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.getROI().setPosition5D(this.currentPos);
    }

    @Override
    public boolean addEdit(UndoableEdit edit) {
        PositionROIEdit posEdit;
        if (!this.isMergeable()) {
            return false;
        }
        if (edit instanceof PositionROIEdit && (posEdit = (PositionROIEdit)edit).getROI() == this.getROI()) {
            this.currentPos = posEdit.currentPos;
            return true;
        }
        return false;
    }

    @Override
    public void die() {
        super.die();
        this.prevPos = null;
        this.currentPos = null;
    }
}

