/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.transformations;

import io.bioimage.modelrunner.tensor.Tensor;
import io.bioimage.modelrunner.transformations.AbstractTensorTransformation;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;

public class AbstractTensorPixelTransformation
extends AbstractTensorTransformation {
    private DoubleUnitaryOperator dun;

    protected AbstractTensorPixelTransformation(String name) {
        super(name);
    }

    protected void setDoubleUnitaryOperator(DoubleUnitaryOperator fun) {
        this.dun = fun;
    }

    @Override
    public <R extends RealType<R> & NativeType<R>> Tensor<FloatType> apply(Tensor<R> input) {
        Tensor<FloatType> output = this.makeOutput(input);
        this.applyInPlace(output);
        return output;
    }

    @Override
    public <R extends RealType<R> & NativeType<R>> void applyInPlace(Tensor<R> input) {
        if (Util.getTypeFromInterval(input.getData()) instanceof IntegerType && this.dun != null) {
            LoopBuilder.setImages(input.getData()).multiThreaded().forEachPixel(i -> i.setReal(Math.floor(this.dun.applyAs(i.getRealDouble()))));
        } else if (this.dun != null) {
            LoopBuilder.setImages(input.getData()).multiThreaded().forEachPixel(i -> i.setReal(this.dun.applyAs(i.getRealDouble())));
        }
    }

    @FunctionalInterface
    public static interface DoubleUnitaryOperator {
        public double applyAs(double var1);
    }
}

