/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio.description.deepimagej;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeepImageJProcessing {
    private List<String> macros;
    private boolean containsJava = false;
    private static String macroKey = "ij.IJ::runMacroFile";
    private static String specsKey = "spec";
    private static String kwargsKey = "kwargs";

    public static DeepImageJProcessing build(Object prediction) {
        DeepImageJProcessing dijProcessing = new DeepImageJProcessing();
        dijProcessing.macros = new ArrayList<String>();
        if (prediction == null) {
            return dijProcessing;
        }
        if (prediction instanceof List) {
            dijProcessing.buildFromList((List)prediction);
        } else if (prediction instanceof HashMap) {
            dijProcessing.buildFromHashMap((HashMap)prediction);
        } else if (prediction instanceof HashMap) {
            dijProcessing.buildFromMap((Map)prediction);
        }
        return dijProcessing;
    }

    private void buildFromList(List<Object> prediction) {
        for (Object pp : prediction) {
            if (pp instanceof Map) {
                this.buildFromMap((Map)pp);
                continue;
            }
            if (!(pp instanceof HashMap)) continue;
            this.buildFromHashMap((HashMap)pp);
        }
    }

    private void buildFromMap(Map<String, Object> prediction) {
        if (prediction.get(specsKey) != null && prediction.get(specsKey).equals(macroKey)) {
            this.macros.add((String)prediction.get(kwargsKey));
        } else if (prediction.get(specsKey) != null) {
            this.containsJava = true;
        }
    }

    private void buildFromHashMap(HashMap<String, Object> prediction) {
        if (prediction.get(specsKey) != null && prediction.get(specsKey).equals(macroKey)) {
            this.macros.add((String)prediction.get(kwargsKey));
        } else if (prediction.get(specsKey) != null) {
            this.containsJava = true;
        }
    }

    public boolean containsJava() {
        return this.containsJava;
    }

    public List<String> getMacros() {
        return this.macros;
    }
}

