/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui;

import io.bioimage.modelrunner.apposed.appose.Types;
import io.bioimage.modelrunner.bioimageio.BioimageioRepo;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptorFactory;
import io.bioimage.modelrunner.engine.installation.EngineInstall;
import io.bioimage.modelrunner.gui.ContentPanel;
import io.bioimage.modelrunner.gui.DefaultIcon;
import io.bioimage.modelrunner.gui.EnvironmentInstaller;
import io.bioimage.modelrunner.gui.GuiUtils;
import io.bioimage.modelrunner.gui.Header;
import io.bioimage.modelrunner.gui.ModelSelectionPanel;
import io.bioimage.modelrunner.gui.SearchBar;
import io.bioimage.modelrunner.gui.YesNoDialog;
import io.bioimage.modelrunner.gui.adapter.GuiAdapter;
import io.bioimage.modelrunner.gui.adapter.RunnerAdapter;
import io.bioimage.modelrunner.gui.workers.InstallEnvWorker;
import io.bioimage.modelrunner.tensor.Tensor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;

public class Gui
extends JPanel {
    private static final long serialVersionUID = 1081914206026104187L;
    private RunnerAdapter runner;
    private GuiAdapter guiAdapter;
    private int currentIndex = 1;
    private final String modelsDir;
    private final String enginesDir;
    private final Object lock = new Object();
    private int nParsedModels;
    Thread engineInstallThread;
    Thread trackEngineInstallThread;
    Thread dwnlThread;
    Thread runninThread;
    Thread finderThread;
    Thread updaterThread;
    Thread localModelsThread;
    private SearchBar searchBar;
    private ContentPanel contentPanel;
    private ModelSelectionPanel modelSelectionPanel;
    private Header titlePanel;
    private JPanel footerPanel;
    private JButton runButton;
    private JButton runOnTestButton;
    private JButton cancelButton;
    protected static final String LOADING_STR = "loading...";
    protected static final String NOT_FOUND_STR = "no models found";
    protected static final String LOCAL_STR = "Local";
    protected static final String BIOIMAGEIO_STR = "Bioimage.io";
    protected static final String RUN_STR = "Run";
    protected static final String CANCEL_STR = "Cancel";
    protected static final String RUN_ON_TEST_STR = "Run on test";
    protected static final String INSTALL_STR = "Install model";
    private static final String MODELS_DEAFULT = "models";
    private static final String ENGINES_DEAFULT = "engines";
    protected static final List<String> UNSUPPORTED_MODELS = Arrays.asList("idealistic-rat", "diplomatic-bug", "resourceful-lizard", "famous-fish", "happy-elephant", "affectionate-cow", "faithful-chicken", "humorous-crab", "noisy-ox", "greedy-whale", "efficient-chipmunk", "philosophical-panda", "amiable-crocodile", "loyal-parrot", "conscientious-seashell", "straightforward-crocodile", "polite-pig");
    private static final String INSTALL_INSTRUCTIONS_FORMAT = "No models found at: %s" + File.separator + "models<br><br>Please, install manually or download models from the Bioimage.io.<br><br>To download models from the Bioimage.io, click on the Bioimage.io button on the top right.";
    public static String INSTALL_INSTRUCTIONS = "No models found.<br><br>Please, install manually or download models from the Bioimage.io.<br><br>To download models from the Bioimage.io, click on the Bioimage.io button on the top right.";

    public Gui(GuiAdapter guiAdapter) {
        DefaultIcon.setIconPath(guiAdapter.getIconPath());
        INSTALL_INSTRUCTIONS = String.format(INSTALL_INSTRUCTIONS_FORMAT, guiAdapter.getSoftwareName());
        this.guiAdapter = guiAdapter;
        long tt = System.currentTimeMillis();
        this.modelsDir = guiAdapter.getModelsDir() != null ? guiAdapter.getModelsDir() : new File(MODELS_DEAFULT).getAbsolutePath();
        this.enginesDir = guiAdapter.getEnginesDir() != null ? guiAdapter.getEnginesDir() : new File(ENGINES_DEAFULT).getAbsolutePath();
        this.loadLocalModels();
        System.out.println("Model loading: " + (System.currentTimeMillis() - tt));
        tt = System.currentTimeMillis();
        this.installEnginesIfNeeded();
        System.out.println("Engines loading: " + (System.currentTimeMillis() - tt));
        tt = System.currentTimeMillis();
        this.setLayout(new GridBagLayout());
        System.out.println("Set size: " + (System.currentTimeMillis() - tt));
        tt = System.currentTimeMillis();
        this.initTitlePanel();
        System.out.println("Title panel: " + (System.currentTimeMillis() - tt));
        tt = System.currentTimeMillis();
        this.initSearchBar();
        System.out.println("Search bar: " + (System.currentTimeMillis() - tt));
        tt = System.currentTimeMillis();
        this.initMainContentPanel();
        System.out.println("Content panel: " + (System.currentTimeMillis() - tt));
        tt = System.currentTimeMillis();
        this.initFooterPanel();
        System.out.println("Footer: " + (System.currentTimeMillis() - tt));
        this.setVisible(true);
    }

    private void installEnginesIfNeeded() {
        SwingUtilities.invokeLater(() -> {
            this.searchBar.switchButton.setEnabled(false);
            this.runButton.setEnabled(false);
            this.runOnTestButton.setEnabled(false);
        });
        this.engineInstallThread = new Thread(() -> {
            EngineInstall installer = EngineInstall.createInstaller(this.enginesDir);
            installer.checkBasicEngineInstallation();
            while (this.titlePanel == null) {
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            if (installer.getMissingEngines().size() != 0) {
                this.titlePanel.setGUIStartInstallation();
                installer.setEngineInstalledConsumer(this.titlePanel.createStringConsumer());
                installer.setProgresConsumer(this.titlePanel.createProgressConsumer());
                try {
                    installer.basicEngineInstallation();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            SwingUtilities.invokeLater(() -> {
                System.out.println("done");
                this.searchBar.switchButton.setEnabled(true);
                this.runButton.setEnabled(true);
                this.runOnTestButton.setEnabled(true);
            });
        });
        this.engineInstallThread.start();
    }

    private void loadLocalModels() {
        this.localModelsThread = new Thread(() -> {
            List<ModelDescriptor> models = ModelDescriptorFactory.getModelsAtLocalRepo(new File(this.modelsDir).getAbsolutePath());
            while (this.contentPanel == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.setModels(models);
        });
        this.localModelsThread.start();
    }

    private void initTitlePanel() {
        this.titlePanel = new Header(this.guiAdapter);
        this.titlePanel.setPreferredSize(new Dimension(0, 0));
        this.titlePanel.setMinimumSize(new Dimension(0, 0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        gbc.weighty = 0.1;
        this.add((Component)this.titlePanel, gbc);
    }

    private void initSearchBar() {
        this.searchBar = new SearchBar();
        this.searchBar.setPreferredSize(new Dimension(0, 0));
        this.searchBar.setMinimumSize(new Dimension(0, 0));
        this.searchBar.switchButton.addActionListener(ee -> this.switchBtnClicked());
        this.searchBar.searchButton.addActionListener(ee -> this.searchModels());
        this.searchBar.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    Gui.this.searchModels();
                }
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.gridy = 1;
        gbc.weighty = 0.06;
        this.add((Component)this.searchBar, gbc);
    }

    private void initMainContentPanel() {
        JPanel mainContentPanel = new JPanel(new GridLayout(2, 1));
        mainContentPanel.setPreferredSize(new Dimension(0, 0));
        mainContentPanel.setMinimumSize(new Dimension(0, 0));
        this.modelSelectionPanel = new ModelSelectionPanel(this.guiAdapter);
        mainContentPanel.add(this.modelSelectionPanel);
        this.contentPanel = new ContentPanel(this.guiAdapter);
        mainContentPanel.add(this.contentPanel);
        this.modelSelectionPanel.prevButton.addActionListener(e -> this.updateCarousel(-1));
        this.modelSelectionPanel.nextButton.addActionListener(e -> this.updateCarousel(1));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.gridy = 2;
        gbc.weighty = 0.83;
        this.add((Component)mainContentPanel, gbc);
    }

    private void initFooterPanel() {
        this.footerPanel = new JPanel(new GridBagLayout());
        this.footerPanel.setPreferredSize(new Dimension(0, 0));
        this.footerPanel.setMinimumSize(new Dimension(0, 0));
        this.footerPanel.setBackground(new Color(45, 62, 80));
        this.footerPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        this.runOnTestButton = new JButton(RUN_ON_TEST_STR);
        this.runOnTestButton.addActionListener(e -> this.runTestOrInstall());
        this.styleButton(this.runOnTestButton, "blue");
        this.runButton = new JButton(RUN_STR);
        this.runButton.addActionListener(e -> this.runModel());
        this.styleButton(this.runButton, "blue");
        this.cancelButton = new JButton(CANCEL_STR);
        this.cancelButton.addActionListener(e -> this.cancel());
        this.styleButton(this.cancelButton, "red");
        JPanel runButtonPanel = new JPanel(new GridBagLayout());
        runButtonPanel.setBackground(new Color(45, 62, 80));
        GridBagConstraints rbGbc = new GridBagConstraints();
        rbGbc.gridy = 0;
        rbGbc.fill = 1;
        rbGbc.insets = new Insets(0, 5, 0, 5);
        rbGbc.gridx = 0;
        rbGbc.weightx = 0.2;
        runButtonPanel.add((Component)this.cancelButton, rbGbc);
        rbGbc.gridx = 1;
        rbGbc.weightx = 0.4;
        runButtonPanel.add((Component)this.runOnTestButton, rbGbc);
        rbGbc.gridx = 2;
        rbGbc.weightx = 0.4;
        runButtonPanel.add((Component)this.runButton, rbGbc);
        JLabel copyrightLabel = new JLabel("\u00a9 2025 " + this.guiAdapter.getSoftwareName() + " and JDLL");
        copyrightLabel.setFont(new Font("SansSerif", 0, 12));
        copyrightLabel.setForeground(Color.WHITE);
        GridBagConstraints fGbc = new GridBagConstraints();
        fGbc.gridy = 0;
        fGbc.fill = 1;
        fGbc.insets = new Insets(0, 0, 0, 0);
        fGbc.gridx = 0;
        fGbc.weightx = 0.4;
        this.footerPanel.add((Component)copyrightLabel, fGbc);
        fGbc.gridx = 1;
        fGbc.weightx = 0.6;
        this.footerPanel.add((Component)runButtonPanel, fGbc);
        GridBagConstraints mainGbc = new GridBagConstraints();
        mainGbc.gridx = 0;
        mainGbc.gridy = 3;
        mainGbc.gridwidth = 1;
        mainGbc.fill = 1;
        mainGbc.weightx = 1.0;
        mainGbc.weighty = 0.06;
        this.add((Component)this.footerPanel, mainGbc);
    }

    private void cancel() {
        this.onClose();
    }

    private void runTestOrInstall() {
        if (this.runOnTestButton.getText().equals(INSTALL_STR)) {
            this.installSelectedModel();
        } else if (this.runOnTestButton.getText().equals(RUN_ON_TEST_STR)) {
            this.runModelOnTestImage();
        }
    }

    private <T extends RealType<T> & NativeType<T>> void runModel() {
        this.startModelInstallation(true);
        this.runninThread = new Thread(() -> {
            try {
                ModelDescriptor model = this.modelSelectionPanel.getModels().get(this.currentIndex);
                if (this.runner == null || this.runner.isClosed()) {
                    if (!this.installEnvToRun(model) && !model.getModelFamily().equals("stardist")) {
                        this.startModelInstallation(false);
                        return;
                    }
                    SwingUtilities.invokeLater(() -> this.contentPanel.setProgressLabelText("Loading model..."));
                    this.runner = this.guiAdapter.createRunner(model);
                }
                if (!this.runner.isLoaded() && GuiUtils.isEDTAlive()) {
                    this.runner.load();
                } else if (!GuiUtils.isEDTAlive()) {
                    return;
                }
                SwingUtilities.invokeLater(() -> this.contentPanel.setProgressLabelText("Running the model..."));
                List<String> inputNames = this.guiAdapter.getInputImageNames();
                List list = this.guiAdapter.getInputTensors(this.runner.getDescriptor());
                List outs = this.runner.run(list);
                for (Tensor tt : outs) {
                    if (!GuiUtils.isEDTAlive()) {
                        return;
                    }
                    if (!GuiUtils.isEDTAlive()) {
                        return;
                    }
                    this.guiAdapter.displayRai(tt.getData(), tt.getAxesOrderString(), tt.getName() + "_of_" + inputNames.get(0));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.startModelInstallation(false);
        });
        this.runninThread.start();
    }

    private <T extends RealType<T> & NativeType<T>> void runModelOnTestImage() {
        this.startModelInstallation(true);
        this.runninThread = new Thread(() -> {
            try {
                ModelDescriptor model = this.modelSelectionPanel.getModels().get(this.currentIndex);
                if (this.runner == null || this.runner.isClosed()) {
                    if (!this.installEnvToRun(model) && !model.getModelFamily().equals("stardist")) {
                        this.startModelInstallation(false);
                        return;
                    }
                    SwingUtilities.invokeLater(() -> this.contentPanel.setProgressLabelText("Loading model..."));
                    this.runner = this.guiAdapter.createRunner(model);
                }
                if (!this.runner.isLoaded() && GuiUtils.isEDTAlive()) {
                    this.runner.load();
                } else if (!GuiUtils.isEDTAlive()) {
                    return;
                }
                SwingUtilities.invokeLater(() -> this.contentPanel.setProgressLabelText("Running the model..."));
                List outs = this.runner.runOnTestImages();
                List<String> inputNames = this.guiAdapter.getInputImageNames();
                for (Tensor tt : outs) {
                    if (!GuiUtils.isEDTAlive()) {
                        return;
                    }
                    if (!GuiUtils.isEDTAlive()) {
                        return;
                    }
                    this.guiAdapter.displayRai(tt.getData(), tt.getAxesOrderString(), tt.getName() + "_of_" + inputNames.get(0));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.startModelInstallation(false);
        });
        this.runninThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCarousel(int direction) {
        this.closeModelWhenChanging();
        Object object = this.lock;
        synchronized (object) {
            this.currentIndex = this.getWrappedIndex(this.currentIndex + direction);
            this.updateProgressBar();
            this.modelSelectionPanel.redrawModelCards(this.currentIndex);
            int logoHeight = (int)((double)this.getHeight() * 0.3);
            int logoWidth = this.getWidth() / 3;
            URL coverPath = this.modelSelectionPanel.getCoverPaths().get(this.currentIndex);
            boolean supported = true;
            if (this.modelSelectionPanel.getModels().get(this.currentIndex) != null && this.modelSelectionPanel.getModels().get(this.currentIndex).getModelFamily().equals("bioimage.io")) {
                boolean bl = supported = this.modelSelectionPanel.getModels().get(this.currentIndex).getWeights().getAllSuportedWeightNames().size() != 0;
                if (UNSUPPORTED_MODELS.contains(this.modelSelectionPanel.getModels().get(this.currentIndex).getNickname())) {
                    supported = false;
                }
            }
            this.contentPanel.setUnsupported(!supported);
            this.contentPanel.update(this.modelSelectionPanel.getModels().get(this.currentIndex), coverPath, logoWidth, logoHeight);
            if (this.searchBar.isBarOnLocal()) {
                this.runOnTestButton.setEnabled(supported);
                this.runButton.setEnabled(supported);
            }
        }
    }

    private void updateProgressBar() {
        if (this.modelSelectionPanel.getModels().get(this.currentIndex) == null) {
            return;
        }
        if (this.searchBar.isBarOnLocal() && this.contentPanel.getProgress() != 0) {
            this.contentPanel.setProgressBarText("");
            this.contentPanel.setDeterminatePorgress(0);
        } else if (!this.searchBar.isBarOnLocal() && this.contentPanel.getProgress() != 100 && this.modelSelectionPanel.getModels().get(this.currentIndex).isModelInLocalRepo()) {
            this.contentPanel.setProgressBarText("100%");
            this.contentPanel.setDeterminatePorgress(100);
        } else if (!this.searchBar.isBarOnLocal() && this.contentPanel.getProgress() != 0 && !this.modelSelectionPanel.getModels().get(this.currentIndex).isModelInLocalRepo()) {
            this.contentPanel.setProgressBarText("");
            this.contentPanel.setDeterminatePorgress(0);
        }
        if (this.searchBar.isBarOnLocal() || !this.searchBar.isBarOnLocal() && !this.modelSelectionPanel.getModels().get(this.currentIndex).isModelInLocalRepo() && !this.contentPanel.getProgressBarText().equals("")) {
            this.contentPanel.setProgressBarText("");
        }
    }

    private int getWrappedIndex(int index) {
        int size = this.modelSelectionPanel.getModelNames().size();
        return (index % size + size) % size;
    }

    private void styleButton(JButton button, String color) {
        button.setFont(new Font("SansSerif", 1, 14));
        if (color.equals("red")) {
            button.setBackground(new Color(255, 20, 20));
        } else {
            button.setBackground(new Color(52, 152, 219));
        }
        button.setForeground(Color.WHITE);
        button.setFocusPainted(false);
        button.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
    }

    public void setModels(List<ModelDescriptor> models) {
        if (models.size() == 0) {
            models = Gui.createArrayOfNulls(1);
        }
        this.modelSelectionPanel.setNotFound();
        this.searchBar.setModels(models);
        this.setModelsInGui(models);
    }

    protected void setModelsInGui(List<ModelDescriptor> models) {
        this.currentIndex = 0;
        this.modelSelectionPanel.setModels(models);
        int logoHeight = (int)((double)this.getHeight() * 0.3);
        int logoWidth = this.getWidth() / 3;
        URL coverPath = this.modelSelectionPanel.getCoverPaths().get(this.currentIndex);
        boolean supported = true;
        if (this.modelSelectionPanel.getModels().get(this.currentIndex) != null && this.modelSelectionPanel.getModels().get(this.currentIndex).getModelFamily().equals("bioimage.io")) {
            boolean bl = supported = this.modelSelectionPanel.getModels().get(this.currentIndex).getWeights().getAllSuportedWeightNames().size() != 0;
            if (UNSUPPORTED_MODELS.contains(this.modelSelectionPanel.getModels().get(this.currentIndex).getNickname())) {
                supported = false;
            }
        }
        this.contentPanel.setUnsupported(!supported);
        this.contentPanel.update(this.modelSelectionPanel.getModels().get(this.currentIndex), coverPath, logoWidth, logoHeight);
        if (this.searchBar.isBarOnLocal()) {
            this.runOnTestButton.setEnabled(supported);
            this.runButton.setEnabled(supported);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setModelInGuiAt(ModelDescriptor model, int pos) {
        this.modelSelectionPanel.setModelAt(model, pos);
        Object object = this.lock;
        synchronized (object) {
            if (this.currentIndex == pos || this.currentIndex == pos + 1 || this.currentIndex == pos - 1 || this.getWrappedIndex(pos + 1) == this.currentIndex) {
                SwingUtilities.invokeLater(() -> this.updateCarousel(0));
            }
        }
    }

    private void searchModels() {
        List<ModelDescriptor> models = this.searchBar.performSearch();
        if (models.size() == 0) {
            this.modelSelectionPanel.setNotFound();
            models = Gui.createArrayOfNulls(1);
        }
        this.setModelsInGui(models);
    }

    protected void switchBtnClicked() {
        this.closeModelWhenChanging();
        if (this.searchBar.isBarOnLocal()) {
            this.clickedBMZ();
        } else {
            this.clickedLocal();
        }
    }

    private void closeModelWhenChanging() {
        if (this.runner != null && !this.runner.isClosed()) {
            try {
                this.runner.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void clickedBMZ() {
        ArrayList<ModelDescriptor> newModels = Gui.createArrayOfNulls(3);
        this.searchBar.setBarEnabled(false);
        this.searchBar.changeButtonToLocal();
        this.contentPanel.setProgressIndeterminate(true);
        this.contentPanel.setProgressBarText("");
        this.runButton.setVisible(false);
        this.runOnTestButton.setText(INSTALL_STR);
        this.runOnTestButton.setEnabled(false);
        this.modelSelectionPanel.setBMZBorder();
        this.contentPanel.setProgressLabelText("Looking for models at Bioimage.io");
        this.setModelsInGui(newModels);
        ArrayList<ModelDescriptor> oldModels = new ArrayList<ModelDescriptor>(this.searchBar.getBMZModels());
        this.finderThread = new Thread(() -> {
            try {
                this.searchBar.countBMZModels(true);
                this.searchBar.findBMZModels();
            }
            catch (InterruptedException e) {
                return;
            }
        });
        this.updaterThread = new Thread(() -> {
            try {
                this.nParsedModels = 0;
                while (oldModels.equals(this.searchBar.getBMZModels()) && this.finderThread.isAlive()) {
                    Thread.sleep(100L);
                }
                ArrayList<ModelDescriptor> modelsList = Gui.createArrayOfNulls(this.searchBar.countBMZModels(false));
                if (this.finderThread.isAlive()) {
                    SwingUtilities.invokeLater(() -> this.setModelsInGui(modelsList));
                }
                while (this.finderThread.isAlive()) {
                    Thread.sleep(100L);
                    ArrayList<ModelDescriptor> foundModels = new ArrayList<ModelDescriptor>(this.searchBar.getBMZModels());
                    if (foundModels.size() < this.nParsedModels + 5) continue;
                    for (int i = this.nParsedModels; i < foundModels.size(); ++i) {
                        this.setModelInGuiAt((ModelDescriptor)foundModels.get(i), i);
                    }
                    this.nParsedModels = foundModels.size();
                }
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
            }
            catch (InterruptedException e) {
                return;
            }
            List<ModelDescriptor> foundModels = this.searchBar.getBMZModels();
            for (int i = this.nParsedModels; i < foundModels.size(); ++i) {
                int j = 0 + i;
                SwingUtilities.invokeLater(() -> this.setModelInGuiAt((ModelDescriptor)foundModels.get(j), j));
            }
            SwingUtilities.invokeLater(() -> {
                this.contentPanel.setProgressIndeterminate(false);
                this.searchBar.setBarEnabled(true);
                this.runOnTestButton.setEnabled(true);
                this.contentPanel.setProgressLabelText("");
            });
        });
        this.finderThread.start();
        this.updaterThread.start();
    }

    private static ArrayList<ModelDescriptor> createArrayOfNulls(int n) {
        ArrayList<ModelDescriptor> newModels = new ArrayList<ModelDescriptor>();
        for (int i = 0; i < n; ++i) {
            newModels.add(null);
        }
        return newModels;
    }

    protected void clickedLocal() {
        this.modelSelectionPanel.setLoading();
        ArrayList<ModelDescriptor> newModels = Gui.createArrayOfNulls(3);
        this.searchBar.setBarEnabled(false);
        this.searchBar.changeButtonToBMZ();
        this.contentPanel.setProgressIndeterminate(true);
        this.contentPanel.setProgressBarText("");
        this.contentPanel.setProgressLabelText("Looking for models locally");
        this.runButton.setVisible(true);
        this.runButton.setEnabled(false);
        this.runOnTestButton.setText(RUN_ON_TEST_STR);
        this.runOnTestButton.setEnabled(false);
        this.modelSelectionPanel.setLocalBorder();
        this.modelSelectionPanel.setArrowsEnabled(false);
        this.setModelsInGui(newModels);
        Thread finderThread = new Thread(() -> this.searchBar.findLocalModels(new File(this.modelsDir).getAbsolutePath()));
        Thread updaterThread = new Thread(() -> {
            List<ModelDescriptor> foundModels;
            while (finderThread.isAlive()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
                foundModels = new ArrayList<ModelDescriptor>(this.searchBar.getBMZModels());
                if (foundModels.size() <= 0) continue;
                SwingUtilities.invokeLater(() -> this.setModelsInGui(foundModels));
            }
            foundModels = this.searchBar.getBMZModels();
            SwingUtilities.invokeLater(() -> {
                if (foundModels.size() > 0) {
                    this.setModelsInGui(foundModels);
                }
                this.contentPanel.setProgressIndeterminate(false);
                this.contentPanel.setDeterminatePorgress(0);
                this.contentPanel.setProgressBarText("");
                this.contentPanel.setProgressLabelText("");
                this.searchBar.setBarEnabled(true);
                this.runOnTestButton.setEnabled(!this.contentPanel.isUnsupported());
                this.modelSelectionPanel.setArrowsEnabled(true);
                this.runButton.setEnabled(!this.contentPanel.isUnsupported());
            });
        });
        finderThread.start();
        updaterThread.start();
    }

    private void startModelInstallation(boolean isStarting) {
        SwingUtilities.invokeLater(() -> {
            this.runOnTestButton.setEnabled(!isStarting);
            this.runButton.setEnabled(!isStarting);
            this.searchBar.setBarEnabled(!isStarting);
            this.modelSelectionPanel.setArrowsEnabled(!isStarting);
            this.contentPanel.setProgressIndeterminate(isStarting);
            if (isStarting) {
                this.contentPanel.setProgressLabelText("Installing ...");
            } else {
                this.contentPanel.setProgressLabelText("");
            }
        });
    }

    private void checkModelInstallationFinished(CountDownLatch latch) {
        if (latch.getCount() == 0L) {
            this.startModelInstallation(false);
        }
    }

    private void installSelectedModel() {
        ModelDescriptor selectedModel = this.modelSelectionPanel.getModels().get(this.currentIndex);
        Consumer<Double> progress = c -> SwingUtilities.invokeLater(() -> {
            double pr = (double)Math.round(c * 10000.0) / 100.0;
            this.contentPanel.setDeterminatePorgress((int)pr);
            this.contentPanel.setProgressBarText("" + pr + "%");
        });
        this.startModelInstallation(true);
        CountDownLatch latch = new CountDownLatch(2);
        this.dwnlThread = new Thread(() -> {
            try {
                String modelFolder = BioimageioRepo.downloadModel(selectedModel, new File(this.modelsDir).getAbsolutePath(), progress);
                selectedModel.addModelPath(Paths.get(modelFolder, new String[0]));
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
            latch.countDown();
            this.checkModelInstallationFinished(latch);
        });
        this.dwnlThread.start();
        this.installEnv(selectedModel, latch);
    }

    private void installEnv(ModelDescriptor descriptor, CountDownLatch latch) {
        String msg = "Installation of Python environments might take up to 20 minutes.";
        String question = String.format("Install %s Python", descriptor.getModelFamily());
        if (descriptor.areRequirementsInstalled() || !YesNoDialog.askQuestion(question, msg)) {
            latch.countDown();
            this.checkModelInstallationFinished(latch);
            return;
        }
        JDialog installerFrame = new JDialog();
        installerFrame.setTitle("Installing " + descriptor.getName());
        installerFrame.setDefaultCloseOperation(0);
        Runnable callback = () -> {
            this.checkModelInstallationFinished(latch);
            if (installerFrame.isVisible()) {
                installerFrame.dispose();
            }
        };
        InstallEnvWorker worker = new InstallEnvWorker(descriptor, latch, callback);
        EnvironmentInstaller installerPanel = EnvironmentInstaller.create(worker);
        worker.execute();
        installerPanel.addToFrame(installerFrame);
        installerFrame.setSize(600, 300);
    }

    private boolean installEnvToRun(ModelDescriptor descriptor) {
        String msg = "The selected model requries Python to run end to end. Python installation might take up to 20 minutes depending on your computer";
        String question = String.format("Install %s Python", descriptor.getModelFamily());
        if (descriptor.areRequirementsInstalled()) {
            return true;
        }
        if (!YesNoDialog.askQuestion(question, msg)) {
            return false;
        }
        JDialog[] installerFrame = new JDialog[1];
        InstallEnvWorker[] worker = new InstallEnvWorker[1];
        EnvironmentInstaller[] installerPanel = new EnvironmentInstaller[1];
        CountDownLatch latch = new CountDownLatch(1);
        Runnable callback = () -> {
            if (installerFrame[0].isVisible()) {
                installerFrame[0].dispose();
            }
        };
        try {
            SwingUtilities.invokeAndWait(() -> {
                installerFrame[0] = new JDialog();
                installerFrame[0].setTitle("Installing " + descriptor.getName());
                installerFrame[0].setDefaultCloseOperation(0);
                worker[0] = new InstallEnvWorker(descriptor, latch, callback);
                installerPanel[0] = EnvironmentInstaller.create(worker[0]);
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            throw new RuntimeException(Types.stackTrace(e));
        }
        worker[0].execute();
        SwingUtilities.invokeLater(() -> {
            installerPanel[0].addToFrame(installerFrame[0]);
            installerFrame[0].setSize(600, 300);
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void onClose() {
        DefaultIcon.closeThreads();
        if (this.dwnlThread != null && this.dwnlThread.isAlive()) {
            this.dwnlThread.interrupt();
        }
        if (this.engineInstallThread != null && this.engineInstallThread.isAlive()) {
            this.engineInstallThread.interrupt();
        }
        if (this.trackEngineInstallThread != null && this.trackEngineInstallThread.isAlive()) {
            this.trackEngineInstallThread.interrupt();
        }
        if (this.finderThread != null && this.finderThread.isAlive()) {
            this.finderThread.interrupt();
        }
        if (this.updaterThread != null && this.updaterThread.isAlive()) {
            this.updaterThread.interrupt();
        }
        if (this.runninThread != null && this.runner != null) {
            try {
                this.runner.close();
                this.runner = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.runninThread != null && this.runninThread.isAlive()) {
            this.runninThread.interrupt();
        }
    }
}

