/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui.custom;

import io.bioimage.modelrunner.exceptions.LoadModelException;
import io.bioimage.modelrunner.exceptions.RunModelException;
import io.bioimage.modelrunner.gui.EnvironmentInstaller;
import io.bioimage.modelrunner.gui.custom.CellposeGUI;
import io.bioimage.modelrunner.gui.custom.ConsumerInterface;
import io.bioimage.modelrunner.gui.workers.InstallEnvWorker;
import io.bioimage.modelrunner.model.special.cellpose.Cellpose;
import io.bioimage.modelrunner.tensor.Tensor;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Cast;
import net.imglib2.view.Views;

public class CellposePluginUI
extends CellposeGUI
implements ActionListener {
    private static final long serialVersionUID = 5381352117710530216L;
    private final ConsumerInterface consumer;
    private String whichLoaded;
    private Cellpose model;
    private String inputTitle;
    private Runnable cancelCallback;
    Thread workerThread;

    public CellposePluginUI(ConsumerInterface consumer) {
        this.consumer = consumer;
        ArrayList<JComponent> componentList = new ArrayList<JComponent>();
        if (consumer.getFocusedImageChannels() != null && consumer.getFocusedImageChannels() == 1) {
            this.nucleiCbox.setModel(new DefaultComboBoxModel<String>(GRAYSCALE_LIST));
            this.cytoCbox.setModel(new DefaultComboBoxModel<String>(GRAYSCALE_LIST));
        } else if (consumer.getFocusedImageChannels() != null && consumer.getFocusedImageChannels() == 3) {
            this.nucleiCbox.setModel(new DefaultComboBoxModel<String>(RGB_LIST));
            this.cytoCbox.setModel(new DefaultComboBoxModel<String>(RGB_LIST));
        } else {
            this.nucleiCbox.setModel(new DefaultComboBoxModel<String>(RGB_LIST));
            this.cytoCbox.setModel(new DefaultComboBoxModel<String>(RGB_LIST));
        }
        this.consumer.setVariableNames(VAR_NAMES);
        componentList.add(this.modelComboBox);
        componentList.add(this.customModelPathField);
        componentList.add(this.cytoCbox);
        componentList.add(this.nucleiCbox);
        componentList.add(this.diameterField);
        componentList.add(this.check);
        this.consumer.setComponents(componentList);
        this.footer.buttons.cancelButton.addActionListener(this);
        this.footer.buttons.installButton.addActionListener(this);
        this.footer.buttons.runButton.addActionListener(this);
        this.browseButton.addActionListener(this);
        this.modelComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                boolean enabled = CellposePluginUI.this.modelComboBox.getSelectedItem().equals("your custom model");
                CellposePluginUI.this.customLabel.setEnabled(enabled);
                CellposePluginUI.this.customModelPathField.setEnabled(enabled);
                CellposePluginUI.this.browseButton.setEnabled(enabled);
            }
        });
    }

    public void setCancelCallback(Runnable cancelCallback) {
        this.cancelCallback = cancelCallback;
    }

    public void close() {
        if (this.model != null && this.model.isLoaded()) {
            this.model.close();
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("Cellpose Plugin");
                frame.setDefaultCloseOperation(3);
                frame.getContentPane().add(new CellposePluginUI(null));
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                frame.setResizable(true);
                frame.setSize(400, 200);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.browseButton) {
            this.browseFiles();
        } else if (e.getSource() == this.footer.buttons.runButton) {
            this.workerThread = new Thread(() -> {
                try {
                    this.runCellpose();
                    this.startModelInstallation(false);
                }
                catch (LoadModelException | RunModelException | IOException e1) {
                    e1.printStackTrace();
                    this.startModelInstallation(false);
                    SwingUtilities.invokeLater(() -> this.footer.bar.setString("Error running the model"));
                }
            });
            this.workerThread.start();
        } else if (e.getSource() == this.footer.buttons.installButton) {
            this.workerThread = new Thread(() -> this.installCellpose());
            this.workerThread.start();
        } else if (e.getSource() == this.footer.buttons.cancelButton) {
            this.cancel();
        }
    }

    private void cancel() {
        if (this.workerThread != null && this.workerThread.isAlive()) {
            this.workerThread.interrupt();
        }
        if (this.model != null) {
            this.model.close();
        }
        if (this.cancelCallback != null) {
            this.cancelCallback.run();
        }
    }

    private <T extends RealType<T> & NativeType<T>> void runCellpose() throws IOException, RunModelException, LoadModelException {
        this.startModelInstallation(true);
        this.installCellpose(this.weightsInstalled(), Cellpose.isInstalled());
        RandomAccessibleInterval rai = this.consumer.getFocusedImageAsRai();
        this.inputTitle = this.consumer.getFocusedImageName();
        if (rai == null) {
            JOptionPane.showMessageDialog(null, "Please open an image", "No image open", 0);
            return;
        }
        SwingUtilities.invokeLater(() -> {
            this.footer.bar.setIndeterminate(true);
            this.footer.bar.setString("Loading model");
        });
        String modelPath = (String)this.modelComboBox.getSelectedItem();
        modelPath = modelPath.equals("your custom model") ? this.customModelPathField.getText() : Cellpose.findPretrainedModelInstalled(modelPath, this.consumer.getModelsDir());
        if (this.whichLoaded != null && !this.whichLoaded.equals(modelPath)) {
            this.model.close();
        }
        if (this.model == null || !this.model.isLoaded()) {
            this.model = Cellpose.init(modelPath);
            this.model.loadModel();
        }
        this.whichLoaded = modelPath;
        SwingUtilities.invokeLater(() -> this.footer.bar.setString("Running the model"));
        if (this.diameterField.getText() != null && !this.diameterField.getText().equals("")) {
            this.model.setDiameter(Float.parseFloat(this.diameterField.getText()));
        }
        this.model.setChannels(new int[]{(Integer)CHANNEL_MAP.get(this.cytoCbox.getSelectedItem()), (Integer)CHANNEL_MAP.get(this.nucleiCbox.getSelectedItem())});
        if (rai.dimensionsAsLongArray().length == 4) {
            this.runCellposeOnFramesStack(rai);
        } else {
            this.runCellposeOnTensor(rai);
        }
    }

    private <T extends RealType<T> & NativeType<T>, R extends RealType<R> & NativeType<R>> void runCellposeOnFramesStack(RandomAccessibleInterval<R> rai) throws RunModelException {
        long[] dims = rai.dimensionsAsLongArray();
        RandomAccessibleInterval outMaskRai = (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.floats((long[])new long[]{dims[0], dims[1], dims[3]}));
        int i = 0;
        while ((long)i < rai.dimensionsAsLongArray()[3]) {
            ArrayList inList = new ArrayList();
            Tensor inIm = Tensor.build("input", "xyc", Views.hyperSlice(rai, (int)3, (long)i));
            inList.add(inIm);
            ArrayList outputList = new ArrayList();
            Tensor outMask = Tensor.build("mask", "xy", Views.hyperSlice((RandomAccessibleInterval)outMaskRai, (int)2, (long)i));
            outputList.add(outMask);
            this.model.run(inList, outputList);
            ++i;
        }
        this.consumer.display(outMaskRai, "xyb", "mask");
        if (!this.check.isSelected()) {
            return;
        }
    }

    private <T extends RealType<T> & NativeType<T>, R extends RealType<R> & NativeType<R>> void runCellposeOnTensor(RandomAccessibleInterval<R> rai) throws RunModelException {
        Tensor<R> tensor = Tensor.build("input", "xyc", rai);
        ArrayList inList = new ArrayList();
        inList.add(tensor);
        List out = this.model.run(inList);
        for (Tensor tt : out) {
            if (!this.check.isSelected() && !tt.getName().equals("labels") || tt.getAxesOrder().length == 1) continue;
            this.consumer.display(tt.getData(), tt.getAxesOrderString(), this.getOutputName(tt.getName()));
        }
    }

    private String getOutputName(String tensorName) {
        String noExtension = this.inputTitle.lastIndexOf(".") != -1 ? this.inputTitle.substring(0, this.inputTitle.lastIndexOf(".")) : this.inputTitle;
        String extension = ".tif";
        return noExtension + "_" + tensorName + extension;
    }

    private void installCellpose() {
        this.startModelInstallation(true);
        boolean envInstalled = Cellpose.isInstalled();
        boolean wwInstalled = this.weightsInstalled();
        if (envInstalled && wwInstalled) {
            this.startModelInstallation(false);
            return;
        }
        this.installCellpose(wwInstalled, envInstalled);
    }

    private void installCellpose(boolean wwInstalled, boolean envInstalled) {
        CountDownLatch latch;
        if (wwInstalled && envInstalled) {
            return;
        }
        SwingUtilities.invokeLater(() -> this.footer.bar.setString("Installing..."));
        CountDownLatch countDownLatch = latch = !wwInstalled && !envInstalled ? new CountDownLatch(2) : new CountDownLatch(1);
        if (!wwInstalled) {
            this.installModelWeights(latch);
        }
        if (!envInstalled) {
            this.installEnv(latch);
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private boolean weightsInstalled() {
        String model = (String)this.modelComboBox.getSelectedItem();
        if (model.equals("your custom model")) {
            return true;
        }
        try {
            String path = Cellpose.findPretrainedModelInstalled(model, this.consumer.getModelsDir());
            if (path == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void installModelWeights(CountDownLatch latch) {
        Consumer<Double> cons = d -> {
            double perc = (double)Math.round(d * 1000.0) / 10.0;
            SwingUtilities.invokeLater(() -> {
                this.footer.bar.setValue((int)Math.floor(perc));
                this.footer.bar.setString(perc + "% of weights");
            });
        };
        SwingUtilities.invokeLater(() -> this.footer.bar.setIndeterminate(false));
        Thread dwnlThread = new Thread(() -> {
            try {
                Cellpose.donwloadPretrained((String)this.modelComboBox.getSelectedItem(), this.consumer.getModelsDir(), cons);
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            latch.countDown();
            this.checkModelInstallationFinished(latch);
        });
        dwnlThread.start();
    }

    private void installEnv(CountDownLatch latch) {
        String msg = "Installation of Python environments might take up to 20 minutes.";
        String question = "Install Python for Cellpose";
        if (Cellpose.isInstalled() || JOptionPane.showConfirmDialog(null, msg, question, 0) != 0) {
            latch.countDown();
            this.checkModelInstallationFinished(latch);
            return;
        }
        JDialog installerFrame = new JDialog();
        installerFrame.setTitle("Installing Cellpose");
        installerFrame.setDefaultCloseOperation(0);
        Runnable callback = () -> {
            this.checkModelInstallationFinished(latch);
            if (installerFrame.isVisible()) {
                installerFrame.dispose();
            }
        };
        InstallEnvWorker worker = new InstallEnvWorker("Cellpose", latch, callback);
        EnvironmentInstaller installerPanel = EnvironmentInstaller.create(worker);
        Consumer<String> cons = s -> {
            installerPanel.updateText((String)s, Color.black);
            if (latch.getCount() != 1L) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                if (!this.footer.bar.isIndeterminate() || this.footer.bar.isIndeterminate() && !this.footer.bar.getString().equals("Installing Python")) {
                    this.footer.bar.setIndeterminate(true);
                    this.footer.bar.setString("Installing Python");
                }
            });
        };
        worker.setConsumer(cons);
        worker.execute();
        installerPanel.addToFrame(installerFrame);
        installerFrame.setSize(600, 300);
    }

    private void checkModelInstallationFinished(CountDownLatch latch) {
        if (latch.getCount() == 0L) {
            this.startModelInstallation(false);
        }
    }

    private void startModelInstallation(boolean isStarting) {
        SwingUtilities.invokeLater(() -> {
            this.footer.buttons.runButton.setEnabled(!isStarting);
            this.footer.buttons.installButton.setEnabled(!isStarting);
            this.modelComboBox.setEnabled(!isStarting);
            this.diameterField.setEnabled(!isStarting);
            this.cytoCbox.setEnabled(!isStarting);
            this.nucleiCbox.setEnabled(!isStarting);
            this.check.setEnabled(!isStarting);
            if (isStarting) {
                this.footer.bar.setString("Checking cellpose installed...");
                this.footer.bar.setIndeterminate(true);
            } else {
                this.footer.bar.setIndeterminate(false);
                this.footer.bar.setValue(0);
                this.footer.bar.setString("");
            }
        });
    }

    private void browseFiles() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        int option = fileChooser.showOpenDialog(this);
        if (option == 0) {
            this.customModelPathField.setText(fileChooser.getSelectedFile().getAbsolutePath());
        }
    }
}

