/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui.custom;

import io.bioimage.modelrunner.gui.custom.ButtonsPanel;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class FooterPanel
extends JPanel {
    private static final long serialVersionUID = 5381352117710530216L;
    protected ButtonsPanel buttons;
    protected JProgressBar bar;
    private static final double BUTTON_WRATIO = 0.5;
    private static final Dimension MIN_D = new Dimension(20, 10);

    protected FooterPanel() {
        this.setLayout(null);
        this.buttons = new ButtonsPanel();
        this.bar = new JProgressBar();
        this.bar.setStringPainted(true);
        this.bar.setString("");
        this.add(this.buttons);
        this.add(this.bar);
        this.setMinimumSize(MIN_D);
        this.organiseComponents();
    }

    private void organiseComponents() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int rawW = FooterPanel.this.getWidth();
                int rawH = FooterPanel.this.getHeight();
                int inset = 2;
                int w = (int)((double)(rawW - inset) * 0.5);
                FooterPanel.this.bar.setBounds(0, inset, w, rawH - 2 * inset);
                FooterPanel.this.buttons.setBounds(w + inset, 0, w, rawH);
            }
        });
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("Buttons pannel");
                frame.setDefaultCloseOperation(3);
                frame.getContentPane().add(new FooterPanel());
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                frame.setSize(200, 200);
            }
        });
    }
}

