/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.deepicy.tensor;

import io.bioimage.modelrunner.tensor.Tensor;
import java.util.ArrayList;
import java.util.Arrays;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import org.apache.poi.ss.usermodel.Workbook;
import plugins.adufour.workbooks.IcySpreadSheet;
import plugins.adufour.workbooks.Workbooks;

public class ImgLib2ToWorkBook {
    private ImgLib2ToWorkBook() {
    }

    public static Workbook build(Tensor tensor) throws IllegalArgumentException {
        ImgLib2ToWorkBook.assertList(tensor);
        return ImgLib2ToWorkBook.build(tensor.getData(), tensor.getAxesOrder());
    }

    public static <T extends RealType<T> & NativeType<T>> Workbook build(RandomAccessibleInterval<T> data, String axesOrder) throws IllegalArgumentException {
        ImgLib2ToWorkBook.assertList(data);
        return ImgLib2ToWorkBook.build(data, Tensor.convertToTensorDimOrder((String)axesOrder));
    }

    public static <T extends Type<T>> Workbook build(RandomAccessibleInterval<T> data, int[] axesOrder) throws IllegalArgumentException {
        Type dtype = (Type)Util.getTypeFromInterval(data);
        long[] dataShape = data.dimensionsAsLongArray();
        ImgLib2ToWorkBook.checkTensorDimOrder(dataShape, axesOrder);
        int[] completeDimOrder = ImgLib2ToWorkBook.completeImageDimensions(axesOrder);
        int[] seqDimOrder = ImgLib2ToWorkBook.getSequenceDimOrder(completeDimOrder);
        int[] seqSize = ImgLib2ToWorkBook.getListSize(seqDimOrder, ImgLib2ToWorkBook.completeTableSize(dataShape));
        if (dtype instanceof IntType || dtype instanceof UnsignedByteType) {
            return ImgLib2ToWorkBook.buildFromTensorInt(seqSize, seqDimOrder, data);
        }
        if (dtype instanceof ByteType) {
            return ImgLib2ToWorkBook.buildFromTensorByte(seqSize, seqDimOrder, data);
        }
        if (dtype instanceof FloatType) {
            return ImgLib2ToWorkBook.buildFromTensorFloat(seqSize, seqDimOrder, data);
        }
        if (dtype instanceof DoubleType) {
            return ImgLib2ToWorkBook.buildFromTensorDouble(seqSize, seqDimOrder, data);
        }
        throw new IllegalArgumentException("Unsupported tensor type: " + dtype);
    }

    private static Workbook buildFromTensorByte(int[] listSize, int[] listDimOrder, RandomAccessibleInterval<ByteType> rai) {
        Cursor tensorCursor;
        Workbook wb = Workbooks.createEmptyWorkbook();
        int[] auxCounter = new int[3];
        if (rai instanceof IntervalView) {
            tensorCursor = ((IntervalView)rai).cursor();
        } else if (rai instanceof Img) {
            tensorCursor = ((Img)rai).cursor();
        } else {
            throw new IllegalArgumentException("Fourth parameter has to be an instance of " + Img.class + " or " + IntervalView.class);
        }
        byte[][][] workbookMatrix = new byte[listSize[0]][listSize[1]][listSize[2]];
        while (tensorCursor.hasNext()) {
            tensorCursor.fwd();
            long[] cursorPos = tensorCursor.positionAsLongArray();
            for (int i = 0; i < cursorPos.length; ++i) {
                auxCounter[i] = (int)cursorPos[i];
            }
            byte val = ((ByteType)tensorCursor.get()).getByte();
            int[] icyInd = new int[]{auxCounter[listDimOrder[0]], auxCounter[listDimOrder[1]], auxCounter[listDimOrder[2]]};
            workbookMatrix[icyInd[0]][icyInd[1]][icyInd[2]] = val;
        }
        for (int batch = 0; batch < listSize[0]; ++batch) {
            IcySpreadSheet sheet = Workbooks.getSheet((Workbook)wb, (String)("" + batch));
            for (int col = 0; col < listSize[1]; ++col) {
                sheet.setRow(col, new Object[]{workbookMatrix[batch][col]});
            }
        }
        return wb;
    }

    private static Workbook buildFromTensorInt(int[] listSize, int[] listDimOrder, RandomAccessibleInterval<IntType> rai) {
        Cursor tensorCursor;
        Workbook wb = Workbooks.createEmptyWorkbook();
        int[] auxCounter = new int[3];
        if (rai instanceof IntervalView) {
            tensorCursor = ((IntervalView)rai).cursor();
        } else if (rai instanceof Img) {
            tensorCursor = ((Img)rai).cursor();
        } else {
            throw new IllegalArgumentException("Fourth parameter has to be an instance of " + Img.class + " or " + IntervalView.class);
        }
        int[][][] workbookMatrix = new int[listSize[0]][listSize[1]][listSize[2]];
        while (tensorCursor.hasNext()) {
            tensorCursor.fwd();
            long[] cursorPos = tensorCursor.positionAsLongArray();
            for (int i = 0; i < cursorPos.length; ++i) {
                auxCounter[i] = (int)cursorPos[i];
            }
            int val = ((IntType)tensorCursor.get()).getInteger();
            int[] icyInd = new int[]{auxCounter[listDimOrder[0]], auxCounter[listDimOrder[1]], auxCounter[listDimOrder[2]]};
            workbookMatrix[icyInd[0]][icyInd[1]][icyInd[2]] = val;
        }
        for (int batch = 0; batch < listSize[0]; ++batch) {
            IcySpreadSheet sheet = Workbooks.getSheet((Workbook)wb, (String)("" + batch));
            for (int col = 0; col < listSize[1]; ++col) {
                sheet.setRow(col, new Object[]{workbookMatrix[batch][col]});
            }
        }
        return wb;
    }

    private static Workbook buildFromTensorFloat(int[] listSize, int[] listDimOrder, RandomAccessibleInterval<FloatType> rai) {
        Cursor tensorCursor;
        Workbook wb = Workbooks.createEmptyWorkbook();
        int[] auxCounter = new int[3];
        if (rai instanceof IntervalView) {
            tensorCursor = ((IntervalView)rai).cursor();
        } else if (rai instanceof Img) {
            tensorCursor = ((Img)rai).cursor();
        } else {
            throw new IllegalArgumentException("Fourth parameter has to be an instance of " + Img.class + " or " + IntervalView.class);
        }
        float[][][] workbookMatrix = new float[listSize[0]][listSize[1]][listSize[2]];
        while (tensorCursor.hasNext()) {
            tensorCursor.fwd();
            long[] cursorPos = tensorCursor.positionAsLongArray();
            for (int i = 0; i < cursorPos.length; ++i) {
                auxCounter[i] = (int)cursorPos[i];
            }
            float val = ((FloatType)tensorCursor.get()).getRealFloat();
            int[] icyInd = new int[]{auxCounter[listDimOrder[0]], auxCounter[listDimOrder[1]], auxCounter[listDimOrder[2]]};
            workbookMatrix[icyInd[0]][icyInd[1]][icyInd[2]] = val;
        }
        for (int batch = 0; batch < listSize[0]; ++batch) {
            IcySpreadSheet sheet = Workbooks.getSheet((Workbook)wb, (String)("" + batch));
            for (int col = 0; col < listSize[1]; ++col) {
                sheet.setRow(col, new Object[]{workbookMatrix[batch][col]});
            }
        }
        return wb;
    }

    private static Workbook buildFromTensorDouble(int[] listSize, int[] listDimOrder, RandomAccessibleInterval<DoubleType> rai) {
        Cursor tensorCursor;
        Workbook wb = Workbooks.createEmptyWorkbook();
        int[] auxCounter = new int[3];
        if (rai instanceof IntervalView) {
            tensorCursor = ((IntervalView)rai).cursor();
        } else if (rai instanceof Img) {
            tensorCursor = ((Img)rai).cursor();
        } else {
            throw new IllegalArgumentException("Fourth parameter has to be an instance of " + Img.class + " or " + IntervalView.class);
        }
        double[][][] workbookMatrix = new double[listSize[0]][listSize[1]][listSize[2]];
        while (tensorCursor.hasNext()) {
            tensorCursor.fwd();
            long[] cursorPos = tensorCursor.positionAsLongArray();
            for (int i = 0; i < cursorPos.length; ++i) {
                auxCounter[i] = (int)cursorPos[i];
            }
            double val = ((DoubleType)tensorCursor.get()).getRealDouble();
            int[] icyInd = new int[]{auxCounter[listDimOrder[0]], auxCounter[listDimOrder[1]], auxCounter[listDimOrder[2]]};
            workbookMatrix[icyInd[0]][icyInd[1]][icyInd[2]] = val;
        }
        for (int batch = 0; batch < listSize[0]; ++batch) {
            IcySpreadSheet sheet = Workbooks.getSheet((Workbook)wb, (String)("" + batch));
            for (int col = 0; col < listSize[1]; ++col) {
                sheet.setRow(col, new Object[]{workbookMatrix[batch][col]});
            }
        }
        return wb;
    }

    private static void checkTensorDimOrder(long[] dataShape, int[] tensorDimOrder) throws IllegalArgumentException {
        if (tensorDimOrder.length != dataShape.length) {
            throw new IllegalArgumentException("Tensor dim order array length is different than number of dimensions in tensor (" + tensorDimOrder.length + " != " + dataShape.length + ")");
        }
    }

    private static int[] getListSize(int[] seqDimOrder, long[] shape) {
        int[] dims = new int[]{1, 1, 1};
        for (int i = 0; i < seqDimOrder.length; ++i) {
            dims[seqDimOrder[i]] = (int)shape[i];
        }
        return dims;
    }

    private static long[] completeTableSize(long[] tableSize) {
        long[] completeTableSize = new long[]{1L, 1L, 1L};
        for (int i = 0; i < tableSize.length; ++i) {
            completeTableSize[i] = tableSize[i];
        }
        return completeTableSize;
    }

    private static int[] completeImageDimensions(int[] tensorDimOrder) {
        int nTotalImageDims = 3;
        int nTensorDims = tensorDimOrder.length;
        int missingDims = nTotalImageDims - nTensorDims;
        int[] missingDimsArr = new int[missingDims];
        int c = 0;
        for (int ii : new int[]{2, 3, 4}) {
            if (!Arrays.stream(tensorDimOrder).noneMatch(i -> i == ii)) continue;
            missingDimsArr[c++] = ii;
        }
        int[] completeDims = new int[nTotalImageDims];
        System.arraycopy(tensorDimOrder, 0, completeDims, 0, tensorDimOrder.length);
        System.arraycopy(missingDimsArr, 0, completeDims, tensorDimOrder.length, missingDimsArr.length);
        return completeDims;
    }

    private static int[] getSequenceDimOrder(int[] tensorDimOrder) {
        ArrayList<Integer> neededOrder = new ArrayList<Integer>();
        neededOrder.add(4);
        neededOrder.add(3);
        neededOrder.add(2);
        int[] seqDimOrder = new int[]{-1, -1, -1};
        for (int i = 0; i < tensorDimOrder.length; ++i) {
            seqDimOrder[i] = neededOrder.indexOf(tensorDimOrder[i]);
        }
        return seqDimOrder;
    }

    private static void assertList(Tensor arr) {
        if (arr.isImage()) {
            throw new IllegalArgumentException("In order to display a tensor as a List, it cannot be defined as an image. To do so: tensor.setIsImage(false)");
        }
        if (arr.getShape().length > 3) {
            throw new IllegalArgumentException("Icy can only represent tensors as list when they have at most 3 dimensions. The tensor '" + arr.getName() + "' has " + arr.getShape().length + " dimensions (" + arr.getAxesOrderString() + ").");
        }
    }

    private static <T extends Type<T>> void assertList(RandomAccessibleInterval<T> arr) {
        if (arr.dimensionsAsLongArray().length > 3) {
            throw new IllegalArgumentException("Icy can only represent tensors as list when they have at most 3 dimensions. The INDArray od interest has " + arr.dimensionsAsLongArray().length + " dimensions.");
        }
    }
}

